<head>
  <title>title</title>
  <style>
    table {
      border-collapse: collapse;
    }

    th,
    td {
      mso-border: solid thin black;
      mso-border-alt: solid thin black;
    }

    .txt-right {
      text-align: right !important;
    }

    .text-left {
      text-align: left;
    }
  </style>
</head>
<?php
$modelMasCurrency =  new MasCurrency();
$decimal_no = $modelMasCurrency->baseCurrencyForExcel();

?>

<table border="1">

  <thead>
    <tr style=" ">
      <th style=" " colspan="<?php echo $level + 3 ?>">
        <?php
        $modelCompany =  MasCompany::model()->find();

        echo $modelCompany->company_name;
        ?>
      </th>
    </tr>
    <tr>

    </tr>
    <tr style="">
      <th style="color: white ;background-color:#696969;" colspan="<?php echo $level + 3 ?>">Profit And Loss</th>
    </tr>

    <tr colspan="2">
      <td><b>From</b></td>
      <td colspan="3" class="text-left">
        <?php echo date('d/m/Y', strtotime($from_date)); ?>
      </td>
    </tr>

    <tr colspan="2">
      <td><b>To</b></td>
      <td colspan="<?php echo $level + 2 ?>" class="text-left">
        <?php echo date('d/m/Y', strtotime($to_date)); ?>
      </td>
    </tr>
    <tr colspan="2">
      <td><b>Level</b></td>
      <td colspan="<?php echo $level + 2 ?>" class="text-left">
        <?php echo $level; ?>
      </td>
    </tr>

    <?php if ((int)$outlet_id > 0) { ?>
      <tr colspan="2">
        <td><b>Outlet</b></td>
        <td colspan="<?php echo $level + 2 ?>" class="text-left">
          <?php
          if ((int)$outlet_id == 0) {
            echo 'All Outlet';
          } else {
            $modelMasOutlet = new MasOutlet();
            $modelMasOutlet = $modelMasOutlet->findBypk((int)$outlet_id);
            echo $modelMasOutlet->outlet_name;
          }
          ?>
        </td>
      </tr>
    <?php } ?>
    <?php if ((int)$warehouse_id > 0) { ?>
      <tr colspan="2">
        <td><b>Warehouse</b></td>
        <td colspan="<?php echo $level + 2 ?>" class="text-left">
          <?php
          if ((int)$warehouse_id == 0) {
            echo 'All Warehouse';
          } else {
            $modelMasInventoryWarehouse = new MasInventoryWarehouse();
            $modelMasInventoryWarehouse = $modelMasInventoryWarehouse->findBypk((int)$warehouse_id);
            echo $modelMasInventoryWarehouse->warehouse_name;
          }
          ?>
        </td>
      </tr>
    <?php } ?>
    <?php if ((int)$department_id > 0) { ?>
      <tr colspan="2">
        <td><b>Department</b></td>
        <td colspan="<?php echo $level + 2 ?>" class="text-left">
          <?php
          if ((int)$department_id == 0) {
            echo 'All Department';
          } else {
            $modelMasDepartment = new MasDepartment();
            $modelMasDepartment = $modelMasDepartment->findBypk((int)$department_id);
            echo $modelMasDepartment->department_name;
          }
          ?>
        </td>
      </tr>
    <?php } ?>
    <?php if ((int)$brand > 0) { ?>
      <tr colspan="2">
        <td><b>Brand</b></td>
        <td colspan="<?php echo $level + 2 ?>" class="text-left">
          <?php
          if ((int)$brand == 0) {
            echo 'All Brand';
          } else {
            $modelProductClass = new ProductClass();
            $modelProductClass = $modelProductClass->findBypk((int)$brand);
            echo $modelProductClass->product_class;
          }
          ?>
        </td>
      </tr>
    <?php } ?>

    <tr></tr>


    <tr style="background-color:#dbe1dd;" class="to tol1">
      <th style="color: white ;background-color:#696969;" class="cell-left">Account No.</th>
      <th style="color: white ;background-color:#696969;" colspan="<?php echo $level; ?>" class="cell-left">Description</th>
      <th style="color: white ;background-color:#696969;">Debit</th>
      <th style="color: white ;background-color:#696969;">Credit</th>
    </tr>
  </thead>
  <?php
  /* filter conditions  ----start---- */
  $condition = ' is_posted="Y" ';
  if (!empty($from_date)) {
    $from_date = str_replace('/', '-', $from_date);
    $from_date = date('Y-m-d', strtotime($from_date));
    $condition .= ' AND voucher_date >="' . $from_date . '"';
  }
  if (!empty($to_date)) {
    $to_date = str_replace('/', '-', $to_date);
    $to_date = date('Y-m-d', strtotime($to_date));
    $condition .= ' AND voucher_date <="' . $to_date . '"';
  }
  if ((int)($brand > 0)) {
    $condition .= " AND  brand_id = '" . $brand . "'";
  }


  if ((int)($outlet_id > 0)) {
    $condition .= " AND  outlet_id = '" . $outlet_id . "'";
  }


  if ((int)($warehouse_id > 0)) {
    $condition .= " AND  warehouse_id = '" . $warehouse_id . "'";
  }

  if ((int)($department_id > 0)) {
    $condition .= " AND  department_id = '" . $department_id . "'";
  }

  $maincondition = '';
  if ($level > 0) {
    $maincondition .= " AND level <= '{$level}'";
  }

  /* filter conditions  ----end---- */
  /*merged query for all ledger List In Profit AND LOSS*/
  $pl_transactions_query = "
                CREATE OR REPLACE VIEW view_acc_transactions_pl AS (
                        SELECT
                            ledger_id,root,
                            ledger_acc_no,
                            ledger_acc_name,
                            level,
                            is_parent,
                            ledger_main_acc,
                            IFNULL(SUM(debit + credit),
                            0) AS amount,COUNT(ledger_id) AS transaction_count,ledger_parent_acc
                        FROM
                            view_account_voucher_items
                        WHERE
                            {$condition}
                        GROUP BY
                            ledger_id
                    )
                    UNION ALL
                    (
                        SELECT
                            id AS ledger_id,root,
                            ledger_acc_no,
                            ledger_acc_name,
                            level,
                            is_parent,
                            ledger_main_acc,
                            0 AS amount,0 AS transaction_count,ledger_parent_acc
                        FROM
                            erp_acc_ledger
                        WHERE 1=1 {$maincondition}
                    )
    ";
  Yii::app()->db->createCommand($pl_transactions_query)->execute();
  $pl_query = "
            CREATE OR REPLACE VIEW view_profit_and_loss AS
            SELECT
                ledger_id,root,
                ledger_acc_no,
                ledger_acc_name,
                level,
                is_parent,
                ledger_main_acc,
                IFNULL(SUM(amount),
                0) AS amount,IFNULL(SUM(transaction_count),
                0) AS transaction_count,ledger_parent_acc
            FROM
               view_acc_transactions_pl
            WHERE 1=1 AND ledger_main_acc IN ('I','E','GP','NP','EB','CO') {$maincondition}
            GROUP BY
                ledger_id";
  Yii::app()->db->createCommand($pl_query)->execute();

  // ---------------------------------------------------------------------------------
  // ---------------------------------------------------------------------------------
  $modelMasCurrency =  new MasCurrency();
  $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
  $closing_stock                 = $modelAccSystemAccountsMapping->getSystemdefault('closing_stock');
  $opening_stock                 = $modelAccSystemAccountsMapping->getSystemdefault('opening_stock');

  $closing_stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_closing_stock_state_as_of AS
                                        (SELECT S.id AS product_id, S.part_number, S.description ,
                                        S.bar_code, S.brand_class_id AS brand_id,B.product_class AS brand,L.warehouse_id,SUM(L.quantity * unit_factor) AS quantity,
                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,
                                         S.generic_id, G.generic_name 
                                        FROM erp_stock_ledger L
                                        LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id
                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        WHERE S.inventory_item_type IN (1,3) 
                                        AND L.transaction_date <= "' . $to_date . '" AND stock_updated="Y" 
                                        GROUP BY L.warehouse_id,S.id)
                                        UNION ALL 
                                        (SELECT S.id AS product_id,S.part_number,S.description,S.bar_code,S.brand_class_id AS brand_id,B.product_class AS brand,"0" AS warehouse_id,
                                        "0" AS quantity ,S.rate,S.generic_id,G.generic_name
                                        FROM erp_store S 
                                        LEFT JOIN erp_product_class B ON B.id = S.brand_class_id 
                                        LEFT JOIN  erp_inventory_generic_name G ON  G.id = S.generic_id
                                        LEFT JOIN erp_unit_of_measurement U ON U.product_id = S.id)
                                        ORDER BY part_number ';
  Yii::app()->db->createCommand($closing_stock_state_as_of_query)->execute();

  $opening_stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_opening_stock_state_as_of AS
                                        (SELECT S.id AS product_id, S.part_number, S.description ,
                                        S.bar_code, S.brand_class_id AS brand_id,B.product_class AS brand,L.warehouse_id,SUM(L.quantity * unit_factor) AS quantity,
                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,
                                         S.generic_id, G.generic_name 
                                        FROM erp_stock_ledger L
                                        LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id
                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        WHERE S.inventory_item_type IN (1,3) 
                                        AND L.transaction_date <= "' . $from_date . '" AND stock_updated="Y" 
                                        GROUP BY L.warehouse_id,S.id)
                                        UNION ALL 
                                        (SELECT S.id AS product_id,S.part_number,S.description,S.bar_code,S.brand_class_id AS brand_id,B.product_class AS brand,"0" AS warehouse_id,
                                        "0" AS quantity ,S.rate,S.generic_id,G.generic_name
                                        FROM erp_store S 
                                        LEFT JOIN erp_product_class B ON B.id = S.brand_class_id 
                                        LEFT JOIN  erp_inventory_generic_name G ON  G.id = S.generic_id
                                        LEFT JOIN erp_unit_of_measurement U ON U.product_id = S.id)
                                        ORDER BY part_number ';
  Yii::app()->db->createCommand($opening_stock_state_as_of_query)->execute();



  $closing_balance_amt = -1 * Yii::app()->db->createCommand("SELECT IFNULL(SUM(rate*quantity),0) FROM view_closing_stock_state_as_of ")->queryScalar();
  $opening_balance_amt = Yii::app()->db->createCommand("SELECT IFNULL(SUM(rate*quantity),0) FROM view_opening_stock_state_as_of ")->queryScalar();
  // ---------------------------------------------------------------------------------
  // ---------------------------------------------------------------------------------

  $pb_sql = "SELECT * FROM view_profit_and_loss ORDER BY  level DESC";
  $arr_plledgers = Yii::app()->db->createCommand($pb_sql)->queryAll();
  $led_sql = "SELECT * FROM erp_acc_ledger WHERE 1=1 AND ledger_main_acc IN ('I','E','GP','NP','EB','CO'){$maincondition} ORDER BY  ledger_acc_no ASC";
  $arr_ledgers = Yii::app()->db->createCommand($led_sql)->queryAll();
  $arr_tb = [];
  foreach ($arr_ledgers as $eachledger) {
    $arr_tb[$eachledger['id']]['amount'] = 0;
    $arr_tb[$eachledger['id']]['transaction_count'] = 0;
  }
  foreach ($arr_plledgers as $eachledger) {
    $arr_tb[$eachledger['ledger_id']]['transaction_count'] = $eachledger['transaction_count'];
    $arr_tb[$eachledger['ledger_id']]['amount'] += $eachledger['amount'];
    if ((int)$eachledger['ledger_parent_acc'] > 0) {
      $arr_tb[(int)$eachledger['ledger_parent_acc']]['amount'] += $arr_tb[$eachledger['ledger_id']]['amount'];
    }
    // -------------------------------------------------------
    if ($eachledger['ledger_id'] == $closing_stock) {
      $arr_tb[$closing_stock]['amount'] += $closing_balance_amt;
      if ((int)$eachledger['ledger_parent_acc'] > 0) {
        $arr_tb[(int)$eachledger['ledger_parent_acc']]['amount'] +=  $closing_balance_amt;
      }
    }
    if ($eachledger['ledger_id'] == $opening_stock) {
      $arr_tb[$opening_stock]['amount'] += $opening_balance_amt;
      if ((int)$eachledger['ledger_parent_acc'] > 0) {
        $arr_tb[(int)$eachledger['ledger_parent_acc']]['amount'] += $opening_balance_amt;
      }
    }
    // -------------------------------------------------------

  }

  foreach ($arr_ledgers as $eachledger) {
    $style_tr = '';
    $debit = 0.00;
    $credit = 0.00;
    $netamount = 0.00;
    //Net Profit
    if (in_array($eachledger['ledger_main_acc'], ['NP', 'GP', 'EB'])) {
      $sqlVI = "SELECT IFNULL(SUM(amount),0) FROM view_profit_and_loss WHERE ledger_main_acc IN ('I','E') AND  ledger_acc_no<=" . $eachledger['ledger_acc_no'];
      $netamount = Yii::app()->db->createCommand($sqlVI)->queryScalar();
      if ($netamount > 0) {
        $debit = $netamount;
        $style_tr = ' levelnetloss';
      } else {
        $credit = $netamount;
        $style_tr = ' levelnet';
      }
    } else {
      if ($arr_tb[$eachledger['id']]['amount'] > 0) {
        $debit = $arr_tb[$eachledger['id']]['amount'];
      } else {
        $credit = $arr_tb[$eachledger['id']]['amount'];
      }
    }




  ?>
    <?php
    if ($company < 0 || $company == '') {
      $company = 0;
    }
    if ($eachledger['is_parent'] == 'N') {
      $count = $arr_tb[$eachledger['id']]['transaction_count'];
      if ($eachledger['have_subledger'] == 'Y') {
        $link = 'js:load_pl_summary_pl(' . $eachledger['id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
      } else {
        if ($count < 300) {
          $link = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
        } else {
          $link = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
        }
      }
      if ($eachledger['id'] == $closing_stock) {
        if ($count < 300) {
          $linkop = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($from_date)) . '\')';
          $linkcl = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
        } else {
          $linkop = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' .  date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($from_date)) . '\')';
          $linkcl = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' .  date('31/12/2022') . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
        }
      }
      $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
    } else {
      $link = '';
      $accountName = '' . $eachledger['ledger_acc_name'] . '';
    }
    if ($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachledger['level'] == 1) { ?>
      <tr class="l<?php echo $eachledger['level'] . $style_tr; ?> level<?php echo $eachledger['level']; ?>">
        <td><?php echo $eachledger['ledger_acc_no']; ?></td>
        <?php for ($i = 1; $i <= $level; $i++) {
          $style = '';
          if ($eachledger['is_parent'] == 'Y') {
            $style = 'font-weight: bold;';
          }
        ?>
          <td style="<?php echo $style; ?>"><?php echo ($eachledger['level'] == $i) ? $eachledger['ledger_acc_name'] : ''; ?></td>
        <?php } ?>
        </td>
        <td class="txt-right" style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit, true);  ?></td>
        <td class="txt-right" style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit), true);  ?></td>
      </tr>
  <?php
    }
  }
  ?>
</table>