<!--
chart of accounts
Balance Sheet report
Date 09-04-2025
author -Sebi
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }
    .levelnet {
        background: #a8d08d;
        color: black;
    }
    .levelnetloss {
        background: #e87b7b;
        color: black;
    }
    .to {
        background: rgb(31 103 178);
        color: White;
    }
    .tol1 {
        font-size: 16px !important;
    }
    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }
    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }
    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }
    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }
    .level-5 {
        padding-left: 267px !important;
    }
    .l1 {
        font-size: 17px !important;
    }
    .l2 {
        font-size: 16px !important;
    }
    .l3 {
        font-size: 15px !important;
    }
    .l4 {
        font-size: 14px !important;
    }
    .l5 {
        font-size: 14px !important;
    }
    .txt-right {
        text-align: right !important;
    }
</style>
<table class="table-tree">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' is_posted="Y" ';
    $from_date='2020-06-01';
   
    if ($to_date != '') {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
    }
    if ((int)$company>0) {
        $condition .= " AND company_id = '{$company}'";
    }
  
    if ((int)$salesgroup>0) {
        $condition .= " AND salegroup_id = '{$salesgroup}'";
    }
    if ((int)$brand>0) {
        $condition .= " AND  brand_id = '" . $brand . "'";
    }
  
    if ((int)$department_id>0) {
        $condition .= " AND department_id = '{$department_id}'";
    }
    if ((int)$warehouse_id>0) {
        $condition .= " AND warehouse_id = '{$warehouse_id}'";
    }
    if ((int)$outlet_id>0) {
        $condition .= " AND outlet_id = '{$outlet_id}'";
    }
    
    $condition .= ' AND voucher_date <="' . $to_date . '"';
    /* filter conditions  ----end---- */
    
   
    $maincondition ='';
    if($level>0){
        $maincondition .= " AND level <= '{$level}'";
    }

    $modelMasCurrency =  new MasCurrency();
    $auditCloseLedgerResults = isset($balanceSheetDetails['auditCloseLedgerResults'])?$balanceSheetDetails['auditCloseLedgerResults']:array();
    $net_profit_acc_no = isset($balanceSheetDetails['net_profit_acc_no'])?$balanceSheetDetails['net_profit_acc_no']:'';
    $auditcloseDetailsAll = isset($balanceSheetDetails['auditcloseDetailsAll'])?$balanceSheetDetails['auditcloseDetailsAll']:'';
    
    foreach ($auditCloseLedgerResults as $eachledger) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        if ($eachledger['ledger_main_acc'] == 'AP') {
            if ($eachledger['amount'] > 0) {
                $debit = $eachledger['amount'];
                $style_tr = ' levelnetloss';
            } else {
                $credit = $eachledger['amount'];
                $style_tr = ' levelnet';
            }
        } else {
            if ($eachledger['amount'] > 0) {
                $debit = $eachledger['amount'];
            } else {
                $credit = $eachledger['amount'];
            }
        }
        /* Total Sum needs only level 1 sum*/
        if ($eachledger['level'] == '1' || $eachledger['ledger_main_acc'] == 'AP') {
            /*For showing Totals at end --start*/
            $sum_debit += $debit;
            $sum_credit += $credit;
            /*For showing Totals at end --end*/            
        }
        if ($company < 0 || $company=='') {
            $company = 0;
        }
        if ($eachledger['is_parent'] == 'N') {
            $count =$eachledger['transaction_count'];
               
            if ($eachledger['have_subledger'] == 'Y') {
                $link = 'js:load_balance_summary_pl(' . $eachledger['id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
            } else {
                if ($count < 300) {
                    $link = 'js:Load_balance_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
                    $link = 'js:load_balance_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
            $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
        } else {
            $link = '';
            $accountName = '' . $eachledger['ledger_acc_name'] . '';
        }
        $accountNo = $eachledger['ledger_acc_no'];
        $accountLevel = $eachledger['level'];
        if ($eachledger['ledger_main_acc'] == 'AP') {
            $accountName = 'NET PROFIT';
            $accountNo = $net_profit_acc_no;
            $accountLevel = 1;
        }
        if($type!='NZ'||abs($debit)>0||abs($credit)>0||$eachledger['level']==1){
            if ($level && $eachledger['level'] <= $level) {?>
                <tr class="l<?php echo $accountLevel.$style_tr; ?> level<?php echo $accountLevel; ?>">
                    <td class="l1"><?php echo $accountNo; ?></td>
                    <td class="level-<?php echo $accountLevel; ?> l<?php echo $accountLevel; ?>"><b><?php echo $accountName; ?></b></td>
                    <td  class="txt-right l<?php echo $accountLevel; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit)); ?></b></td>
                    <td  class="txt-right l<?php echo $accountLevel; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit));  ?></b></td>
                </tr>
                <?php if ($eachledger['ledger_main_acc'] == 'AP') {
                    if ($auditcloseDetailsAll) {
                        $accountLevel = 2;
                        $style_tr = '';
                        foreach ($auditcloseDetailsAll as $ada => $auditcloseDetails) {
                            if ($auditcloseDetails['netprofit'] > 0) {
                                $debit = $auditcloseDetails['netprofit'];
                            } else {
                                $credit = $auditcloseDetails['netprofit'];
                            } ?>
                            <tr class="l<?php echo $accountLevel.$style_tr; ?> level<?php echo $accountLevel; ?>">
                                <td class="l1"><?php //echo $accountNo; ?></td>
                                <td class="level-<?php echo $accountLevel; ?> l<?php echo $accountLevel; ?>"><b><?php echo $auditcloseDetails['name']; ?></b></td>
                                <td  class="txt-right l<?php echo $accountLevel; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit)); ?></b></td>
                                <td  class="txt-right l<?php echo $accountLevel; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></b></td>
                            </tr>
                        <?php }
                    }
                }
            }
        }
    } ?>
    <tr>
        <td></td><td></td><td></td><td></td>
    </tr>
    <tr class="to tol1"><td></td><td><b>Total</b></td>
        <td  class="txt-right  "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($sum_debit);  ?></td>
        <td  class="txt-right "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($sum_credit)); ?></td>
    </tr>
</table>