<!--
chart of accounts
Balance Sheet report
Date 20-04-2025
author -Sebi
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }
    .levelnet {
        background: #a8d08d;
        color: black;
    }
    .levelnetloss {
        background: #e87b7b;
        color: black;
    }
    .to {
        background: rgb(31 103 178);
        color: White;
    }
    .tol1 {
        font-size: 16px !important;
    }
    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }
    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }
    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }
    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }
    .level-5 {
        padding-left: 267px !important;
    }
    .l1 {
        font-size: 17px !important;
    }
    .l2 {
        font-size: 16px !important;
    }
    .l3 {
        font-size: 15px !important;
    }
    .l4 {
        font-size: 14px !important;
    }
    .l5 {
        font-size: 14px !important;
    }
    .txt-right {
        text-align: right !important;
    }
</style>
<table class="table-tree" style="font-size:13px;">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Opening Balance</th>
            <th>Closing Balance</th>

        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' AND is_posted="Y" ';

    if ($from_date != '') {
        $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
    }
    if ($to_date != '') {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
    }
    if (!empty($company)) {
        $condition .= " AND  company_id = '" . $company . "'";
    }
    if (!empty($branch)) {
        $condition .= " AND branch_id = '" . $branch . "'";
    }
    if (!empty($salesgroup)) {
        $condition .= " AND  salegroup_id = '" . $salesgroup . "'";
    }
    if (!empty($brand)) {
        $condition .= " AND  brand_id = '" . $brand . "'";
    }
    if (!empty($costcenter)) {
        $condition .= " AND  costcenter_id = '" . $costcenter . "'";
    }
    if (!empty($department)) {
        $condition .= " AND  department_id = '" . $department . "'";
    }
    if (!empty($project)) {
        $condition .= " AND project_id = '" . $project . "'";
    }
    if (!empty($employee)) {
        $condition .= " AND  employee_id = '" . $employee . "'";
    }
    $condition .= ' AND voucher_date <="' . $to_date . '"';
    /* filter conditions  ----end---- */

    $auditCloseLedgerResults = isset($balanceSheetDetailedDetails['auditCloseLedgerResults'])?$balanceSheetDetailedDetails['auditCloseLedgerResults']:array();
    $net_profit_acc_no = isset($balanceSheetDetailedDetails['net_profit_acc_no'])?$balanceSheetDetailedDetails['net_profit_acc_no']:'';
    $ac_type = isset($balanceSheetDetailedDetails['ac_type'])?$balanceSheetDetailedDetails['ac_type']:'';
    $auditcloseDetailsAll = isset($balanceSheetDetailedDetails['auditcloseDetailsAll'])?$balanceSheetDetailedDetails['auditcloseDetailsAll']:'';

    foreach ($auditCloseLedgerResults as $eachledger) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $opening_amount = 0.00;
        $closing_amount = 0.00;
        if ($ac_type) {
            $opening_amount = $eachledger['amount'];
            $closing_amount = $eachledger['balance'];
        } else {
            $opening_amount = $eachledger['opening'];
            $closing_amount = $eachledger['amount'];
        }
        if ($opening_amount > 0) {
            $symbol = "Dr";
        } else {
            $symbol = "Cr";
        }
        if ($closing_amount > 0) {
            $symbol_closing = "Dr";
        } else {
            $symbol_closing = "Cr";
        }
        if ($eachledger['level'] == '1') {
            /*For showing Totals at end --start*/
            $sum_opening += $opening_amount;
            $sum_closing += $closing_amount;
            /*For showing Totals at end --end*/
        }
        if ($company < 0 || $company == '') {
            $company = 0;
        }
        if ($eachledger['is_parent'] == 'N') {
            $link = 'js:Load_balance_gl_report(' . $eachledger['id'] . ',' . $company . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
            $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
        } else {
            $link = '';
            $accountName = '' . $eachledger['ledger_acc_name'] . '';
        }
        $accountNo = $eachledger['ledger_acc_no'];
        $accountLevel = $eachledger['level'];
        if ($eachledger['ledger_main_acc'] == 'AP') {
            $accountName = 'NET PROFIT';
            $accountNo = $net_profit_acc_no;
            $accountLevel = 1;
            if ($closing_amount > 0) {
                $style_tr = ' levelnetloss';
                $symbol = "Dr";
            } else {
                $style_tr = ' levelnet';
                $symbol = "Cr";
            }
        }
        if ($level && $eachledger['level'] <= $level) {
            if($type!='NZ'||abs($opening_amount)>0||abs($closing_amount)>0){ ?>
            <tr class="l<?= $accountLevel . $style_tr; ?> level<?= $accountLevel; ?>">
                <td class="l1"><?= $accountNo; ?></td>
                <td class="level-<?= $accountLevel; ?> l<?= $accountLevel; ?>"><b><?= $accountName; ?></b></td>
                <td class="txt-right l<?= $accountLevel; ?>"><b><?= Yii::app()->numberFormatter->formatCurrency(abs($opening_amount), "") . " " . $symbol; ?></b></td>
                <td class="txt-right l<?= $accountLevel; ?>"><b><?= Yii::app()->numberFormatter->formatCurrency(abs($closing_amount), "") . " " . $symbol_closing; ?></b></td>
            </tr>
            <?php if ($eachledger['ledger_main_acc'] == 'AP') {
                if ($auditcloseDetailsAll) {
                    $accountLevel = 2;
                    $style_tr = '';
                    foreach ($auditcloseDetailsAll as $ada => $auditcloseDetails) {
                        if (($auditcloseDetails['opening'] || $auditcloseDetails['opening']) > 0) {
                            $netprofit = (float) round(($auditcloseDetails['closing'] - $auditcloseDetails['opening']), 6); ?>
                            <tr class="l<?php echo $accountLevel.$style_tr; ?> level<?php echo $accountLevel; ?>">
                                <td class="l1"><?php //echo $accountNo; ?></td>
                                <td class="level-<?php echo $accountLevel; ?> l<?php echo $accountLevel; ?>"><b><?php echo $auditcloseDetails['name']; ?></b></td>
                                <td  class="txt-right l<?php echo $accountLevel; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($auditcloseDetails['opening']), "") . " " . $symbol; ?></b></td>
                                <td  class="txt-right l<?php echo $accountLevel; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs(($auditcloseDetails['closing'])), "") . " " . $symbol; ?></b></td>
                            </tr>
                        <?php }
                    }
                }
            }}
        } 
    } ?>
    <tr><td></td><td></td><td></td><td></td></tr>
    <tr class="to tol1">
        <td></td>
        <td><b>Total</b></td>
        <td class="txt-right  "><?php echo Yii::app()->numberFormatter->formatCurrency($sum_opening, ""); ?></td>
        <td class="txt-right "><?php echo Yii::app()->numberFormatter->formatCurrency(abs($sum_closing), ""); ?></td>
    </tr>
</table>
