<!--
chart of accounts
Balance Sheet report
Date 03-10-2022
updated- date 15-12-2022
author -Jisha V2
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }

    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }

    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }

    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }

    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }

    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }

    .level-5 {
        padding-left: 267px !important;
    }

    .l1 {
        font-size: 17px !important;
    }

    .l2 {
        font-size: 16px !important;
    }

    .l3 {
        font-size: 15px !important;
    }

    .l4 {
        font-size: 14px !important;
    }

    .l5 {
        font-size: 14px !important;
    }

    .txt-right {
        text-align: right !important;
    }
</style>
<?php
/* taking all ledger List In  Balance Sheet  ----start---- */
$sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger FROM  `erp_acc_ledger` ORDER BY `erp_acc_ledger`.`ledger_acc_no`  ASC";
if ($level > 0) {
    $sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger FROM  `erp_acc_ledger` 
                WHERE ledger_main_acc IN ('A','L','NP') AND
                level<=" . $level . "
                ORDER BY `erp_acc_ledger`.`ledger_acc_no`  ASC";
}
$arr_ledgers = Yii::app()->db->createCommand($sql)->queryAll();
/* taking all ledger List In  Balance Sheet ----end---- */
?>
<table class="table-tree">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' AND is_posted="Y" ';

    if ($from_date != '') {
        $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
    }
    
    
    
    if ($to_date != '') {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
    }
    if (!empty($company)) {
        $condition .= " AND  company_id = '" . $company . "'";
    }
    if (!empty($branch)) {
        $condition .= " AND branch_id = '" . $branch . "'";
    }
    if (!empty($salesgroup)) {
        $condition .= " AND  salegroup_id = '" . $salesgroup . "'";
    }
    if (!empty($brand)) {
        $condition .= " AND  brand_id = '" . $brand . "'";
    }
    if (!empty($costcenter)) {
        $condition .= " AND  costcenter_id = '" . $costcenter . "'";
    }
    /* if (!empty($category)) {
      $condition .= " AND  generic_id = '" . $category . "'";
      } */
    if (!empty($department)) {
        $condition .= " AND  department_id = '" . $department . "'";
    }

    if (!empty($project)) {
        $condition .= " AND project_id = '" . $project . "'";
    }
    /* if (!empty($item)) {
      $condition .= " AND  generic_id = '" . $item . "'";
      } */
    if (!empty($employee)) {
        $condition .= " AND  employee_id = '" . $employee . "'";
    }

    if (!empty($warehouse_id)) {

        $condition .= " AND warehouse_id = '" . $warehouse_id . "'";
    }

    $condition .= ' AND voucher_date <="' . $to_date . '"';
    /* filter conditions  ----end---- */
    //profit in profit and loss on date before from date --start

    $sql_net_profit = "SELECT SUM(debit+credit) AS amount 
        FROM view_account_voucher_items  
        WHERE  ledger_main_acc IN ('I','E') AND is_posted='Y'  AND voucher_date <=' " . $to_date . "'";
    $net_profit = Yii::app()->db->createCommand($sql_net_profit)->queryScalar();


    // ---------------------------------------------------
    $sql_net_profit_opening = "SELECT SUM(debit+credit) AS amount 
        FROM view_account_voucher_items  
        WHERE  ledger_main_acc IN ('I','E') AND is_posted='Y'  AND voucher_date <' " . $from_date . "'";
    $net_profit_opening = Yii::app()->db->createCommand($sql_net_profit_opening)->queryScalar();



    // ---------------------------------------------------
    $sql_net_profit_current_period = "SELECT SUM(debit+credit) AS amount 
        FROM view_account_voucher_items  
        WHERE  ledger_main_acc IN ('I','E') AND is_posted='Y'  AND voucher_date >= '" . $from_date . "' AND voucher_date <=  '" . $to_date . "'";
    $net_profit_current_period = Yii::app()->db->createCommand($sql_net_profit_current_period)->queryScalar();


    // -----------------------------------------------------    

    //profit in profit and loss on date before from date --end
    //net profit ledger --start
    $modelMasCurrency =  new MasCurrency();
    $modelnet_profit_ledger = new AccLedger();
    $modelnet_profit_ledger = $modelnet_profit_ledger->find(array('condition' => 'ledger_main_acc="NP"'));
    //accumulate profit ledger --end

    foreach ($arr_ledgers as $eachledger) {
        $debit_opening = $credit_opening = 0;
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        $debit_current_period = $credit_current_period = 0;
        //ledger_main_acc=net profit
        if ($eachledger['ledger_main_acc'] == 'NP') {
            if ($net_profit > 0) {
                $debit = $net_profit;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $net_profit;
                $style_tr = ' levelnet';
            }


            if ($net_profit_opening > 0) {
                $debit_opening = $net_profit_opening;
                $style_tr_op = ' levelnetloss';
            } else {
                $credit_opening = $net_profit_opening;
                $style_tr_op = ' levelnet';
            }


            if ($net_profit_current_period > 0) {
                $debit_current_period = $net_profit_current_period;
                $style_tr_cp = ' levelnetloss';
            } else {
                $credit_current_period = $net_profit_current_period;
                $style_tr_cp = ' levelnet';
            }
        } else {
            $condition1 = "level>= :level AND root LIKE :root";
            $params = [':level' => $eachledger['level'], ':root' => $eachledger['root'] . '%'];

            $sqlVI = "SELECT IFNULL(SUM(debit+credit),0) As amount FROM view_account_voucher_items WHERE " . $condition1 . $condition;
            // Prepare the statement and bind the parameters
            $command = Yii::app()->db->createCommand($sqlVI);
            $command->bindValues($params);

            // Execute the query and fetch the result
            $netamount = $command->queryScalar();

            if ($netamount > 0) {
                $debit = $netamount;
            } else {
                $credit = $netamount;
            }
        }
        /* Total Sum needs only level 1 sum*/
        if ($eachledger['level'] == '1') {
            /*For showing Totals at end --start*/
            $sum_debit += $debit;
            $sum_credit += $credit;
            /*For showing Totals at end --end*/
        }
    ?>
        <?php
        if ($company < 0 || $company == '') {
            $company = 0;
        }
        
        if ($eachledger['is_parent'] == 'N') {
            // $link = 'js:Load_balance_gl_report(' . $eachledger['id'] . ',' . $company . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';

            if ($eachledger['ledger_main_acc'] == 'A' || $eachledger['ledger_main_acc'] == 'L') {
                $count = Yii::app()->db->createCommand("SELECT count(*) FROM erp_acc_voucher_items as ledger INNER JOIN erp_acc_voucher head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $eachledger['id'] . "' AND head.is_posted ='Y'  AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            } else {
                $count = Yii::app()->db->createCommand("SELECT count(*) FROM erp_acc_voucher_items as ledger INNER JOIN erp_acc_voucher head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $eachledger['id'] . "' AND head.is_posted ='Y' AND head.voucher_date>='" . $from_date . "' AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            }
            
            if ($eachledger['have_subledger'] == 'Y') {
                $link = 'js:load_balance_detailed_summary_pl(' . $eachledger['id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
            } else {
                
                if ($count < 300) {
                    $link = 'js:Load_balance_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
    
                    $link = 'js:load_balance_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }


            $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
        } else {
            $link = '';
            $accountName = '' . $eachledger['ledger_acc_name'] . '';
        }
        //added by jisha on 21-3-23 for non zero values --start
        if ($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachledger['level'] == 1) {
            //added by jisha on 21-3-23 for non zero values --end
        ?>
            <tr class="l<?php echo $eachledger['level'] . $style_tr; ?> level<?php echo $eachledger['level']; ?>">
                <td class="l1"><?php echo $eachledger['ledger_acc_no']; ?></td>
                <td class="level-<?php echo $eachledger['level']; ?> l<?php echo $eachledger['level']; ?>"><b><?php echo $accountName; ?></b></td>
                <td class="txt-right l<?php echo $eachledger['level']; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit));  ?></b></td>
                <td class="txt-right l<?php echo $eachledger['level']; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></b></td>
            </tr>
            <?php if ($eachledger['ledger_main_acc'] == 'NP') { ?>
                <tr class="l1<?php echo $style_tr_op; ?> ">

                    <td></td>
                    <td class="level-1 l1">Opening Balance</td>
                    <td class="txt-right l1"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit_opening));  ?></b></td>
                    <td class="txt-right l1"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit_opening));  ?></b></td>
                </tr>
                <tr class="l1<?php echo $style_tr_cp; ?> ">

                    <td></td>
                    <td class="level-1 l1">Current Period</td>
                    <td class="txt-right l1"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit_current_period));  ?></b></td>
                    <td class="txt-right l1"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit_current_period));  ?></b></td>
                </tr>
            <?php } ?>


    <?php
            //added by jisha on 21-3-23 for non zero values --start
        }
        //added by jisha on 21-3-23 for non zero values --end
    } ?>

    <tr class="to tol1">
        <td></td>
        <td><b>Total</b></td>
        <td class="txt-right  "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($sum_debit); ?></td>
        <td class="txt-right "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($sum_credit)); ?></td>
    </tr>
</table>