<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("lockDate",  "function lockDate(){
    var audit_close_name = $('#audit_close_name').val();
    if (audit_close_name == '') {
        t8.error('Please enter audit close name');
        return false
    } else {
        var r = confirm('Are you sure?');
        if(r==true){
            $('#loader').show();
            jQuery.ajax({
                'type'  : 'post',
                'data'  : {'close_date' : $('#AccAuditClose_close_date').val(), 'type' : 'pre_audit', 'name':audit_close_name },
                'url'  : $('#liveSite').val()+'index.php?r=accounts/accounts/closeyear_preaudit',
                'cache': false,
                'success':function(data){
                    $('#loader').hide();
                    if(data=='success'){
                        t8.success('Done!');
                        loadPopupModal('accounts/accounts/auditclosing','Audit Close','lg');
                    }else{
                        t8.error(data);
                    }
                }
            });
        }
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("unlockDate",  "function unlockDate(id){
    var r = confirm('Are you sure?');
    if(r==true){
        $('#loader').show();
        jQuery.ajax({
            'type'  : 'post',
            'data'  : {'id' : id },
            'url'  : $('#liveSite').val()+'index.php?r=accounts/accounts/unlockyear_preaudit',
            'cache': false,
            'success':function(data){
                $('#loader').hide();
                if(data=='success'){
                    t8.success('Done!');
                    loadPopupModal('accounts/accounts/auditclosing','Audit Close','lg');
                }else{
                    t8.error(data);
                }
            }
        });
    }
};", CClientScript::POS_HEAD); ?>

<?php if (empty($existPreAuditClose)) { ?>
    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) ) { ?>
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo CHtml::textField('audit_close_name', '', array('class' => 'tooltipster', 'data-label' => 'Name *')); ?>
            </li>
             <li class="col-sm-4">
                <?php 
                $last_closed_date = AccAuditClose::lastNewClosedDate();
                $last_closed_date= date('d/m/Y', strtotime($last_closed_date));
                $model->close_date =$last_closed_date;
                echo $form->textField($model,'close_date',array('data-label'=>'Date *',  'class' => 'datepicker ext-bold')); ?>
             </li>
             <li class="col-sm-4">
                <?php
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"])) { ?>
                    <a class="btn btn-sm btn-theme" title="Close Date" onclick="lockDate();"><i class="fa fa-check"></i></a>
                <?php } ?>
             </li>
        </ul>
    <?php }
} ?>
<ul class="clearfix form-ul material">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task">        
            <?php if( !empty( $auditclose_ranges ) ) { ?>
                <tr>
                    <th>Name</th>
                    <th>Closed Dates</th>            
                    <th>Audited Date Time</th>                          
                </tr>
                <?php  foreach( $auditclose_ranges as $i => $each ): ?>
                    <tr>
                        <td>
                            <label><?= $each->name; ?></label>
                        </td>
                        <td>
                            <?php echo $form->hiddenField($each, "[".$i."]id"); ?>
                            <?php $each->close_date = date('d/m/Y', strtotime($each->close_date));
                            echo $form->textField($each, "[".$i."]close_date",array('data-label'=>'Date', 'readonly' =>  true, 'class' => 'form-control' )); ?>
                        </td>
                        <td>
                            <?php
                            $each->created_datetime = date('d/m/Y H:i:s', strtotime($each->created_datetime));
                            echo $form->textField($each, "[".$i."]created_datetime",array('data-label'=>'Time', 'readonly' =>  true, 'class' => 'form-control' )); ?>
                        </td>
                        <td class="text-center nw" width="1%">
                            <?php 
                            $close_date     = strtotime(date("Y-m-d", strtotime(str_replace('/', '-',  $each->close_date)))); 
                            $lastCloseddate = strtotime(AccAuditClose::lastCloseddate());
                            if($close_date==$lastCloseddate && $each->closed == 'PRE'){ ?>
                                <?php 
                                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_delete"])) { ?>
                                    <a class="btn btn-sm btn-theme" title="Close Date" onclick="unlockDate(<?php echo $each->id; ?>);"><i class="fa fa-remove"></i></a>
                                <?php } 
                            } ?>
                        </td>
                    </tr>
                <?php endforeach; ?>    
            <?php }else{ ?>
                <tr>
                    <td colspan="2" class="text-center">No Data</td>
                </tr>
            <?php } ?>
        </table>
    </div>
</ul>
<script>
   $(function () {
        var closedate = $('#AccAuditClose_close_date');
        var lastClosedDate = moment(closedate.val(), 'DD/MM/YYYY');

        closedate.datetimepicker({  
            minDate: lastClosedDate.toDate(),
            format: 'DD/MM/YYYY'
        });
        
        closedate.on('dp.change', function (e) {
            var duedate = moment(e.date).add(7, 'days');
            var final = duedate.format('DD/MM/YYYY');
            
            if ($('#toggle').val() == 1) {
                $('#Quotes_qtn_validity').datetimepicker('destroy');
                $('#Quotes_qtn_validity').datetimepicker({  
                    minDate: final,
                    format: 'DD/MM/YYYY'
                }).val(final);
                
                closedate.datetimepicker('destroy');
                closedate.datetimepicker({  
                    minDate: closedate.val(),
                    format: 'DD/MM/YYYY'
                }).val(closedate.val());
            }
        });
    });
</script>



