<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("lockFinalAuditDate",  "function lockFinalAuditDate(){
    if (!$('#acc_final_auditclose_date').val()) {
        t8.error('Please select auditclose date');
        return false;
    }
    var r = confirm('Are you sure?');
    if(r==true){
        $('#loader').show();
        jQuery.ajax({
            'type'  : 'post',
            'data'  : {'close_date_id' : $('#acc_final_auditclose_date').val(), 'type' : 'final_audit' },
            'url'  : $('#liveSite').val()+'index.php?r=accounts/accounts/closeyear_finalaudit',
            'cache': false,
            'success':function(data){
                $('#loader').hide();
                if(data=='success'){
                    t8.success('Done!');
                    loadPopupModal('accounts/accounts/auditclosing&type=final','Audit Close','lg');
                }else{
                    t8.error(data);
                }
            }
        });
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("unlockFinalAuditDate",  "function unlockFinalAuditDate(id){
    var r = confirm('Are you sure?');
    if(r==true){
        $('#loader').show();
        jQuery.ajax({
            'type'  : 'post',
            'data'  : {'id' : id },
            'url'  : $('#liveSite').val()+'index.php?r=accounts/accounts/unlockyear_finalaudit',
            'cache': false,
            'success':function(data){
                $('#loader').hide();
                if(data=='success'){
                    t8.success('Done!');
                    loadPopupModal('accounts/accounts/auditclosing&type=final','Audit Close','lg');
                }else{
                    t8.error(data);
                }
            }
        });
    }
};", CClientScript::POS_HEAD); ?>
<?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"]) ) { ?>
    <ul class="clearfix form-ul material">
        <li class="col-sm-4">
            <?php 
            $last_closed_date = AccAuditClose::lastNewClosedDate();
            $last_closed_date= date('d/m/Y', strtotime($last_closed_date));
            $model->close_date =$last_closed_date;
            echo CHtml::dropdownlist("acc_final_auditclose_date", '', $auditclose_ranges_html, array('class' => 'tooltipster', 'data-label' => 'Auditclose Date')); ?>
        </li>
        <li class="col-sm-4">
            <?php
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"])) {
                ?>
                <a class="btn btn-sm btn-theme" title="Close Date" onclick="lockFinalAuditDate();"><i class="fa fa-check"></i></a>
            <?php } ?> 
        </li>
    </ul>
<?php } ?>
<ul class="clearfix form-ul material">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task">        
            <?php if( !empty( $existFinalAuditClose ) ) { ?>
                <tr>
                    <th>Name</th>
                    <th>Closed Dates</th>            
                    <th>Audited Date Time</th>                          
                </tr>
                <?php  foreach( $existFinalAuditClose as $i => $each ): ?>
                    <tr>
                        <td>
                            <label><?= $each->name; ?></label>
                        </td>
                        <td>
                            <?php echo $form->hiddenField($each, "[".$i."]id"); ?>
                            <?php
                            $each->close_date = date('d/m/Y', strtotime($each->close_date));
                            echo $form->textField($each, "[".$i."]close_date",array('data-label'=>'Date', 'readonly' =>  true, 'class' => 'form-control' )); ?>
                        </td>
                        <td>
                            <?php
                            $each->created_datetime = date('d/m/Y H:i:s', strtotime($each->created_datetime));
                            echo $form->textField($each, "[".$i."]created_datetime",array('data-label'=>'Time', 'readonly' =>  true, 'class' => 'form-control' )); ?>
                        </td>
                        <td class="text-center nw" width="1%">
                            <?php 
                            $close_date = strtotime(date("Y-m-d", strtotime(str_replace('/', '-',  $each->close_date)))); 
                            $lastFinalCloseddate = strtotime(AccAuditClose::lastFinalCloseddate());
                            if($close_date==$lastFinalCloseddate){ ?>
                                <?php
                                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_delete"])) {
                                    ?>
                                    <a class="btn btn-sm btn-theme" title="Close Date" onclick="unlockFinalAuditDate(<?php echo $each->id; ?>);"><i class="fa fa-remove"></i></a>
                                <?php } 
                            }?>
                        </td>
                    </tr>
                <?php endforeach; ?>    
            <?php }else{ ?>
                <tr>
                    <td colspan="2" class="text-center">No Data</td>
                </tr>
            <?php } ?>
        </table>
    </div>
</ul>




