<?php

/* Voucher Type
 date 21-09-2022
 author -Indhu 
 main setup
 Tables - acc_voucher_type
 Controller - VouchertypesController */

/**
 * This is the model class for table "{{acc_voucher_type}}".
 *
 * The followings are the available columns in table '{{acc_voucher_type}}':
 * @property integer $id
 * @property string $code
 * @property string $description
 * @property string $last_number
 * @property string $start_number

 * @property string $is_system
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class AccVoucherType extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_voucher_type}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('code,description, last_number,start_number', 'required'),
            array('code,description', 'unique'),
            array('created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('code, last_number,start_number', 'length', 'max' => 255),
            array('is_system', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, code, description, last_number,start_number, is_system, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'code' => 'Code',
            'description' => 'Description',
            'last_number' => 'Last Number',
            'start_number' => 'Start Number',
            'is_system' => 'Is System',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
            'updated_by' => 'Updated By',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('code', $this->code, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('last_number', $this->last_number, true);
        $criteria->compare('start_number', $this->start_number, true);
        $criteria->compare('is_system', $this->is_system, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_datetime', $this->created_datetime, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_datetime', $this->updated_datetime, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccVoucherType the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }


    public static function getVouchertypes()
    {
        $condition = 'is_active="Y"';
        $model     = self::model()->findAll(array('condition' => $condition, 'order' => 'id'));
        return CHtml::listData($model, 'id', 'description');
    }

    public static function getVoucherno($voucher, $savetype)
    {
        if (!empty($voucher)) {
            $voucherModel = self::model()->findBypk($voucher);
            $nextVoucher = $voucherModel->last_number + 1;
            if ($savetype) {
                $voucherModel->last_number     = $nextVoucher;
                $voucherModel->updated_datetime = date('Y-m-d h:i:s');
                $voucherModel->save(false);
            }
            return $nextVoucher;
        }
    }

    public static function getVouchertypes_for_import()
    {
        $condition = 'show_voucher_type="Y" AND is_active="Y"';
        $model     = self::model()->findAll(array('condition' => $condition, 'order' => 'id'));
        return CHtml::listData($model, 'id', 'description');
    }


    public static function getVouchertypes_for_create()
    {
        $condition = 'show_voucher_type="N" AND is_active="Y" ';
        //$condition .= " AND code != 'PV' AND code != 'RV' AND code != 'JV' ";

        $model     = self::model()->findAll(array('condition' => $condition, 'order' => 'id'));
        return CHtml::listData($model, 'id', 'description');
    }

    public function generateAccountingperiod($date)
    { //Y-m-d format
        return array('from' => date('Y-01-01', strtotime($date)), 'to' => date('Y-12-31', strtotime($date)));
    }


    public static function getVoucherTypeByValue($value)
    {
        $model = self::model()->findByAttributes(['code' => $value]);
        if ($model !== null) {
            return $model;
        }
        return null;
    }

    public static function get_voucher_id($type)
    {
        return self::model()->find(array('condition' => 'code="' . $type . '"'))->id;
    }
}
