<?php

/**
 * This is the model class for table "{{acc_voucher}}".
 *
 * The followings are the available columns in table '{{acc_voucher}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $voucher_type
 * @property string $voucher_no
 * @property string $voucher_date
 * @property string $transaction_date
 * @property integer $transaction_number
 * @property integer $transaction_id
 * @property string $reference_no
 * @property string $general_narration
 * @property string $voucher_value
 * @property integer $currency_id
 * @property string $exchange_rate
 * @property string $amount
 * @property string $vat
 * @property string $net_amount
 * @property string $total_discount
 * @property string $rounding
 * @property integer $tax_type
 * @property integer $tax_id
 * @property integer $order_id
 * @property string $delivery_id
 * @property string $direct
 * @property string $imported
 * @property string $bank_name
 * @property string $card_no
 * @property integer $customer_vendor_id
 * @property integer $payment_method
 * @property integer $payment_days
 * @property string $payment_terms
 * @property string $cheque_no
 * @property string $cheque_date
 * @property string $cheque_cleared
 * @property string $due_date
 * @property string $is_posted
 * @property string $posted_date
 * @property string $is_allocated
 * @property string $allocation_date
 * @property integer $lead_owner
 * @property integer $salegroup_id
 * @property string $year
 * @property integer $company_id
 * @property integer $branch_id
 * @property integer $project_id
 * @property integer $department_id
 * @property integer $employee_id
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class AccVoucher extends CActiveRecord
{
    public $commingfrom;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_voucher}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            // array('voucher_type, voucher_date, reference_no,exchange_rate,payment_method', 'required'),
            array('voucher_type,voucher_date,reference_no,exchange_rate', 'required'),

            array('file_id,outlet_id,voucher_type, transaction_number, transaction_id, currency_id, tax_type, tax_id, order_id, customer_vendor_id, payment_method, payment_days, lead_owner, salegroup_id, company_id, branch_id, project_id, department_id, employee_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('voucher_no', 'length', 'max' => 20),
            array('reference_no', 'length', 'max' => 200),
            array('voucher_value,amount,total_amount_in_selected_currency,total_exchange_difference,vat, net_amount, total_discount, rounding', 'length', 'max' => 15),
            array('exchange_rate', 'length', 'max' => 10),
            array('delivery_id, bank_name, card_no, cheque_no', 'length', 'max' => 255),
            array('direct, imported,direct_receipt,cheque_cleared, is_posted, is_allocated', 'length', 'max' => 1),
            array('year', 'length', 'max' => 4),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, file_id,outlet_id,voucher_type,direct_receipt,voucher_no, voucher_date, transaction_date, transaction_number, transaction_id, reference_no, general_narration, voucher_value, currency_id, exchange_rate, amount,total_amount_in_selected_currency,total_exchange_difference,vat, net_amount, total_discount, rounding, tax_type, tax_id, order_id, delivery_id, direct, imported, bank_name, card_no, customer_vendor_id, payment_method, payment_days, payment_terms, cheque_no, cheque_date, cheque_cleared, due_date, is_posted, posted_date, is_allocated, allocation_date, lead_owner, salegroup_id, year, company_id, branch_id, project_id, department_id, employee_id, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'voucher_items' => array(self::HAS_MANY, 'AccVoucherItems', 'acc_voucher_id'),
            'vtype' => array(self::BELONGS_TO, 'AccVoucherType', 'voucher_type'),
            'branch' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'branch_id'),
            'outlet' => array(self::BELONGS_TO, 'MasOutlet', 'outlet_id'),
            'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
            'costcenter' => array(self::BELONGS_TO, 'MasProjectClassification', 'costcenter_id'),
            'contract' => array(self::BELONGS_TO, 'FmPlannedMaintenance', 'contract_id'),
            'ticket' => array(self::BELONGS_TO, 'TicketHeader', 'ticket_id'),


            'company' => array(self::BELONGS_TO, 'MasCompany', 'company_id'),
            'salegroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'salegroup_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner'),
            // 'usercreated' => array(self::BELONGS_TO, 'User', 'invoice_created_id'),
            'project' => array(self::BELONGS_TO, 'WsProject', 'project_id'),
            'employee' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'department' => array(self::BELONGS_TO, 'MasDepartment', 'department_id'),
            'payment' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_method'),
            'paymentmode' => array(self::BELONGS_TO, 'AccPaymentMode', 'payment_method'),
            'debitItems' => array(self::HAS_MANY, 'AccVoucherItems', 'acc_voucher_id', 'condition' => 'debitItems.amount > 0', 'order' => 'debitItems.id asc'),
            'creditItems' => array(self::HAS_MANY, 'AccVoucherItems', 'acc_voucher_id', 'condition' => 'creditItems.amount < 0', 'order' => 'creditItems.id asc'),
            'debit_total_base' => array(self::STAT, 'AccVoucherItems', 'acc_voucher_id', 'select' => 'SUM(amount*exchange_rate)', 'condition' => 'amount > 0 '),
            'debit_total' => array(self::STAT, 'AccVoucherItems', 'acc_voucher_id', 'select' => 'SUM(amount)', 'condition' => 'amount > 0 '),
            'items' => array(self::HAS_MANY, 'AccVoucherItems', 'acc_voucher_id', 'order' => 'items.amount desc'),

        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'warehouse_id' => 'Cost center',  // 'Warehouse' change to Cost center, only in this project(ifm)
            'file_id' => 'File',
            'voucher_type' => 'Voucher Type',
            'voucher_no' => 'Voucher No',
            'voucher_date' => 'Voucher Date',
            'transaction_date' => 'Transaction Date',
            'transaction_number' => 'Transaction Number',
            'transaction_id' => 'Transaction',
            'reference_no' => 'Reference No',
            'general_narration' => 'General Narration',
            'voucher_value' => 'Voucher Value',
            'currency_id' => 'Currency',
            'exchange_rate' => 'Exchange Rate',
            'amount' => 'Amount',
            'vat' => 'Vat',
            'net_amount' => 'Net Amount',
            'total_discount' => 'Total Discount',
            'rounding' => 'Rounding',
            'tax_type' => 'Tax Type',
            'tax_id' => 'Tax',
            'order_id' => 'Order',
            'delivery_id' => 'Delivery',
            'direct' => 'Direct',
            'imported' => 'Imported',
            'bank_name' => 'Bank Name',
            'card_no' => 'Card No',
            'customer_vendor_id' => 'Customer Vendor',
            'payment_method' => 'Payment Method',
            'payment_days' => 'Payment Days',
            'payment_terms' => 'Payment Terms',
            'cheque_no' => 'Cheque No',
            'cheque_date' => 'Cheque Date',
            'cheque_cleared' => 'Cheque Cleared',
            'due_date' => 'Due Date',
            'is_posted' => 'Is Posted',
            'posted_date' => 'Posted Date',
            'is_allocated' => 'Is Allocated',
            'allocation_date' => 'Allocation Date',
            'lead_owner' => 'Lead Owner',
            'salegroup_id' => 'Salegroup',
            'year' => 'Year',
            'company_id' => 'Company',
            'branch_id' => 'Branch',
            'project_id' => 'Project',
            'department_id' => 'Department',
            'employee_id' => 'Employee',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
            'updated_by' => 'Updated By',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('file_id', $this->file_id);
        $criteria->compare('voucher_type', $this->voucher_type);
        $criteria->compare('voucher_no', $this->voucher_no, true);
        $criteria->compare('voucher_date', $this->voucher_date, true);
        $criteria->compare('transaction_date', $this->transaction_date, true);
        $criteria->compare('transaction_number', $this->transaction_number);
        $criteria->compare('transaction_id', $this->transaction_id);
        $criteria->compare('reference_no', $this->reference_no, true);
        $criteria->compare('general_narration', $this->general_narration, true);
        $criteria->compare('voucher_value', $this->voucher_value, true);
        $criteria->compare('currency_id', $this->currency_id);
        $criteria->compare('exchange_rate', $this->exchange_rate, true);
        $criteria->compare('amount', $this->amount, true);
        $criteria->compare('vat', $this->vat, true);
        $criteria->compare('net_amount', $this->net_amount, true);
        $criteria->compare('total_discount', $this->total_discount, true);
        $criteria->compare('rounding', $this->rounding, true);
        $criteria->compare('tax_type', $this->tax_type);
        $criteria->compare('tax_id', $this->tax_id);
        $criteria->compare('order_id', $this->order_id);
        $criteria->compare('delivery_id', $this->delivery_id, true);
        $criteria->compare('direct', $this->direct, true);
        $criteria->compare('imported', $this->imported, true);
        $criteria->compare('bank_name', $this->bank_name, true);
        $criteria->compare('card_no', $this->card_no, true);
        $criteria->compare('customer_vendor_id', $this->customer_vendor_id);
        $criteria->compare('payment_method', $this->payment_method);
        $criteria->compare('payment_days', $this->payment_days);
        $criteria->compare('payment_terms', $this->payment_terms, true);
        $criteria->compare('cheque_no', $this->cheque_no, true);
        $criteria->compare('cheque_date', $this->cheque_date, true);
        $criteria->compare('cheque_cleared', $this->cheque_cleared, true);
        $criteria->compare('due_date', $this->due_date, true);
        $criteria->compare('is_posted', $this->is_posted, true);
        $criteria->compare('posted_date', $this->posted_date, true);
        $criteria->compare('is_allocated', $this->is_allocated, true);
        $criteria->compare('allocation_date', $this->allocation_date, true);
        $criteria->compare('lead_owner', $this->lead_owner);
        $criteria->compare('salegroup_id', $this->salegroup_id);
        $criteria->compare('year', $this->year, true);
        $criteria->compare('company_id', $this->company_id);
        $criteria->compare('branch_id', $this->branch_id);
        $criteria->compare('project_id', $this->project_id);
        $criteria->compare('department_id', $this->department_id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_datetime', $this->created_datetime, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_datetime', $this->updated_datetime, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccVoucher the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public static function baseCurrency()
    {
        return MasCurrency::model()->find(array('condition' => 'default_usage="Y"'))->currency_code;
    }

    public function getFullvoucher()
    {
        return $this->vtype->code . '/' . $this->voucher_no;
    }

    public static function is_postable_voucher($id)
    {
        $query_one = 'SELECT COUNT(I.id) AS one FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON H.id = I.acc_voucher_id LEFT JOIN {{acc_ledger}} L ON L.id = I.ledger_id WHERE H.id="' . $id . '" AND L.have_subledger ="Y" AND I.subledger_id = 0';
        $count_one = Yii::app()->db->createCommand($query_one)->queryScalar();

        $query_two = 'SELECT COUNT(I.id) AS one FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON H.id = I.acc_voucher_id LEFT JOIN {{acc_ledger}} L ON L.id = I.ledger_id WHERE H.id="' . $id . '" AND L.have_subledger ="N" AND I.subledger_id > 0';
        $count_two = Yii::app()->db->createCommand($query_two)->queryScalar();
        return ($count_one > 0 || $count_two > 0) ? false : true;
    }

    public static function generateUrl($code, $header_id, $haveVat, $hire)
    {
        $url = '#';
        if ($code == 'SI') {
            $taxType = $haveVat ? 'tax' : 'taxnil';
            $hire = $hire == true ? '&hiring=Y' : '';
            $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $header_id . $hire . "&frm=" . $taxType . "&type=1', '_blank');";
        } else if ($code == 'PI') {
            $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $header_id . "', '_blank');";
        } else if ($code == 'DN') {
            $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $header_id . "', '_blank');";
        } else if ($code == 'CN') {
            $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $header_id . "', '_blank');";
        } else if ($code == 'GI') {
            $url = "window.open($('#liveSite').val()+'index.php?r=issues/PrintPDF&id=" . $header_id . "', '_blank');";
        } else if ($code == 'GR') {
            $url = "window.open($('#liveSite').val()+'index.php?r=receipts/PrintReceiptPDF&id=" . $header_id . "', '_blank');";
        } else {
            $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $header_id . "', '_blank');";
        }
        return $url;
    }

    // ------------added-by-indhu-29_12_2022-------------------------------------

    public static function getVoucherSubledgers()
    {
        //used in report/aging_report.php
        $sql = "SELECT VI.subledger_id,S.subledger_name FROM {{acc_voucher_items}} VI
        LEFT JOIN {{acc_subledger}} S ON S.id=VI.subledger_id
        WHERE VI.subledger_id!=0
        GROUP BY VI.subledger_id";
        $sub_list = Yii::app()->db->createCommand($sql)->queryAll();
        $sub_array = array();
        foreach ($sub_list as $sub) {
            $sub_array[$sub['subledger_id']] = $sub['subledger_name'];
        }
        return $sub_array;
    }


    public function payment_method_details($payment_mode_id = 0)
    {

        // Fetch details for the specific payment mode
        $paymentData = Yii::app()->db->createCommand()
            ->select('bank_name, card_no, cheque_no, cheque_date, reference_no')
            ->from('erp_acc_payment_mode')
            ->where('id=:id', array(':id' => $payment_mode_id))
            ->queryRow();

        $response = '';

        if ($paymentData) {
          // Dynamically check and display each field if it exists
          // Single function to add required spacing with &nbsp;
            function addLabelSpacing($label, $maxLength) {
                $spaces = str_repeat('&nbsp;', max(0, $maxLength - strlen($label)));
                return $label . $spaces . ':&nbsp;';
            }
            
            // Dynamically check and display each field if it exists
            if (!empty($paymentData['reference_no']) && !empty($this->reference_no)) {
                $response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>' . addLabelSpacing("Ref No", 29) . '<strong>' . $this->reference_no . '</strong></small><br>';
            }
            if (!empty($paymentData['bank_name']) && !empty($this->bank_name)) {
                $response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>' . addLabelSpacing("Bank Name", 25) . '<strong>' . $this->bank_name . '</strong></small><br>';
            }
            if (!empty($paymentData['card_no']) && !empty($this->card_no)) {
                $response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>' . addLabelSpacing("Card No", 28) . '<strong>' . $this->card_no . '</strong></small><br>';
            }
            if (!empty($paymentData['cheque_no']) && !empty($this->cheque_no)) {
                $response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>' . addLabelSpacing("Cheque No", 25) . '<strong>' . $this->cheque_no . '</strong></small><br>';
            }
            if (!empty($paymentData['cheque_date']) && !empty($this->cheque_date) && $this->cheque_date!=='0000-00-00') {
                $response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>' . addLabelSpacing("Cheque Date", 24) . '<strong>' . date('d/m/Y', strtotime($this->cheque_date)) . '</strong></small><br>';
            }

        } else {
            $response = '';
        }

        return $response;
    }
}
