<?php

class AccAccount extends CActiveRecord
{
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FinanceAuditClose the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }
    
    public static function getTrialBalanceDetails($from_date, $to_date, $level, $gl_auditclose_id) {
        $auditclose = '';
        if ($from_date != '') {
            $from_date = str_replace('/', '-', $from_date);
            $from_date = date('Y-m-d', strtotime($from_date));
        }
        if ($to_date != '') {
            $to_date = str_replace('/', '-', $to_date);
            $to_date = date('Y-m-d', strtotime($to_date));
        }
        
        $maincondition ='';
        if($level>0){
            $maincondition .= " AND level <= '{$level}'";
        } 
        if ($gl_auditclose_id) {
            $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);
            $acc_auditclose_date = $auditclose->close_date;
            $acc_auditclose_date_id = $gl_auditclose_id;
        } else {
            $acc_auditclose_date = AccAuditClose::lastFinalClosedDate();
            $acc_auditclose_date_id = AccAuditClose::lastFinalClosedDateId();   
        }
        $acc_profit_parent_id = Yii::app()->db->createCommand("SELECT ledger_parent_acc FROM {{acc_ledger}} WHERE ledger_main_acc = 'AP'")->queryScalar();
        $conditions = ' is_posted="Y" ';
        $conditionsBefore = $conditions . " AND voucher_date <= '".$from_date."' ";
        if ($acc_auditclose_date_id) {
            $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($acc_auditclose_date_id);
            $conditionsBefore .=  " AND voucher_date > '".$acc_auditclose_date."' ";
        }
        if ($acc_auditclose_date) {
            if (strtotime($from_date) > strtotime("+1 day", strtotime($acc_auditclose_date))) {
                $SQLBefore = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                            FROM `erp_acc_voucher_items` VI 
                            LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                            LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                            WHERE $conditionsBefore 
                            GROUP BY VI.ledger_id 
                            ORDER BY L.ledger_acc_name ASC";
                $arr_tbledgers_before = Yii::app()->db->createCommand($SQLBefore)->queryAll();
                if ($arr_tbledgers_before) {
                    foreach ($arr_tbledgers_before as $arr_tbledger_before) {
                        if ($arr_tbledger_before['balance']) {
                            $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['opening'] = (float) $arr_tbledger_before['opening'];
                            $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['amount'] = (float) $arr_tbledger_before['amount'];
                            $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['balance'] = (float) $arr_tbledger_before['balance'];
                            $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['opening'] += (float) $arr_tbledger_before['opening'];
                            $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['amount'] += (float) $arr_tbledger_before['amount'];
                            $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['balance'] += (float) $arr_tbledger_before['balance'];
                            $levelListBefore = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['level'];
                            $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['ledger_parent_acc'];
                            for($l=1; $l<$levelListBefore; $l++){
                                if($parentLedgerId>0){
                                    $auditCloseLedgerResults[$parentLedgerId]['opening'] += (float) $arr_tbledger_before['opening'];
                                    $auditCloseLedgerResults[$parentLedgerId]['amount'] += (float) $arr_tbledger_before['amount'];
                                    $auditCloseLedgerResults[$parentLedgerId]['balance'] += (float) $arr_tbledger_before['balance'];
                                    $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                                }
                            }
                        }
                    }
                }
            }
        }
        $conditionsAfter = $conditions . " AND voucher_date <= '".$to_date."'  AND voucher_date > '".$from_date."' ";
        $SQLAfter = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                    FROM `erp_acc_voucher_items` VI 
                    LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                    LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                    WHERE $conditionsAfter 
                    GROUP BY VI.ledger_id 
                    ORDER BY L.ledger_acc_name ASC";
        $arr_tbledgers_after = Yii::app()->db->createCommand($SQLAfter)->queryAll();
        if ($arr_tbledgers_after) {
            foreach ($arr_tbledgers_after as $arr_tbledger_after) {
                if ($arr_tbledger_after['balance']>0) {
                    $balanceType = 'debit';
                } else {
                    $balanceType = 'credit';
                }
                $auditCloseLedgerResults[$arr_tbledger_after['ledger_id']][$balanceType] = (float) $arr_tbledger_after['balance'];
                $auditCloseLedgerResults[$arr_tbledger_after['ledger_parent_acc']][$balanceType] += (float) $arr_tbledger_after['balance'];
                $levelList = $auditCloseLedgerResults[$arr_tbledger_after['ledger_parent_acc']]['level'];
                $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_after['ledger_parent_acc']]['ledger_parent_acc'];
                for($l=1; $l<$levelList; $l++){
                    if($parentLedgerId>0){
                        $auditCloseLedgerResults[$parentLedgerId][$balanceType] += (float) $arr_tbledger_after['balance'];
                        $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                    }
                }
            }
        }
        $acc_profit = 0.00;
        if ($acc_auditclose_date_id) {
            $sql_accumulated_profit = "SELECT SUM(balance) AS amount 
                FROM {{acc_audit_close_details}}  
                WHERE ledger_main_acc = 'AP' AND audit_close_id = ".$acc_auditclose_date_id;
            $acc_profit = Yii::app()->db->createCommand($sql_accumulated_profit)->queryScalar();
        }
        $voucher_date_condition = '';
        if ($acc_auditclose_date) {
            $voucher_date_condition = " AND voucher_date < '".$from_date."'";
        }
        $sql_accumulated_profit_pre_from_date = "SELECT SUM(VI.amount) AS amount 
            FROM {{acc_voucher_items}} VI 
            LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
            WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date >' " . $acc_auditclose_date."' ".$voucher_date_condition ;
        $acc_profit_pre_date = Yii::app()->db->createCommand($sql_accumulated_profit_pre_from_date)->queryScalar();    
        $acc_profit += $acc_profit_pre_date;
        
        if ($acc_profit_pre_date) {
            $auditCloseLedgerResults[$acc_profit_parent_id]['balance'] += $acc_profit_pre_date;
            $auditCloseLedgerResults[$acc_profit_parent_id]['opening'] += $acc_profit_pre_date;
            $auditCloseLedgerResults[$acc_profit_parent_id]['amount'] += $acc_profit_pre_date;
        }
        
        $sql_accumulated_profit_after_from_date = "SELECT SUM(VI.amount) AS amount 
            FROM {{acc_voucher_items}} VI 
            LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
            WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date >=' " . $from_date."' AND voucher_date <= ' ".$to_date." '" ;
        $acc_profit_after_date = Yii::app()->db->createCommand($sql_accumulated_profit_after_from_date)->queryScalar();    
        $acc_profit += $acc_profit_after_date;
        if ($acc_profit_after_date) {
            $auditCloseLedgerResults[$acc_profit_parent_id]['balance'] += $acc_profit_after_date;
            $auditCloseLedgerResults[$acc_profit_parent_id]['opening'] += $acc_profit_after_date;
            $auditCloseLedgerResults[$acc_profit_parent_id]['amount'] += $acc_profit_after_date;
        }
        
        return array('auditCloseLedgerResults' => $auditCloseLedgerResults, 'acc_profit' => $acc_profit, 'auditclose' => $auditclose);
	}
    
    public static function getTrialBalanceDetailedDetails($from_date, $to_date, $level, $gl_auditclose_id) {
        $auditclose = '';
        if ($from_date != '') {
            $from_date = str_replace('/', '-', $from_date);
            $from_date = date('Y-m-d', strtotime($from_date));
        }
        if ($to_date != '') {
            $to_date = str_replace('/', '-', $to_date);
            $to_date = date('Y-m-d', strtotime($to_date));
        }
        
        $maincondition ='';
        if($level>0){
            $maincondition .= " AND level <= '{$level}'";
        } 
        if ($gl_auditclose_id) {
            $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);
            $acc_auditclose_date = $auditclose->close_date;
            $acc_auditclose_date_id = $gl_auditclose_id;
        } else {
            $acc_auditclose_date = AccAuditClose::lastFinalClosedDate();
            $acc_auditclose_date_id = AccAuditClose::lastFinalClosedDateId();   
        }
        $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($acc_auditclose_date_id);
        $acc_profit_parent_id = Yii::app()->db->createCommand("SELECT ledger_parent_acc FROM {{acc_ledger}} WHERE ledger_main_acc = 'AP'")->queryScalar();
        $conditions = ' is_posted="Y" ';
        $conditionsBefore = $conditions . " AND voucher_date <= '".$from_date."' ";
        if ($acc_auditclose_date_id) {
            $conditionsBefore .=  " AND voucher_date > '".$acc_auditclose_date."' ";
        }
        if (strtotime($from_date) > strtotime("+1 day", strtotime($acc_auditclose_date))) {
            $SQLBefore = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                        FROM `erp_acc_voucher_items` VI 
                        LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                        LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                        WHERE $conditionsBefore 
                        GROUP BY VI.ledger_id 
                        ORDER BY L.ledger_acc_name ASC";
            $arr_tbledgers_before = Yii::app()->db->createCommand($SQLBefore)->queryAll();
            if ($arr_tbledgers_before) {
                foreach ($arr_tbledgers_before as $arr_tbledger_before) {
                    if ($arr_tbledger_before['balance']) {
                        $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['opening'] = (float) $arr_tbledger_before['opening'];
                        $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['opening'] += (float) $arr_tbledger_before['opening'];
                        $levelListBefore = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['level'];
                        $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['ledger_parent_acc'];
                        for($l=1; $l<$levelListBefore; $l++){
                            if($parentLedgerId>0){
                                $auditCloseLedgerResults[$parentLedgerId]['opening'] += (float) $arr_tbledger_before['opening'];
                                $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                            }
                        }
                    }
                }
            }
        }
        $conditionsAfter = $conditions . " AND voucher_date <= '".$to_date."'  AND voucher_date > '".$from_date."' ";
        $SQLAfter = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                    FROM `erp_acc_voucher_items` VI 
                    LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                    LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                    WHERE $conditionsAfter 
                    GROUP BY VI.ledger_id 
                    ORDER BY L.ledger_acc_name ASC";
        $arr_tbledgers_after = Yii::app()->db->createCommand($SQLAfter)->queryAll();
        if ($arr_tbledgers_after) {
            foreach ($arr_tbledgers_after as $arr_tbledger_after) {
                if ($arr_tbledger_after['balance']>0) {
                    $balanceType = 'debit';
                } else {
                    $balanceType = 'credit';
                }
                $auditCloseLedgerResults[$arr_tbledger_after['ledger_id']][$balanceType] = (float) $arr_tbledger_after['balance'];
                $auditCloseLedgerResults[$arr_tbledger_after['ledger_parent_acc']][$balanceType] += (float) $arr_tbledger_after['balance'];
                $levelList = $auditCloseLedgerResults[$arr_tbledger_after['ledger_parent_acc']]['level'];
                $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_after['ledger_parent_acc']]['ledger_parent_acc'];
                for($l=1; $l<$levelList; $l++){
                    if($parentLedgerId>0){
                        $auditCloseLedgerResults[$parentLedgerId][$balanceType] += (float) $arr_tbledger_after['balance'];
                        $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                    }
                }
            }
        }
        $acc_profit = 0.00;
        if ($acc_auditclose_date_id) {
            $sql_accumulated_profit = "SELECT SUM(balance) AS amount 
                FROM {{acc_audit_close_details}}  
                WHERE ledger_main_acc = 'AP' AND audit_close_id = ".$acc_auditclose_date_id;
            $acc_profit = Yii::app()->db->createCommand($sql_accumulated_profit)->queryScalar();
        }
        $voucher_date_condition = '';
        if ($acc_auditclose_date) {
            $voucher_date_condition = " AND voucher_date < '".$from_date."'";
        }
        $sql_accumulated_profit_pre_from_date = "SELECT SUM(VI.amount) AS amount 
            FROM {{acc_voucher_items}} VI 
            LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
            WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date >' " . $acc_auditclose_date."' ".$voucher_date_condition ;
        $acc_profit_pre_date = Yii::app()->db->createCommand($sql_accumulated_profit_pre_from_date)->queryScalar();    
        $acc_profit += $acc_profit_pre_date;
        
        if ($acc_profit_pre_date) {
            $auditCloseLedgerResults[$acc_profit_parent_id]['balance'] += $acc_profit_pre_date;
            $auditCloseLedgerResults[$acc_profit_parent_id]['opening'] += $acc_profit_pre_date;
            $auditCloseLedgerResults[$acc_profit_parent_id]['amount'] += $acc_profit_pre_date;
        }
        return array('auditCloseLedgerResults' => $auditCloseLedgerResults, 'acc_profit' => $acc_profit, 'auditclose' => $auditclose);
	}

    public static function getAllProfitWithAuditclose ($gl_auditclose_id, $acc_auditclose_date, $to_date, $type = '') {
        $auditcloseDetailsAll = array();
        $lastFinalClosedDateId = AccAuditClose::model()->lastFinalClosedDateId();
        $acc_profit_id = Yii::app()->db->createCommand("SELECT id FROM {{acc_ledger}} WHERE ledger_main_acc = 'AP'")->queryScalar();
        if ($acc_profit_id) {
        $finalAuditcloseBalance = Yii::app()->db->createCommand("SELECT balance FROM {{acc_audit_close_details}} WHERE ledger_id = $acc_profit_id AND audit_close_id = $lastFinalClosedDateId")->queryScalar();
        $conditions = '';
        if ($gl_auditclose_id) {
            $conditions = " AND auditclose.id <= $gl_auditclose_id";
            if ($type) {
                $conditions = " AND auditclose.id <= $gl_auditclose_id";
            }
        } else {
            if ($type && $lastFinalClosedDateId) {
                $conditions = " AND auditclose.id <= $lastFinalClosedDateId";
            }
        }
        $auditcloseDetailsAllResults = AccAuditCloseDetails::model()->with('ledger', 'auditclose')->findAll(array('condition' => 't.ledger_id ="' . $acc_profit_id . '" '.$conditions));
        $voucher_date_condition = '';
        if ($acc_auditclose_date) {
            $voucher_date_condition = " AND voucher_date > '".$acc_auditclose_date."'";
        }
        $sql_accumulated_profit_pre_from_date = "SELECT SUM(VI.amount) AS amount 
            FROM {{acc_voucher_items}} VI 
            LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
            WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date <=' " . $to_date."' ".$voucher_date_condition ;
        $acc_profit_pre_date = Yii::app()->db->createCommand($sql_accumulated_profit_pre_from_date)->queryScalar();
        if ($auditcloseDetailsAllResults) {
            foreach ($auditcloseDetailsAllResults as $adar => $auditcloseDetailsAllResult) {
                $auditcloseDetailsAll[$adar]['id'] = $auditcloseDetailsAllResult->audit_close_id;
                $auditcloseDetailsAll[$adar]['name'] = $auditcloseDetailsAllResult->auditclose->name. ' accumulated profit';
                $auditcloseDetailsAll[$adar]['opening'] = $auditcloseDetailsAllResult->opening;
                $auditcloseDetailsAll[$adar]['closing'] = $auditcloseDetailsAllResult->balance;
                $netprofit = (float) round(($auditcloseDetailsAllResult->balance - $auditcloseDetailsAllResult->opening), 6);
                $auditcloseDetailsAll[$adar]['netprofit'] = round($netprofit, 6);
            }
            if ($acc_profit_pre_date) {
                $auditcloseCount = count($auditcloseDetailsAllResults);
                $auditcloseDetailsAll[$auditcloseCount]['name'] = 'Accumulated profit from '.date('d-m-Y', strtotime($acc_auditclose_date)).' to '.date('d-m-Y', strtotime($to_date));
                $auditcloseDetailsAll[$auditcloseCount]['netprofit'] = round($acc_profit_pre_date, 6);
                if ($type && empty($gl_auditclose_id)) {
                    $auditcloseDetailsAll[$auditcloseCount]['opening'] = round($finalAuditcloseBalance, 6);
                    $auditcloseDetailsAll[$auditcloseCount]['closing'] = round($finalAuditcloseBalance+$acc_profit_pre_date, 6);
                }
            }
        }}
        return $auditcloseDetailsAll;
    }
	
	public static function getBalanceSheetDetails($to_date, $level, $gl_auditclose_id) {
	    $auditCloseLedgerResults = array();
	    if ($gl_auditclose_id) {
            $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);
            $acc_auditclose_date = $auditclose->close_date;
            $acc_auditclose_date_id = $gl_auditclose_id;
        } else {
            $acc_auditclose_date = AccAuditClose::lastFinalClosedDate();
            $acc_auditclose_date_id = AccAuditClose::lastFinalClosedDateId();   
        }
        $acc_profit_id = Yii::app()->db->createCommand("SELECT id FROM {{acc_ledger}} WHERE ledger_main_acc = 'AP'")->queryScalar();
        $net_profit_acc_no = Yii::app()->db->createCommand("SELECT ledger_acc_no FROM {{acc_ledger}} WHERE ledger_main_acc = 'NP'")->queryScalar();
        if ($acc_auditclose_date_id) {
            $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($acc_auditclose_date_id, 'B');
            $auditCloseLedgerResults[$auditCloseLedgerResults[$acc_profit_id]['ledger_parent_acc']]['balance'] -= $auditCloseLedgerResults[$acc_profit_id]['balance'];
            $auditCloseLedgerResults[$auditCloseLedgerResults[$acc_profit_id]['ledger_parent_acc']]['opening'] -= $auditCloseLedgerResults[$acc_profit_id]['opening'];
            $auditCloseLedgerResults[$auditCloseLedgerResults[$acc_profit_id]['ledger_parent_acc']]['amount'] -= $auditCloseLedgerResults[$acc_profit_id]['amount'];
        }
        $conditions = ' ledger_main_acc IN ("A","L") AND is_posted="Y" ';
        $conditionsBefore = $conditions . " AND voucher_date <= '".$to_date."' ";
        if ((int)$acc_auditclose_date_id > 0) {
            $conditionsBefore .=  " AND voucher_date > '".$acc_auditclose_date."' ";
        }
        $SQLBefore = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, sum(VI.amount) as amount, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                    FROM `erp_acc_voucher_items` VI 
                    LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                    LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                    WHERE $conditionsBefore 
                    GROUP BY VI.ledger_id 
                    ORDER BY L.ledger_acc_name ASC";
        $arr_tbledgers_before = Yii::app()->db->createCommand($SQLBefore)->queryAll();
        if ($arr_tbledgers_before) {
            foreach ($arr_tbledgers_before as $arr_tbledger_before) {
                if ($arr_tbledger_before['balance']) {
                    $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['opening'] += (float) $arr_tbledger_before['opening'];
                    $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['balance'] += (float) $arr_tbledger_before['balance'];
                    $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['amount'] += (float) $arr_tbledger_before['amount'];
                    $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['opening'] += (float) $arr_tbledger_before['opening'];
                    $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['balance'] += (float) $arr_tbledger_before['balance'];
                    $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['amount'] += (float) $arr_tbledger_before['amount'];
                    $levelListBefore = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['level'];
                    $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['ledger_parent_acc'];
                    for($l=1; $l<$levelListBefore; $l++){
                        if($parentLedgerId>0){
                            $auditCloseLedgerResults[$parentLedgerId]['opening'] += (float) $arr_tbledger_before['opening'];
                            $auditCloseLedgerResults[$parentLedgerId]['balance'] += (float) $arr_tbledger_before['balance'];
                            $auditCloseLedgerResults[$parentLedgerId]['amount'] += (float) $arr_tbledger_before['amount'];
                            $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                        }
                    }
                }
            }
        }
        
        $voucher_date_condition = '';
        if ($acc_auditclose_date) {
            $voucher_date_condition = " AND voucher_date > '".$acc_auditclose_date."'";
        }
        $sql_accumulated_profit_pre_from_date = "SELECT SUM(VI.amount) AS amount 
            FROM {{acc_voucher_items}} VI 
            LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
            WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date <=' " . $to_date."' ".$voucher_date_condition ;
        $acc_profit_pre_date = Yii::app()->db->createCommand($sql_accumulated_profit_pre_from_date)->queryScalar();    
        if ($acc_profit_pre_date) {
            $auditCloseLedgerResults[$acc_profit_id]['balance'] += $acc_profit_pre_date;
            $auditCloseLedgerResults[$acc_profit_id]['opening'] += $acc_profit_pre_date;
            $auditCloseLedgerResults[$acc_profit_id]['amount'] += $acc_profit_pre_date;
        }
        
        $auditcloseDetailsAll = self::model()->getAllProfitWithAuditclose($gl_auditclose_id, $acc_auditclose_date, $to_date);
        return array('auditCloseLedgerResults' => $auditCloseLedgerResults, 'net_profit_acc_no' => $net_profit_acc_no, 'auditcloseDetailsAll' => $auditcloseDetailsAll);
	}
	
	public static function getBalanceSheetDetailedDetails($from_date, $to_date, $level, $gl_auditclose_id) {
	    $ac_type = '';
	    $auditCloseLedgerResults = array();
	    if ($gl_auditclose_id) {
            $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);
            $acc_auditclose_date = $auditclose->close_date;
            $acc_auditclose_date_id = $gl_auditclose_id;
        } else {
            $acc_auditclose_date = AccAuditClose::lastFinalClosedDate();
            $acc_auditclose_date_id = AccAuditClose::lastFinalClosedDateId();   
        }
        $acc_profit_id = Yii::app()->db->createCommand("SELECT id FROM {{acc_ledger}} WHERE ledger_main_acc = 'AP'")->queryScalar();
        $acc_profit_parent_id = Yii::app()->db->createCommand("SELECT ledger_parent_acc FROM {{acc_ledger}} WHERE ledger_main_acc = 'AP'")->queryScalar();
        $net_profit_acc_no = Yii::app()->db->createCommand("SELECT ledger_acc_no FROM {{acc_ledger}} WHERE ledger_main_acc = 'NP'")->queryScalar();
        if ($gl_auditclose_id || $acc_auditclose_date_id) {
            $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($acc_auditclose_date_id, 'B');
            /*$auditCloseLedgerResults[$auditCloseLedgerResults[$acc_profit_id]['ledger_parent_acc']]['balance'] -= $auditCloseLedgerResults[$acc_profit_id]['balance'];
            //$auditCloseLedgerResults[$auditCloseLedgerResults[$acc_profit_id]['ledger_parent_acc']]['opening'] -= $auditCloseLedgerResults[$acc_profit_id]['opening'];
            $auditCloseLedgerResults[$auditCloseLedgerResults[$acc_profit_id]['ledger_parent_acc']]['amount'] -= $auditCloseLedgerResults[$acc_profit_id]['amount'];*/
        }
        if (empty($gl_auditclose_id)) {
            $ac_type = 1;
            $conditions = " ledger_main_acc IN ('A','L') AND is_posted='Y' ";
            if ($acc_auditclose_date_id) {
                if (strtotime($acc_auditclose_date) < strtotime("-1 day", strtotime($from_date))) {
                    $SQLBefore = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, sum(VI.amount) as amount, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                        FROM `erp_acc_voucher_items` VI 
                        LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                        LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                        WHERE $conditions  AND voucher_date > '".$acc_auditclose_date."'  AND voucher_date < '".$from_date."'
                        GROUP BY VI.ledger_id 
                        ORDER BY L.ledger_acc_name ASC";
                    $arr_tbledgers_before = Yii::app()->db->createCommand($SQLBefore)->queryAll();
                    if ($arr_tbledgers_before) {
                        foreach ($arr_tbledgers_before as $arr_tbledger_before) {
                            if ($arr_tbledger_before['balance']) {
                                $auditCloseLedgerResults[$arr_tbledger_before['ledger_id']]['opening'] += (float) $arr_tbledger_before['opening'];
                                $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['opening'] += (float) $arr_tbledger_before['opening'];
                                $levelListBefore = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['level'];
                                $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_before['ledger_parent_acc']]['ledger_parent_acc'];
                                for($l=1; $l<$levelListBefore; $l++){
                                    if($parentLedgerId>0){
                                        $auditCloseLedgerResults[$parentLedgerId]['opening'] += (float) $arr_tbledger_before['opening'];
                                        $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                                    }
                                }
                            }
                        }
                    }
                    $voucher_date_condition = '';
                    if ($acc_auditclose_date) {
                        $voucher_date_condition = " AND voucher_date < '".$from_date."'";
                    }
                    $sql_accumulated_profit_pre_from_date = "SELECT SUM(VI.amount) AS amount 
                        FROM {{acc_voucher_items}} VI 
                        LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
                        LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
                        WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date >' " . $acc_auditclose_date."' ".$voucher_date_condition ;
                    $acc_profit_pre_date = Yii::app()->db->createCommand($sql_accumulated_profit_pre_from_date)->queryScalar();    
                    if ($acc_profit_pre_date) {
                        $auditCloseLedgerResults[$acc_profit_id]['opening'] += $acc_profit_pre_date;
                    }
                }
            }
            $SQLRange = "SELECT ledger_id,L.ledger_acc_no,L.ledger_acc_name,L.ledger_acc_type,sum(VI.amount) as balance, sum(VI.amount) as opening, sum(VI.amount) as amount, L.ledger_main_acc, L.ledger_parent_acc, L.root, L.level, L.is_parent, COUNT(VI.ledger_id) as transaction_count 
                FROM `erp_acc_voucher_items` VI 
                LEFT JOIN erp_acc_voucher V ON V.id =VI.acc_voucher_id
                LEFT JOIN erp_acc_ledger L ON L.id =VI.ledger_id
                WHERE $conditions  AND voucher_date >= '".$from_date."'  AND voucher_date <= '".$to_date."'
                GROUP BY VI.ledger_id 
                ORDER BY L.ledger_acc_name ASC";
            $arr_tbledgers_range = Yii::app()->db->createCommand($SQLRange)->queryAll();
            if ($arr_tbledgers_range) {
                foreach ($arr_tbledgers_range as $arr_tbledger_range) {
                    if ($arr_tbledger_range['balance']) {
                        $auditCloseLedgerResults[$arr_tbledger_range['ledger_id']]['balance'] += (float) $arr_tbledger_range['balance'];
                        $auditCloseLedgerResults[$arr_tbledger_range['ledger_parent_acc']]['balance'] += (float) $arr_tbledger_range['balance'];
                        $levelListBefore = $auditCloseLedgerResults[$arr_tbledger_range['ledger_parent_acc']]['level'];
                        $parentLedgerId = $auditCloseLedgerResults[$arr_tbledger_range['ledger_parent_acc']]['ledger_parent_acc'];
                        for($l=1; $l<$levelListBefore; $l++){
                            if($parentLedgerId>0){
                                $auditCloseLedgerResults[$parentLedgerId]['balance'] += (float) $arr_tbledger_range['balance'];
                                $parentLedgerId = $auditCloseLedgerResults[$parentLedgerId]['ledger_parent_acc'];
                            }
                        }
                    }
                }
            }
            $voucher_date_condition = '';
            if ($acc_auditclose_date) {
                $voucher_date_condition = " AND voucher_date >= '".$from_date."'";
            }
            $sql_accumulated_profit_pre_from_date = "SELECT SUM(VI.amount) AS amount 
                FROM {{acc_voucher_items}} VI 
                LEFT JOIN erp_acc_ledger L ON L.id = VI.ledger_id 
                LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id 
                WHERE  ledger_main_acc IN ('I','E','AP') AND is_posted='Y' AND voucher_date <=' " . $to_date."' ".$voucher_date_condition ;
            $acc_profit_pre_date = Yii::app()->db->createCommand($sql_accumulated_profit_pre_from_date)->queryScalar();    
            if ($acc_profit_pre_date) {
                $auditCloseLedgerResults[$acc_profit_id]['balance'] += $acc_profit_pre_date;
                $auditCloseLedgerResults[$acc_profit_parent_id]['balance'] += $acc_profit_pre_date;
            }
        }
        
        $auditcloseDetailsAll = self::model()->getAllProfitWithAuditclose($gl_auditclose_id, $from_date, $to_date, 1);
        return array('auditCloseLedgerResults' => $auditCloseLedgerResults, 'net_profit_acc_no' => $net_profit_acc_no, 'ac_type' => $ac_type, 'auditcloseDetailsAll' => $auditcloseDetailsAll);
	}
}
