<?php

/*
 chart of accounts
 voucher Create, Save
 date 21-09-2022
 author -Nisha
 updated by - indhu

 main setup
 
 Main Tables - erp_acc_voucher,erp_acc_voucher_items
 linked tables - erp_acc_voucher_type,erp_mas_currency,
				 erp_mas_payment_term,erp_user,erp_mas_acc_comapny,erp_mas_acc_branch,erp_ws_project,
				 erp_hr_department,erp_hr_employee,
 Main models used - AccVoucher,AccVoucherItems

 */

class VoucherController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetList',
                    'Create',
                    'Save',
                    'getVoucherData',
                    'SaveVoucher',
                    'Postvoucher',
                    'GetcurrencyexchangeRate',
                    'Subledgerlist',
                    'Gettotalcheck',
                    'DeleteVoucher',
                    'Updatevoucher',
                    'GetvoucherList',
                    'Removelineitem',
                    'Add_payment',
                    'Add_receipt',
                    'GetProducts',
                    'PrintvoucherPdf',
                    'Importvouchers',
                    'Getimportvouchers',
                    'GetImportSalesList',
                    'GetImportPurchaseList',
                    'GetImportCreditNoteList',
                    'GetImportDebitNoteList',
                    'GetImportGoodsissueList',
                    'GetImportGoodsreceiptList',
                    'add_commission',
                    'get_commissionemployee',
                    'GetallocationdataFromPayment',
                    'GetallocationdataFromReceiptDebit',
                    'GetallocationdataFromReceiptCredit',
                    'VouchersExcel',
                    'GetImportVoucherList',
                    'PrintPaymentReciptvoucherPdf',
                    'GetExchangeRateFromExchangeMaster',
                    'GetMultipleExchangeRates',
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    // public $modelMasCurrency;

    // public function init()
    // {
    //     // parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }

    public function actionIndex()
    {
        $this->render('index');
    }


    public function actionGetList()
    {
        $modelMasCurrency = new MasCurrency();
        $model = new AccVoucher();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $voucher_type = $_POST['voucher_type'];
        $post_status = $_POST['post_status'];
        $import = $_POST['import'];
        $columns = array(
            0 => 'voucher_no',
            1 => 'file_id',
            2 => 'transaction_number',
            3 => 'reference_no',
            4 => 'voucher_date',
            5 => 'voucher_type',
            6 => 'warehouse_name',
            7 => 'imported',
            8 => 'ledger_name',
            9 => 'subledger_name',
            10 => 'net_amount',
            11 => 'id',
            12 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';

        if ((int)$voucher_type > 0) {
            $condition .= " AND voucher_type_id = " . $voucher_type;
        }

        if ($_POST['voucher_date_from'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_from'])));
            $condition .= ' AND voucher_date>="' . $start_date . '" ';
        }
        if ($_POST['voucher_date_to'] != '') {
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_to'])));
            $condition .= ' AND voucher_date<="' . $end_date . '" ';
        }

        if (!empty($post_status)) {
            if ($post_status == 'Y') {
                $condition .= ' AND is_posted= "Y"';
            } else {
                $condition .= ' AND is_posted= "N"';
            }
        }

        if (!empty($import)) {
            if ($import == 'Y') {
                $condition .= ' AND imported= "Y"';
            } else {
                $condition .= ' AND imported= "N"';
            }
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition .= ' AND (voucher_no LIKE "%' . $searchString . '%"
                OR voucher_type LIKE "%' . $searchString . '%"
                OR file_id LIKE "%' . $searchString . '%"
                OR transaction_number LIKE "%' . $searchString . '%"
                OR code LIKE "%' . $searchString . '%"
                OR subledger_name LIKE "%' . $searchString . '%" 
                OR ledger_name LIKE "%' . $searchString . '%" 
                OR reference_no LIKE "%' . $searchString . '%" 
                OR net_amount LIKE "%' . $searchString . '%")';
        }
        $query = 'SELECT id,subledger_id,voucher_no,pv_rv_pdf,code,is_posted,outlet_name,outlet_id,is_allocated,imported,transaction_number,file_id,reference_no,voucher_type,ledger_name,subledger_name,net_amount,voucher_date,warehouse_name,warehouse_id FROM view_acc_voucher_items WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset;
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_acc_voucher_items WHERE ' . $condition)->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $eachItem) {
            $eachItem['file_id'] == 0 ? $file_id = '-' : $file_id = $eachItem['file_id'];
            $eachItem['transaction_number'] == 0 ? $transaction_number = '-' : $transaction_number = $eachItem['transaction_number'];
            $imported = ($eachItem['imported'] == "Y") ? 'Yes' : 'No';
            $net_amount = $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['net_amount']);


            $temp_det = '';
            $temp_det_status = 'N';
            if (!empty($eachItem['subledger_id'])) {
                $sql = "SELECT *  FROM {{ch_template}} WHERE `bank_id` IN (" . $eachItem['subledger_id'] . ")";
                $temp_det          = Yii::app()->db->createCommand($sql)->queryAll();
            }
            if ((!empty($temp_det))) {
                $temp_det_status = 'Y';
            }


            $rowData[] = array(
                $eachItem['code'] . "/" . $eachItem['voucher_no'],
                $file_id,
                $transaction_number,
                $eachItem['reference_no'],
                (!empty($eachItem['voucher_date'])) ? date('d/m/Y', strtotime($eachItem['voucher_date'])) : "-",
                $eachItem['voucher_type'],
                $eachItem['warehouse_name'],
                $imported,
                $eachItem['ledger_name'],
                $eachItem['subledger_name'],
                $net_amount,
                array(
                    'id'                => $eachItem['id'],
                    'voucher_no_code'   => $eachItem['code'] . "/" . $eachItem['voucher_no'],
                    'posted'            => $eachItem['is_posted'],
                    'voucher_no'        => $eachItem['voucher_no'],
                    'is_allocated'      => $eachItem['is_allocated'],
                    'pv_rv_pdf'         => $eachItem['pv_rv_pdf'],
                    'voucher_type_code' => $eachItem['code'],
                    'imported'          => $eachItem['imported'],
                    'temp_det_status'          => $temp_det_status,
                ),


            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }




    public function actionGetList01_07_2024()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new AccVoucher();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        $voucher_type = $_POST['voucher_type'];
        $post_status  = $_POST['post_status'];
        $import       = $_POST['import'];
        // $warehouse_id = $_POST['warehouse_id'];
        // $outlet_id = $_POST['outlet_id'];

        $columns      = array(
            // datatable column index  => database column name


            0 => 'code',
            1 => 'file_id',
            2 => 'transaction_number',
            3 => 'reference_no',
            4 => 'voucher_date',
            5 => 'voucher_type',
            6 => 'warehouse_name',
            7 => 'imported',
            8 => 'ledger_name',
            9 => 'subledger_name',
            10 => 'net_amount',
            11 => 'id',
            12 => 'id',



        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        //$orderBy      = 'id DESC';
        $condition    = '1=1';

        // -----------indhu- 03-11-2022----------
        if ((int)$voucher_type > 0) {
            $condition .= " AND voucher_type_id = " . $voucher_type;
        }

        if ($_POST['voucher_date_from'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_from'])));
            $condition .= ' AND voucher_date>="' . $start_date . '" ';
        }
        if ($_POST['voucher_date_to'] != '') {
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_to'])));
            $condition .= ' AND voucher_date<="' . $end_date . '" ';
        }

        if (!empty($post_status)) {
            if ($post_status == 'Y') {
                $condition      .= ' AND is_posted= "Y"';
            } else {
                $condition      .= ' AND is_posted= "N"';
            }
        }

        if (!empty($import)) {
            if ($import == 'Y') {
                $condition      .= ' AND imported= "Y"';
            } else {
                $condition      .= ' AND imported= "N"';
            }
        }
        /* if ((int)$warehouse_id > 0) {
            $condition .= " AND warehouse_id = " . $warehouse_id;
        }
        
        if ((int)$outlet_id > 0) {
            $condition .= " AND outlet_id = " . $outlet_id;
        }*/


        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (voucher_no LIKE "%' . $searchString . '%"
			 OR voucher_type LIKE "%' . $searchString . '%"
			  OR transaction_number LIKE "%' . $searchString . '%"
			 OR code LIKE "%' . $searchString . '%"
            OR subledger_name LIKE "%' . $searchString . '%" OR ledger_name LIKE "%' . $searchString . '%" OR reference_no LIKE "%' . $searchString . '%" OR amount LIKE "%' . $searchString . '%")';
        }

        $query = 'SELECT id,voucher_no,code,is_posted,outlet_name,outlet_id,is_allocated,imported,transaction_number,file_id,reference_no,voucher_type,ledger_name,subledger_name,net_amount,voucher_date,warehouse_name,warehouse_id FROM view_acc_voucher_items WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_acc_voucher_items WHERE ' . $condition . ' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();
        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        foreach ($model as $eachItem) {
            $voucher_type = $eachItem['code'];
            $div = '<div class="btn-wrap text-center">';

            // Create dropdown button
            $div .= '<div class="btn-group">';
            $div .= '<button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
            $div .= 'Actions <span class="caret"></span>';
            $div .= '</button>';
            $div .= '<ul class="dropdown-menu">';

            // Edit option
            if ($eachItem['is_posted'] == "N" && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_edit"]))) {
                $div .= '<li><a href="#" onclick="loadPopupModal(\'accounts/voucher/Create&id=' . $eachItem['id'] . '\',\'Edit Voucher \',\'xl\')"><i class="fa fa-edit"></i> Edit</a></li>';
            }

            // Post option
            if ($eachItem['is_posted'] == "N" && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_post"]))) {
                $div .= '<li><a href="#" onclick="updatevoucher(' . $eachItem['id'] . ',1)"><i class="fa fa-send"></i> Post Voucher</a></li>';
            }

            // Unpost option
            if ($eachItem['is_posted'] == "Y" && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_unpost"])) && $voucher_type != 'DL') {
                $div .= '<li><a href="#" onclick="updatevoucher(' . $eachItem['id'] . ',0)"><i class="fa fa-remove"></i> Unpost Voucher</a></li>';
            }

            // View option
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_edit"])) {
                $div .= '<li><a href="#" onclick="loadPopupModal(\'accounts/voucher/Create&id=' . $eachItem['id'] . '&frm=view\',\'View Voucher \',\'xl\')"><i class="fa fa-eye"></i> View</a></li>';
            }

            // Allocation options

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_allocation_menu_view"])) {
                $div .= '<li class="dropdown-header"></li>';

                if ($voucher_type == 'SI') {
                    $div .= '<li><a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/allocation/CreateSalesAllocation&id=' . $eachItem['id'] . '\',\'Allocate \',\'xl\')"><i class="fa fa-code-fork"></i> Sales Allocation</a></li>';
                }
                if ($voucher_type == 'PI') {
                    $div .= '<li><a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/allocation/CreatePurchaseAllocation&id=' . $eachItem['id'] . '\',\'Allocate \',\'xl\')"><i class="fa fa-code-fork"></i> Purchase Allocation</a></li>';
                }
                if ($voucher_type == 'RV') {
                    $div .= '<li><a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/allocation/CreateReceiptAllocation&id=' . $eachItem['id'] . '\',\'Allocate \',\'xl\')"><i class="fa fa-code-fork"></i> Receipt Allocation</a></li>';
                }
                if ($voucher_type == 'PV') {
                    $div .= '<li><a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/allocation/CreatePaymentAllocation&id=' . $eachItem['id'] . '\',\'Allocate \',\'xl\')"><i class="fa fa-code-fork"></i> Payment Allocation</a></li>';
                }
                if ($voucher_type == 'CN') {
                    $div .= '<li><a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/allocation/CreateCreditNoteAllocation&id=' . $eachItem['id'] . '\',\'Allocate \',\'xl\')"><i class="fa fa-code-fork"></i> Credit Note Allocation</a></li>';
                }
                if ($voucher_type == 'DN') {
                    $div .= '<li><a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/allocation/CreateDebitNoteAllocation&id=' . $eachItem['id'] . '\',\'Allocate \',\'xl\')"><i class="fa fa-code-fork"></i> Debit Note Allocation</a></li>';
                }
            }





            // Print options
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_print"])) {
                $div .= '<li class="dropdown-header"></li>';
                $div .= '<li><a href="index.php?r=accounts/voucher/PrintvoucherPdf&id=' . $eachItem['id'] . '" target="_blank"><i class="fa fa-file-pdf-o"></i> Voucher Print</a></li>';
                if ($eachItem['code'] == 'RV') {
                    $div .= '<li><a href="index.php?r=accounts/voucher/PrintPaymentReciptvoucherPdf&id=' . $eachItem['id'] . '" target="_blank"><i class="fa fa-file-text"></i> RV Print</a></li>';
                }
            }

            // Delete option
            if ($eachItem['is_allocated'] == "N" && $eachItem['is_posted'] == "N" && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_delete"]))) {
                $div .= '<li><a href="#" onclick="deleteAccount(' . $eachItem['id'] . ', ' . $eachItem['voucher_no'] . ')"><i class="fa fa-trash-o"></i> Delete</a></li>';
            }

            $div .= '</ul>';
            $div .= '</div>'; // Close btn-group

            $div .= '</div>'; // Close btn-wrap

            $eachItem['file_id'] == 0 ? $file_id = '-' : $file_id = $eachItem['file_id'];

            $eachItem['transaction_number'] == 0 ? $transaction_number = '-' : $transaction_number = $eachItem['transaction_number'];

            if ($eachItem['imported'] == "Y") {
                $imported = 'Yes';
            } else {
                $imported = 'No';
            }

            $net_amount = $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['net_amount']);


            $eachItemData[] =
                array(
                    $eachItem['code'] . "/" . $eachItem['voucher_no'],
                    $file_id,
                    $transaction_number,
                    $eachItem['reference_no'],
                    (!empty($eachItem['voucher_date'])) ? date('d/m/Y', strtotime($eachItem['voucher_date'])) : "-",
                    $eachItem['voucher_type'],
                    $eachItem['warehouse_name'],
                    $imported,
                    $eachItem['ledger_name'],
                    $eachItem['subledger_name'],
                    $net_amount,
                    $div,
                    $eachItem['id']
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }


    public function actionCreate()
    {
        $model          = new AccVoucher();
        $modelItems     = array(new AccVoucherItems());
        $id             = (int)Yii::app()->request->getParam('id');
        $frm            = Yii::app()->request->getParam('frm');
        if ($id > 0) {
            $model      = $model->findBypk($id);
            $modelItems = AccVoucherItems::model()->with('ledger', 'subledger')->findAll(array('condition' => 'acc_voucher_id="' . $id . '"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('voucher_new_create', array('model' => $model, 'modelItems' => $modelItems, 'frm' => $frm));
    }


    public function actionSaveVoucher()
    {



        $modelVoucher      = new AccVoucher();
        $modelVoucherItems = array(new AccVoucherItems());
        $error1   = array();
        $error2   = array();
        $error3   = array();
        $error    = array();
        $other    = array();
        $validate = true;

        $tot_debit = 0;


        if (isset($_POST['AccVoucher'])) {
            $modelVoucher->created_by       = Yii::app()->user->id;
            $modelVoucher->created_datetime = date('Y-m-d h:i:s');
            $modelVoucher->updated_by       = Yii::app()->user->id;
            $modelVoucher->updated_datetime = date('Y-m-d h:i:s');

            if (isset($_POST['AccVoucher']['id']) && $_POST['AccVoucher']['id'] > 0) {
                $id = $_POST['AccVoucher']['id'];

                $modelVoucher                   = $modelVoucher->findByPk($id);
                $modelVoucher->updated_by       = Yii::app()->user->id;
                $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $modelVoucher->attributes        = $_POST['AccVoucher'];
            $modelVoucher->general_narration = $_POST['AccVoucher']['general_narration'];
            $modelVoucher->imported = 'N';
            if ($modelVoucher->isNewRecord) {
                $modelVoucher->voucher_no    = AccVoucherType::getVoucherno($modelVoucher->voucher_type, true);
            }

            if ($_POST['AccVoucher']['voucher_date'] != '' && $_POST['AccVoucher']['voucher_date'] != '0000-00-00') {
                $modelVoucher->voucher_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['voucher_date'])));
            } else {
                $modelVoucher->voucher_date = date("Y-m-d");
            }
            $usermodel                           = new user();
            $modelVoucher->transaction_number    =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_id        =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_date      =  $modelVoucher->voucher_date;
            $modelVoucher->lead_owner            = (int)Yii::app()->user->id;
            if ($_POST['AccVoucher']['cheque_date'] != '' && $_POST['AccVoucher']['cheque_date'] != '0000-00-00') {
                $modelVoucher->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['cheque_date'])));
            }

            $commingfrom        = $_POST['AccVoucher']['commingfrom'];
            if ($commingfrom == 'copynewvoucher') {
                $modelVoucher->is_allocated = 'N';
                $modelVoucher->allocation_date = '0000-00-00';
            }

            $validate = $modelVoucher->validate();


            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
            $voucher_date = strtotime($modelVoucher->voucher_date);
            if ($voucher_date <= $existing_date) {
                $validate = false;
                $other[] = ' Given Voucher date must be Greater than Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
            }
            //   --------------------//-AccAuditClose check------------------------------------   



            if (is_array($_POST['AccVoucherTypeDetails'])) {
                $checkcredit =  $checkdebit = 0;
                foreach ($_POST['AccVoucherTypeDetails'] as $i => $TypeDetails) {
                    $modeltype[$i]                   = new AccVoucherItems();
                    $modeltype[$i]->attributes       = $TypeDetails;
                    $modeltype[$i]->created_by       = Yii::app()->user->id;
                    $modeltype[$i]->created_datetime = date('Y-m-d H:i:s');
                    $modeltype[$i]->ledger_id        = $TypeDetails['ledger_id'];

                    //   ----------added by indhu 31_01_2023--------------------
                    if (!empty($TypeDetails['ledger_id'])) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($TypeDetails['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ($TypeDetails['subledger_id'] == '') {
                                $validate = false;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }

                    //end

                    $modeltype[$i]->subledger_id     = $TypeDetails['subledger_id'];
                    $modeltype[$i]->narration        = ($TypeDetails['narration'] == '') ? $modelVoucher->general_narration : $TypeDetails['narration'];
                    $modeltype[$i]->debit            = $TypeDetails['debit'];
                    $modeltype[$i]->credit           = $TypeDetails['credit'];
                    $modeltype[$i]->acc_voucher_id   = 0;
                    // ----------------------
                    $modeltype[$i]->year             = $TypeDetails['year'];
                    $modeltype[$i]->company_id       = $TypeDetails['com_id'];
                    $modeltype[$i]->branch_id        = $TypeDetails['branch_id'];
                    $modeltype[$i]->salegroup_id     = $TypeDetails['salegrp_id'];
                    $modeltype[$i]->brand_id         = $TypeDetails['brand_id'];
                    $modeltype[$i]->employee_id      = $TypeDetails['emp_id'] ? $TypeDetails['emp_id'] : '000';
                    $modeltype[$i]->department_id    = $TypeDetails['dept_id'] ? $TypeDetails['dept_id'] : '00';
                    $modeltype[$i]->costcenter_id    = $TypeDetails['cc_id'];
                    $modeltype[$i]->project_id       = $TypeDetails['project_id'] ? $TypeDetails['project_id'] : '0000';
                    $modeltype[$i]->generic_id       = $TypeDetails['cat_id'];
                    $modeltype[$i]->product_id       = $TypeDetails['item'] ? $TypeDetails['item'] : '0000';
                    $modeltype[$i]->warehouse_id     = $TypeDetails['warehouse_id'];

                    // ----------------------
                    if ($TypeDetails['debit'] > 0) {
                        $modeltype[$i]->amount       = $TypeDetails['debit'];
                    } else {
                        $modeltype[$i]->amount       = -1 * (float)$TypeDetails['credit'];
                    }
                    if ($TypeDetails['debit'] > 0) {
                        $checkdebit += abs($TypeDetails['debit']);
                    }

                    if ($commingfrom == 'copynewvoucher') {
                        $modeltype[$i]->allocated_amount = 0;
                        $modeltype[$i]->allocate_ids     = '';
                    }


                    $validate = $modeltype[$i]->validate() && $validate;
                }
            }
            // --------------------------------------------------------------------------------------------------

            $checkamount = 0;


            $modelVoucherItems = array();
            if (is_array($_POST['AccVoucherItems'])) {
                $checkcredit =  $checkdebit = 0;
                foreach ($_POST['AccVoucherItems'] as $i => $items) {
                    $modelVoucherItems[$i]                   = new AccVoucherItems();
                    $modelVoucherItems[$i]->updated_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                    $modelVoucherItems[$i]->created_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->created_datetime = date('Y-m-d H:i:s');
                    $modelVoucherItems[$i]->attributes     = $items;
                    $modelVoucherItems[$i]->ledger_id        = $items['ledger_id'];

                    //   ----------added by indhu 31_01_2023--------------------
                    if (!empty($items['ledger_id'])) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($items['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ($items['subledger_id'] == '') {
                                $validate = false;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }

                    //end
                    $modelVoucherItems[$i]->acc_voucher_id = 0;
                    $modelVoucherItems[$i]->narration      = ($items['narration'] == '') ? $modelVoucher->general_narration : $items['narration'];
                    $modelVoucherItems[$i]->ledger_id      = $items['ledger_id'];
                    $modelVoucherItems[$i]->year           = $items['year'];
                    $modelVoucherItems[$i]->company_id     = $items['company_id'];
                    $modelVoucherItems[$i]->branch_id      = $items['branch_id'];
                    $modelVoucherItems[$i]->salegroup_id   = $items['salegroup_id'];
                    $modelVoucherItems[$i]->brand_id       = $items['brand_id'];
                    $modelVoucherItems[$i]->employee_id    = $items['employee_id'] ? $items['employee_id'] : '000';
                    $modelVoucherItems[$i]->department_id  = $items['department_id'] ? $items['department_id'] : '00';
                    $modelVoucherItems[$i]->costcenter_id  = $items['costcenter_id'];
                    $modelVoucherItems[$i]->project_id     = $items['project_id'] ? $items['project_id'] : '0000';
                    $modelVoucherItems[$i]->generic_id     = $items['generic_id'];
                    // $modelVoucherItems[$i]->product_id  = $items['product_id'] ? $items['product_id'] : '0000';
                    $modelVoucherItems[$i]->warehouse_id   = $items['warehouse_id'];
                    $modelVoucherItems[$i]->product_id     = $items['product_id'];


                    if ($items['debit'] > 0) {
                        $modelVoucherItems[$i]->amount     = $items['debit'];
                    } else {
                        $modelVoucherItems[$i]->amount     = -1 * (float)$items['credit'];
                    }

                    if ($commingfrom == 'copynewvoucher') {
                        $modelVoucherItems[$i]->allocated_amount = 0;
                        $modelVoucherItems[$i]->allocate_ids     = '';
                    }

                    $validate                              = $modelVoucherItems[$i]->validate() && $validate;
                }
            }


            // -------------------------is_multiple----------------------------------------

            if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                $voucher_date = $_POST['AccVoucher']['start_date'];
                $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                $frequency_type = $_POST['AccVoucher']['frequency_type'];
                $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
            }
            // -------------------------is_multiple----------------------------------------


            if ($validate) {
                $modelVoucher->save();

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "{$modelVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
                );
                // end audit log

                AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $modelVoucher->id));

                if (!empty($modelVoucherItems)) {
                    $total = 0;

                    foreach ($modelVoucherItems as $eachModel) {
                        if (!empty($eachModel->ledger_id) || $eachModel->ledger_id > 0) {
                            $eachModel->acc_voucher_id  = $modelVoucher->id;
                            if (!empty($eachModel->debit) && $eachModel->debit > 0) {
                                $total += $eachModel->debit;
                                $tot_debit += abs($eachModel->debit);
                            }
                            $eachModel->currency_id    = $modelVoucher->currency_id;
                            $eachModel->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModel->save(false);
                        }
                    }
                }

                if (!empty($modeltype)) {
                    $total = 0;
                    foreach ($modeltype as $eachModeltype) {
                        if (!empty($eachModeltype->ledger_id) || $eachModeltype->ledger_id > 0) {
                            $eachModeltype->acc_voucher_id = $modelVoucher->id;
                            if (!empty($eachModeltype->debit) && $eachModeltype->debit > 0) {
                                $total += $eachModeltype->debit;
                                $tot_debit += abs($eachModeltype->debit);
                            }
                            $eachModeltype->currency_id    = $modelVoucher->currency_id;
                            $eachModeltype->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModeltype->save(false);
                        }
                    }
                }

                $modelAccVoucher = new AccVoucher();
                $modelAccVoucher->updatebypk($modelVoucher->id, array('amount' => ($tot_debit), 'net_amount' => ($tot_debit))); //$netTotal

                // -------------------------is_multiple----------------------------------------

                if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                    $voucher_id = $modelVoucher->id;
                    $voucher_date = $_POST['AccVoucher']['start_date'];
                    $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                    $frequency_type = $_POST['AccVoucher']['frequency_type'];
                    $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
                    if ($_POST['AccVoucher']['frequency_no'] >= 1) {
                        for ($i = 1; $i <= $frequency; $i++) {
                            VoucherController::copyVoucher($voucher_id, $voucher_date);
                            if ($frequency_type == 'D') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 day'));
                            }
                            // Weekly
                            elseif ($frequency_type == 'W') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 week'));
                            }
                            // Monthly
                            elseif ($frequency_type == 'M') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 month'));
                            }
                            // Yearly
                            elseif ($frequency_type == 'Y') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 year'));
                            }
                        }
                    }
                }
                // -----------------------------------------------------------------
                $jsonData['status'] = 'success';
                $jsonData['id'] = $modelVoucher->id;
                echo CJSON::encode($jsonData);
            } else {

                if (!empty($modelVoucher)) {

                    $error1 = json_decode(CActiveForm::validate($modelVoucher, '', false), true);
                }


                if (!empty($modelVoucherItems)) {

                    $error2 = json_decode(CActiveForm::validateTabular($modelVoucherItems, '', false), true);
                }


                if (!empty($modeltype)) {


                    $error3 = json_decode(CActiveForm::validateTabular($modeltype, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }




    public function actiongetVoucherData()
    {
        $voucher_type       = $_POST['voucher_type'];
        $model_voucher_type = new AccVoucherType();
        $voucherItems       = array();
        $voucherItems       = AccVoucherItems::model()->with('parent')->findAll(array('condition' => 'parent.voucher_type="' . $voucher_type . '"'));
        if (empty($voucherItems)) {
            $voucherItems   = array(new AccVoucherItems());
        }
        $this->render('voucher_details', array('voucherItems' => $voucherItems));
    }

    public function actionGetcurrencyexchangeRate()
    {
        $currency = (int)$_POST['currency'];
        echo (float)MasCurrency::model()->findBypk($currency)->exchange_rate;
    }

    public function actionGettotalcheck()
    {
        $modelAccVoucherItems = new AccVoucherItems();
        //$resultTotal = AccVoucherItems::model()->find(array('select' => 'sum(debit) as debit,sum(credit) as credit'));
        $resultTotal = $modelAccVoucherItems->find(array('select' => 'sum(debit) as debit,sum(credit) as credit'));

        if ($resultTotal['debit'] == $resultTotal['credit']) {
            echo "success";
        } else {
            echo "fail";
        }
    }


    public function actionDeleteVoucher()
    {
        $id = (int)$_POST['id'];

        if ($id <= 0) {
            $jsonData[] = 'failed';
            echo CJSON::encode($jsonData);
            return;
        }

        $voucherModel = AccVoucher::model()->findByPk($id);

        if (empty($voucherModel)) {
            $jsonData[] = 'This Voucher does not exist!';
            echo CJSON::encode($jsonData);
            return;
        }

        if ($voucherModel->is_allocated == "Y") {
            $jsonData[] = 'Remove the allocation first';
            echo CJSON::encode($jsonData);
            return;
        }

        if ($voucherModel->is_posted == "Y") {
            $jsonData[] = 'Unpost the voucher first';
            echo CJSON::encode($jsonData);
            return;
        }

        $voucherItemsModel = AccVoucherItems::model()->findAll(array('condition' => 'acc_voucher_id="' . $id . '" '));

        if (!empty($voucherItemsModel)) {
            AccVoucherItems::model()->deleteAll(array('condition' => 'acc_voucher_id =' . $id));
        }

        // inserting to audit log
        AccAuditLog::saveAuditLogs(
            'ACCOUNTS',
            Yii::app()->user->id,
            'DELETED',
            changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
        );
        // end audit log


        $voucherModel->deleteByPk($id);



        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionGetvoucherList()
    {
        $voucher_type_id                 = Yii::app()->request->getParam('voucher_type');
        $modelAccVoucherTypeDetails      = new AccVoucherTypeDetails();
        $modelAccVoucherTypeDetails_list = $modelAccVoucherTypeDetails->findAll(array('condition' => 'voucher_type_id="' . $voucher_type_id . '" '));
        $this->render('voucher_list', array('voucher_type_id' => $voucher_type_id, 'modelAccVoucherTypeDetails_list' => $modelAccVoucherTypeDetails_list));
    }


    public function actionRemovelineitem()
    {
        $id           = $_POST['id'];
        $debit_total  = $_POST['debit'];
        $credit_total = $_POST['credit'];
        if ($id > 0) {
            AccVoucherItems::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionAdd_payment()
    {
        $model = new AccVoucher;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_payment_voucher', array('model' => $model));
    }


    // --------------added-by-indhu-21-11-2022--------------------------------------------------------------------------
    public function actionPostPaymentVoucher21_11_2022()
    {
        // updated code on posting controller - postPayment
        // pOST SAVE  form voucher Payment



        if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {

            $valid = true;
            $error = array();
            $model = new AccVoucher;
            $payment_modes = $_POST['payment_modes'];

            $modelAccPaymentMode = new AccPaymentMode();
            $modelAccPaymentMode_details = $modelAccPaymentMode->findByPk($payment_modes);

            // -------------------------------

            // ---------------------------------------------
            $modelAccVoucherType = new AccVoucherType;
            $vouchertype = $modelAccVoucherType->find(array('condition' => 'code="PV"'))->id;

            $model->voucher_type = $vouchertype;
            $model->voucher_no = $modelAccVoucherType->getVoucherno($model->voucher_type, true);
            $model->payment_method = $_POST['payment_modes'];
            $model->card_no = $_POST['card_no'];
            $model->bank_name = $_POST['bank_name'];
            $model->cheque_no = $_POST['cheque_no'];
            $model->reference_no = $_POST['reference_no'];
            $model->cheque_date = (count(explode('/', $_POST['cheque_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date']))) : date('Y-m-d');
            $model->voucher_date = (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
            $model->due_date = (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
            $model->amount = $_POST['amount'];
            $model->general_narration = $_POST['narration'];
            $model->exchange_rate = 1;
            $model->currency_id = 1;
            $model->is_posted = 'Y';
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d H:i:s');

            $valid = $model->validate();

            // -------------------------------------

            if ($valid) {
                $model->save(false);
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);

                // Debit Side
                $modelItemsdebit = new AccVoucherItems;
                $modelItemsdebit->acc_voucher_id = $model->id;
                $modelItemsdebit->ledger_id = $_POST['to_account'];
                $modelItemsdebit->subledger_id = $_POST['to_subledger_id'];
                $modelItemsdebit->narration = $_POST['narration'];
                if ($_POST['vat_amount'] > 0 && $_POST['vat_amount'] !== '') {
                    $modelItemsdebit->amount = $_POST['amount'] - $_POST['vat_amount'];
                    $modelItemsdebit->debit = abs($_POST['amount'] - $_POST['vat_amount']);
                } else {
                    $modelItemsdebit->amount = $_POST['amount'];
                    $modelItemsdebit->debit = $_POST['amount'];
                }
                $modelItemsdebit->exchange_rate = 1;
                $modelItemsdebit->currency_id = 1;
                $modelItemsdebit->save(false);


                // credit Side
                $modelItemscredit = new AccVoucherItems;
                $modelItemscredit->acc_voucher_id = $model->id;
                $modelItemscredit->ledger_id = $_POST['from_account'];
                $modelItemscredit->subledger_id = $_POST['from_subledger_id'];
                $modelItemscredit->narration = $_POST['narration'];
                $modelItemscredit->amount = - ($_POST['amount']);
                $modelItemscredit->credit = $_POST['amount'];
                $modelItemscredit->exchange_rate = 1;
                $modelItemscredit->currency_id = 1;
                $modelItemscredit->save(false);
            } else {
                $error = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
        } else {
            // if ($_POST['vat_amount'] > $_POST['amount']) {
            // 	$jsonData['status'] = 'Amount must be greater than VAT';
            // } else {
            // 	$jsonData['status'] = 'Please fill all mandatory fields';
            // }
            $jsonData['status'] = 'Please fill all mandatory fields';
            echo CJSON::encode($jsonData);
        }
    }





    public function actionSubledgerlist26_08_2024()
    {
        $modelMasCurrency = new MasCurrency();
        $ledger               = (int)$_GET['ledger'];

        $modelAccLedger       = new AccLedger();
        $legderModel          = $modelAccLedger->findBypk($ledger);
        //$legderModel        = AccLedger::model()->findBypk($ledger);
        $currency_id          = $legderModel->currency_id;
        $subledger_types      = $legderModel->subledger_types;
        $subledger_types_list = explode(',', $subledger_types);
        $data = [];
        if (!empty($subledger_types_list)) {
            foreach ($subledger_types_list as $key => $row) {

                $searchTerm = $_GET['term'];
                $condition  = '(subledger_name LIKE "%' . $searchTerm . '%" OR reference_id LIKE "%' . $searchTerm . '%")';
                $condition .= 'AND subledger_type IN (' . $row . ')';
                $limit      = 50;
                $query = 'SELECT * FROM {{acc_subledger}} WHERE ' . $condition . ' ORDER BY subledger_name LIMIT ' . $limit;
                $model = Yii::app()->db->createCommand($query)->queryAll();
                $i = 0;
                foreach ($model as $eachModel) {
                    
                    // ---------------------------------------------
                    $ledger_currency_details = $modelMasCurrency->getCurrencyDetails((int)$currency_id);
                    $ledger_currency_code = (!empty($ledger_currency_details->currency_code)) ? $ledger_currency_details->currency_code : '';


                    $ledger_exchange_rate = ($ledger_currency_details->exchange_rate > 0) ? $ledger_currency_details->exchange_rate : '';
                    // ---------------------------------------------
                    $modAccSubledgerType = new AccSubledgerType();
                    $subledger_type_id_customer = $modAccSubledgerType->getIdFromType('C');
                    $subledger_type_id_vendor = $modAccSubledgerType->getIdFromType('V');
                    if ($eachModel['subledger_type'] == $subledger_type_id_customer) {
                        $modelCustomer = new Customer();
                        $customer_currency_id = $modelCustomer->findByPK($eachModel['reference_id'])->customer_currency_id;
                        $currency_code = $modelMasCurrency->findByPK($customer_currency_id)->currency_code;
                    }
                    if ($eachModel['subledger_type'] == $subledger_type_id_vendor) {
                        $modelVendor = new Vendor();
                        $vendor_currency_id = $modelVendor->findByPK($eachModel['reference_id'])->vendor_currency_id;
                        $currency_code = $modelMasCurrency->findByPK($vendor_currency_id)->currency_code;
                    }
                    $data[$i]['value'] = $eachModel['id'];

                    $ledgers = Yii::app()->db->createCommand("select SUM(I.amount) AS amount from {{acc_voucher_items}} AS I LEFT JOIN {{acc_voucher}} AS H ON I.acc_voucher_id=H.id where H.is_posted='Y' AND I.ledger_id=" . $ledger . " AND I.subledger_id=" . $eachModel['id'])->queryScalar();

                    $ledger_amount = ($ledger_exchange_rate > 0) ? (float)$ledgers * (float)$ledger_exchange_rate : 0;

                    $data[$i]['label'] = $eachModel['reference_id'] . ' : ' . $eachModel['subledger_name'] . ' : ' . $currency_code . ' ' . round((float)$ledgers, 2) . ' ( ' . $ledger_currency_code . ' ' . round((float)$ledger_amount, 2) . ' )';

                    // $data[$i]['label'] = $eachModel['subledger_name'];
                    $i++;
                }
            }
        }


        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionSubledgerlist()
    {

        $ledger               = (int)$_GET['ledger'];
        $modelAccLedger       = new AccLedger();
        $legderModel          = $modelAccLedger->findBypk($ledger);
        //$legderModel        = AccLedger::model()->findBypk($ledger);
        $subledger_types      = $legderModel->subledger_types;
        $subledger_types_list = explode(',', $subledger_types);

        foreach ($subledger_types_list as $key => $row) {

            $searchTerm = $_GET['term'];
            $condition  = '(subledger_name LIKE "%' . $searchTerm . '%" OR subledger_name LIKE "%' . $searchTerm . '%")';
            $condition .= 'AND subledger_type IN (' . $row . ')';
            $limit      = 50;
            $query = 'SELECT * FROM erp_acc_subledger WHERE ' . $condition . ' ORDER BY subledger_name LIMIT ' . $limit;
            $model = Yii::app()->db->createCommand($query)->queryAll();
            $i = 0;
            foreach ($model as $eachModel) {
                $data[$i]['value'] = $eachModel['id'];
                $data[$i]['label'] = $eachModel['subledger_name'];
                $i++;
            }
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionAdd_receipt()
    {
        $model = new AccVoucher;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_receipt_voucher', array('model' => $model));
    }

    // --------------added-by-indhu-18-11-2022--------------------------------------------------------------------------

    public function actionPostReceiptVoucher21_11_2022()
    {
        // pOST SAVE  form voucher Receipt
        // updated code on posting controller - PostReceipt

        if (isset($_POST['reference_no']) && isset($_POST['from_account']) && $_POST['from_account'] > 0 && isset($_POST['narration']) && isset($_POST['to_account']) && $_POST['to_account'] > 0 && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount'] > 0)) {

            $valid  = true;
            $error = array();
            $model              = new AccVoucher;
            $payment_modes     = $_POST['payment_modes'];

            $modelAccPaymentMode  = new AccPaymentMode();
            $modelAccPaymentMode_details  = $modelAccPaymentMode->findByPk($payment_modes);

            // -------------------------------

            // ---------------------------------------------
            $modelAccVoucherType      = new AccVoucherType;
            $vouchertype              = $modelAccVoucherType->find(array('condition' => 'code="RV"'))->id;

            $model->voucher_type      = $vouchertype;
            $model->voucher_no        = $modelAccVoucherType->getVoucherno($model->voucher_type, true);
            $model->payment_method    = $_POST['payment_modes'];
            $model->card_no           = $_POST['card_no'];
            $model->bank_name         = $_POST['bank_name'];
            $model->cheque_no         = $_POST['cheque_no'];
            $model->reference_no      = $_POST['reference_no'];
            $model->cheque_date       = (count(explode('/', $_POST['cheque_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date']))) : date('Y-m-d');
            $model->voucher_date      = (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
            $model->due_date          = (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
            $model->amount            = $_POST['amount'];
            $model->general_narration = $_POST['narration'];
            $model->exchange_rate     = 1;
            $model->currency_id    = 1;
            $model->is_posted         = 'Y';
            $model->created_by        = Yii::app()->user->id;
            $model->created_datetime  = date('Y-m-d H:i:s');

            $valid = $model->validate();

            // -------------------------------------

            if ($valid) {
                $model->save(false);
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                // Debit Side
                $modelItems                 = new AccVoucherItems;
                $modelItems->acc_voucher_id = $model->id;
                $modelItems->ledger_id      = $_POST['to_account'];
                $modelItems->subledger_id   = $_POST['to_subledger_id'];
                $modelItems->narration      = $_POST['narration'];
                $modelItems->amount         = $_POST['amount'];
                $modelItems->debit          =  $_POST['amount'];
                $modelItems->save(false);
                // credit Side
                $modelItemsx                 = new AccVoucherItems;
                $modelItemsx->acc_voucher_id = $model->id;
                $modelItemsx->ledger_id      = $_POST['from_account'];
                $modelItemsx->subledger_id   = $_POST['from_subledger_id'];
                $modelItemsx->narration      = $_POST['narration'];
                $modelItemsx->amount         = - ($_POST['amount']);
                $modelItemsx->credit         =  $_POST['amount'];
                $modelItemsx->save(false);
            } else {
                $error = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
        } else {
            $jsonData['status'] = 'Please fill all mandatory fields';
            echo CJSON::encode($jsonData);
        }
    }

    //END 

    public function actionPostvoucher()
    {
        $modelVoucher = new AccVoucher();
        $modelVoucherItems = array(new AccVoucherItems());
        $error1   = array();
        $error2   = array();
        $error3   = array();
        $error    = array();
        $other    = array();
        $validate = TRUE;
        if (isset($_POST['AccVoucher'])) {
            $modelVoucher->created_by       = Yii::app()->user->id;
            $modelVoucher->created_datetime = date('Y-m-d h:i:s');
            $modelVoucher->updated_by       = Yii::app()->user->id;
            $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
            if ((int)@$_POST['AccVoucher']['id'] > 0) {
                $id = (int)@$_POST['AccVoucher']['id'];
                $modelVoucher                   = $modelVoucher->findByPk($id);
                $modelVoucher->updated_by       = Yii::app()->user->id;
                $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
            }
            $modelVoucher->attributes        = $_POST['AccVoucher'];
            $modelVoucher->general_narration = $_POST['AccVoucher']['general_narration'];
            $modelVoucher->is_posted         = 'Y';
            if ($modelVoucher->isNewRecord) {
                $modelAccVoucherType = new AccVoucherType();
                //$modelVoucher->voucher_no = AccVoucherType::getVoucherno($modelVoucher->voucher_type, true);
                $modelVoucher->voucher_no   = $modelAccVoucherType->getVoucherno($modelVoucher->voucher_type, true);
            }
            if ($_POST['AccVoucher']['voucher_date'] != '' && $_POST['AccVoucher']['voucher_date'] != '0000-00-00') {
                $modelVoucher->voucher_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['voucher_date'])));
            } else {
                $modelVoucher->voucher_date = date("Y-m-d");
            }
            $usermodel                           = new user();
            $modelVoucher->transaction_number    =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_id        =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_date      =  $modelVoucher->voucher_date;
            $modelVoucher->posted_date           =  date('Y-m-d h:i:s');
            $modelVoucher->lead_owner            = (int)Yii::app()->user->id;
            if ($_POST['AccVoucher']['cheque_date'] != '' && $_POST['AccVoucher']['cheque_date'] != '0000-00-00') {
                $modelVoucher->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['cheque_date'])));
            }
            $commingfrom        = $_POST['AccVoucher']['commingfrom'];
            if ($commingfrom == 'copynewvoucher') {
                $modelVoucher->is_allocated = 'N';
                $modelVoucher->allocation_date = '0000-00-00';
            }
            $validate = $modelVoucher->validate();

            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $voucher_date = strtotime($modelVoucher->voucher_date);
            if ($voucher_date <= $existing_date) {
                $validate = false;
                $other[] = ' Given Voucher date must be Greater than Audit Close Date :-' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
            }
            //   --------------------//-AccAuditClose check------------------------------------



            if (is_array($_POST['AccVoucherTypeDetails'])) {
                $checkdebit = 0;
                foreach ($_POST['AccVoucherTypeDetails'] as $i => $TypeDetails) {
                    $modeltype[$i]                   = new AccVoucherItems();
                    $modeltype[$i]->attributes       = $TypeDetails;


                    //   ----------added by indhu 31_01_2023--------------------
                    if (!empty($TypeDetails['ledger_id'])) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($TypeDetails['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ($TypeDetails['subledger_id'] == '') {
                                $validate = FALSE;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }

                    //end

                    $modeltype[$i]->created_by       = Yii::app()->user->id;
                    $modeltype[$i]->created_datetime = date('Y-m-d H:i:s');
                    $modeltype[$i]->ledger_id        = $TypeDetails['ledger_id'];
                    $modeltype[$i]->subledger_id     = $TypeDetails['subledger_id'];


                    $modeltype[$i]->narration        = ($TypeDetails['narration'] == '') ? $modelVoucher->general_narration : $TypeDetails['narration'];
                    $modeltype[$i]->debit            = $TypeDetails['debit'];
                    $modeltype[$i]->credit           = $TypeDetails['credit'];
                    $modeltype[$i]->acc_voucher_id   = 0;
                    // ----------------------
                    $modeltype[$i]->year             = $TypeDetails['year'];
                    $modeltype[$i]->company_id       = $TypeDetails['com_id'];
                    $modeltype[$i]->branch_id        = $TypeDetails['branch_id'];
                    $modeltype[$i]->salegroup_id     = $TypeDetails['salegrp_id'];
                    $modeltype[$i]->brand_id         = $TypeDetails['brand_id'];
                    $modeltype[$i]->employee_id      = $TypeDetails['emp_id'] ? $TypeDetails['emp_id'] : '000';
                    $modeltype[$i]->department_id    = $TypeDetails['dept_id'] ? $TypeDetails['dept_id'] : '00';
                    $modeltype[$i]->costcenter_id    = $TypeDetails['cc_id'];
                    $modeltype[$i]->project_id       = $TypeDetails['project_id'] ? $TypeDetails['project_id'] : '0000';
                    $modeltype[$i]->generic_id       = $TypeDetails['cat_id'];
                    $modeltype[$i]->product_id       = $TypeDetails['item'] ? $TypeDetails['item'] : '0000';
                    $modeltype[$i]->warehouse_id     = $TypeDetails['warehouse_id'];


                    // ----------------------
                    if ($TypeDetails['debit'] > 0) {
                        $modeltype[$i]->amount       = $TypeDetails['debit'];
                    } else {
                        $modeltype[$i]->amount       = -1 * (float)$TypeDetails['credit'];
                    }
                    if ($TypeDetails['debit'] > 0) {
                        $checkdebit += $TypeDetails['debit'];
                    }
                    if ($commingfrom == 'copynewvoucher') {
                        $modeltype[$i]->allocated_amount = 0;
                        $modeltype[$i]->allocate_ids     = '';
                    }
                    $validate = $modeltype[$i]->validate() && $validate;
                }
            }


            $checkamount = 0;
            $modelVoucherItems = array();
            if (is_array($_POST['AccVoucherItems'])) {
                $checkcredit =  $checkdebit = 0;
                foreach ($_POST['AccVoucherItems'] as $i => $items) {
                    // if ($items['id'] > 0) {
                    //     $modelVoucherItems[$i]                   = AccVoucherItems::model()->findByPK($items['id']);
                    //     $modelVoucherItems[$i]->updated_by       = Yii::app()->user->id;
                    //     $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                    // } else {
                    $modelVoucherItems[$i]                   = new AccVoucherItems();
                    $modelVoucherItems[$i]->updated_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                    $modelVoucherItems[$i]->created_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->created_datetime = date('Y-m-d H:i:s');
                    // }
                    // length defined in dimention seting table. if data empty the set 0s
                    $modelVoucherItems[$i]->attributes           = $items;

                    //   ----------added by indhu 31_01_2023--------------------
                    if (!empty($items['ledger_id'])) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($items['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ($items['subledger_id'] == '') {
                                $validate = FALSE;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }

                    //end


                    $modelVoucherItems[$i]->acc_voucher_id       = 0;



                    $modelVoucherItems[$i]->narration            = ($items['narration'] == '') ? $modelVoucher->general_narration : $items['narration'];
                    $modelVoucherItems[$i]->year                 = $items['year'];
                    $modelVoucherItems[$i]->company_id           = $items['company_id'];
                    $modelVoucherItems[$i]->branch_id            = $items['branch_id'];
                    $modelVoucherItems[$i]->salegroup_id         = $items['salegroup_id'];
                    $modelVoucherItems[$i]->brand_id             = $items['brand_id'];
                    $modelVoucherItems[$i]->employee_id          = $items['employee_id'] ? $items['employee_id'] : '000';
                    $modelVoucherItems[$i]->department_id        = $items['department_id'] ? $items['department_id'] : '00';
                    $modelVoucherItems[$i]->costcenter_id        = $items['costcenter_id'];
                    $modelVoucherItems[$i]->project_id           = $items['project_id'] ? $items['project_id'] : '0000';
                    $modelVoucherItems[$i]->generic_id           = $items['generic_id'];
                    $modelVoucherItems[$i]->product_id           = $items['product_id'] ? $items['product_id'] : '0000';
                    $modelVoucherItems[$i]->warehouse_id         = $items['warehouse_id'];
                    $modelVoucherItems[$i]->currency_id             = $modelVoucher->currency_id;
                    $modelVoucherItems[$i]->exchange_rate           = $modelVoucher->exchange_rate;

                    if ($items['debit'] > 0) {
                        $modelVoucherItems[$i]->amount           = $items['debit'];
                    } else {
                        $modelVoucherItems[$i]->amount           = -1 * (float)$items['credit'];
                    }

                    if ($commingfrom == 'copynewvoucher') {
                        $modelVoucherItems[$i]->allocated_amount = 0;
                        $modelVoucherItems[$i]->allocate_ids     = '';
                    }
                    $validate = $modelVoucherItems[$i]->validate() && $validate;
                }
            }
            // -------------------------is_multiple----------------------------------------

            if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                $voucher_date = $_POST['AccVoucher']['start_date'];
                $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                $frequency_type = $_POST['AccVoucher']['frequency_type'];
                $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
            }
            // -------------------------is_multiple----------------------------------------


            if ($validate) {
                $modelVoucher->save();
                $audit_type = 'POSTED';
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "{$modelVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
                );
                // end audit log
                AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $modelVoucher->id));

                if (!empty($modelVoucherItems)) {
                    $total = 0;

                    foreach ($modelVoucherItems as $eachModel) {
                        if (!empty($eachModel->ledger_id) || $eachModel->ledger_id > 0) {
                            $eachModel->acc_voucher_id  = $modelVoucher->id;
                            if (!empty($eachModel->debit) && $eachModel->debit > 0) {
                                $total += $eachModel->debit;
                                $tot_debit += abs($eachModel->debit);
                            }
                            $eachModel->currency_id    = $modelVoucher->currency_id;
                            $eachModel->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModel->save(false);
                        }
                    }
                }

                if (!empty($modeltype)) {
                    $total = 0;
                    foreach ($modeltype as $eachModeltype) {
                        if (!empty($eachModeltype->ledger_id) || $eachModeltype->ledger_id > 0) {
                            $eachModeltype->acc_voucher_id = $modelVoucher->id;
                            if (!empty($eachModeltype->debit) && $eachModeltype->debit > 0) {
                                $total += $eachModeltype->debit;
                                $tot_debit += abs($eachModeltype->debit);
                            }
                            $eachModeltype->currency_id    = $modelVoucher->currency_id;
                            $eachModeltype->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModeltype->save(false);
                        }
                    }
                }

                $modelAccVoucher = new AccVoucher();
                $modelAccVoucher->updatebypk($modelVoucher->id, array('amount' => ($tot_debit), 'net_amount' => ($tot_debit))); //$netTotal
                // -------------------------is_multiple----------------------------------------

                if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                    $voucher_id = $modelVoucher->id;
                    $voucher_date = $_POST['AccVoucher']['start_date'];
                    $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                    $frequency_type = $_POST['AccVoucher']['frequency_type'];
                    $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
                    if ($_POST['AccVoucher']['frequency_no'] >= 1) {
                        for ($i = 1; $i <= $frequency; $i++) {
                            VoucherController::copyVoucher($voucher_id, $voucher_date);
                            if ($frequency_type == 'D') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 day'));
                            }
                            // Weekly
                            elseif ($frequency_type == 'W') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 week'));
                            }
                            // Monthly
                            elseif ($frequency_type == 'M') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 month'));
                            }
                            // Yearly
                            elseif ($frequency_type == 'Y') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 year'));
                            }
                        }
                    }
                }
                // -----------------------------------------------------------------
                $jsonData['status'] = 'success';
                $jsonData['id'] = $modelVoucher->id;
                echo CJSON::encode($jsonData);
            } else {

                if (!empty($modelVoucher)) {

                    $error1 = json_decode(CActiveForm::validate($modelVoucher, '', false), true);
                }


                if (!empty($modelVoucherItems)) {

                    $error2 = json_decode(CActiveForm::validateTabular($modelVoucherItems, '', false), true);
                }


                if (!empty($modeltype)) {


                    $error3 = json_decode(CActiveForm::validateTabular($modeltype, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }





    public function actionUpdatevoucher()
    {
        $id   = (int) $_POST['id'];

        $type = $_POST['type'];

        if ($id > 0) {
            $modelAccVoucher = new AccVoucher();
            $voucherModel    = $modelAccVoucher->findBypk($id);


            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
            $voucher_date = strtotime($voucherModel->voucher_date);
            if ($voucher_date <= $existing_date) {
                $jsonData[] = ' Given Voucher date must be Greater than Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                echo CJSON::encode($jsonData);
            } else {


                //   --------------------//-AccAuditClose check------------------------------------   

                $code = $voucherModel->vtype->code;
                if ($type == 0) {

                    //unpost
                    if ($voucherModel->is_allocated == 'N') {


                        if ($voucherModel->imported == 'N') {
                            $voucherModel->is_posted    = 'N';
                            $voucherModel->save(false);
                            //	$msg = 'success';

                            // inserting to audit log
                            AccAuditLog::saveAuditLogs(
                                'ACCOUNTS',
                                Yii::app()->user->id,
                                'UNPOSTED',
                                changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                            );
                            // end audit log


                            $jsonData['status']    = 'success';
                            echo CJSON::encode($jsonData);
                        } else if ($voucherModel->imported == 'Y') {
                            // ----------added-by-indhu-19-12-2022---------------------------
                            $array_ids = [$voucherModel->transaction_id];
                            // array id's
                            Yii::import('application.modules.accounts.controllers.PostingController');
                            $PostingController = new PostingController('id');
                            if ($code == 'PI') {
                                //if voucher added from purchase invoice
                                $PostingController->addUnpostPurchaseInvoice($array_ids);
                            } else if ($code == 'SI') {
                                //if voucher added from sales invoice
                                $PostingController->addUnpostSales($array_ids);
                            } else if ($code == 'CN') {
                                //if voucher added from sales invoice
                                $PostingController->addUnpostCreditnote($array_ids);
                            } else if ($code == 'DN') {
                                //if voucher added from debit note import
                                $PostingController->addUnpostdebitnote($array_ids);
                            } else if ($code == 'GI') {
                                //if voucher added from Goods issue import
                                $PostingController->addUnpostgoodsissue($array_ids);
                            } else if ($code == 'GR') {
                                //if voucher added from Goods receipt import
                                $PostingController->addUnpostgoodsreceipt($array_ids);
                            } else if ($code == 'RV') {
                                //if voucher added from sales invoice
                                $PostingController->deletePostedReceipt_frm_invoice($voucherModel->transaction_id);
                                $jsonData['status']    = 'success';
                                echo CJSON::encode($jsonData);
                            } else if ($code == 'PV') {
                                //if voucher added from creditnote 
                                $PostingController->deletePostedpayment_frm_creditnote($voucherModel->transaction_id);
                                $jsonData['status']    = 'success';
                                echo CJSON::encode($jsonData);
                            } else if ($code == 'CM') {
                                //if voucher added from sales invoice
                                $PostingController->deletePosted_Commission($voucherModel->transaction_id);
                                $jsonData['status']    = 'success';
                                echo CJSON::encode($jsonData);
                            } else {
                                $jsonData[]            = 'Failed!';
                                echo CJSON::encode($jsonData);
                            }
                            // ---------------------------------------------------------------


                        }
                    } else {
                        //$msg = 'Remove Allocation  first!';

                        $jsonData[]            = 'Remove allocation first!';
                        echo CJSON::encode($jsonData);
                    }
                } else if ($type == 2) {
                    //delete
                    if ($voucherModel->is_allocated == 'N') {
                        $modelAccVoucher            = new AccVoucher();


                        // inserting to audit log
                        AccAuditLog::saveAuditLogs(
                            'ACCOUNTS',
                            Yii::app()->user->id,
                            'DELETED',
                            changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                        );
                        // end audit log


                        $modelAccVoucher->deleteBypk($id);
                        //AccVoucher::model()->deleteBypk($id);
                        $modelAccVoucherItems = new AccVoucherItems();
                        $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $id));
                        //	AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $id));
                        //$msg = 'success';


                        $jsonData['status']    = 'success';
                        echo CJSON::encode($jsonData);
                    } else {
                        //$msg = 'Remove allocation first!';

                        $jsonData[]            = 'Remove allocation first!';
                        echo CJSON::encode($jsonData);
                    }
                } else {
                    //post
                    //	 if ($voucherModel->is_postable_voucher($id)) {
                    $voucherModel->is_posted = 'Y';
                    $voucherModel->posted_date = date('Y-m-d h:i:s');
                    $voucherModel->save(false);
                    //$msg = 'success';

                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'POSTED',
                        changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                    );
                    // end audit log
                    $jsonData['status']    = 'success';
                    echo CJSON::encode($jsonData);
                }
            }   // end auditclose
        } else {
            //echo 'Something Went Wrong!';

            $jsonData[]            = 'Something Went Wrong!';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionGetProducts()
    {
        $modelMasCurrency = new MasCurrency();
        $from       = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition  = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
        $model      = new Store();
        $model      = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value']       = $eachModel->id;
            $availble_qty            = Yii::app()->db->createCommand('SELECT SUM(quantity) as availble_qty FROM `view_all_stock_items` WHERE id=' . $eachModel->id . ' AND stock_updated="Y" GROUP BY id')->queryScalar();
            $data[$i]['label']       = $eachModel->part_number . ' : ' . $eachModel->description . " [Qty: " . $modelMasCurrency->baseCurrencyDecimalNumberFormat($availble_qty) . "]";
            $data[$i]['part_number'] = $eachModel->part_number;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }


    public function actionPrintvoucherPdf()
    {
        $model      = new AccVoucher();
        $id         = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model  = $model->findbyPK($id);
        }
        $mPDF1      = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name  = "voucher_list_pdf";
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("Voucher_" . $id . "_" . strtoupper($model->voucher_no) . ".pdf", 'I');
    }



    // -----------------------------------------------------------------------------------------------------------
    //Import functions
    //view page ->accounts/voucher
    //------------------------------------------------------------------------------------------------------------


    public function actionImportvouchers()
    {
        $from         = Yii::app()->request->getParam('from');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('voucher_import', array('from' => $from));
    }



    public function actionGetimportvouchers()
    {

        $status     = $_POST['status'];
        $voucher    = $_POST['voucher'];
        $from_date  = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date    = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $import     = $_POST['voucher_import'];

        //   ---------------------AccAuditClose check------------------------------------
        $modelAccAuditClose = new AccAuditClose();
        $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
        $from_date_check = strtotime($from_date);
        $to_date_check = strtotime($to_date);

        if ($from_date_check <= $existing_date || $to_date_check <= $existing_date) {
            echo 'auditclose';
        } else {
            //   ---------------------------------------------------------
            $modelAccVoucherType   = new AccVoucherType;
            $model_vouchertype     = $modelAccVoucherType->findBypk($voucher);

            if ($import == "Y") {
                if ($model_vouchertype['code'] == 'SI') {
                    // Sales Invoice
                    $this->render('import_si_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'PI') {
                    //Purchase Invoice
                    $this->render('import_pi_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'CN') {
                    //Credit Note
                    $this->render('import_cn_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'DN') {
                    //debite Note
                    $this->render('import_dn_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'GI') {
                    //Goods  issues
                    $this->render('import_gi_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'GR') {
                    //Goods  receipts
                    $this->render('import_gr_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'MR') {
                    //Goods  receipts
                    $this->render('import_meterial_receipt_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                }
            } else {

                $this->render('import_voucher_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status, 'import' => $import));
            }

            // -----------------------------------------------------
        }
    }


    public function actionGetImportVoucherList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new AccVoucher();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        $vouchertype   = $_POST['vouchertype'];

        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'code',
            1 => 'file_id',
            2 => 'transaction_number',
            3 => 'reference_no',
            4 => 'voucher_date',
            5 => 'voucher_type',
            6 => 'warehouse_name',
            7 => 'imported',
            8 => 'ledger_name',
            9 => 'subledger_name',
            10 => 'net_amount',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = 'imported="N"';

        if ($status != '') {
            $condition .= ' AND is_posted="' . $status . '"';
        }

        if ((int)$vouchertype > 0) {
            $condition .= " AND voucher_type_id = " . $vouchertype;
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND voucher_date>="' . $start_date . '" AND voucher_date<="' . $end_date . '"';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (voucher_no LIKE "%' . $searchString . '%"
			 OR voucher_type LIKE "%' . $searchString . '%"
			  OR transaction_number LIKE "%' . $searchString . '%"
			 OR code LIKE "%' . $searchString . '%"
            OR subledger_name LIKE "%' . $searchString . '%" OR ledger_name LIKE "%' . $searchString . '%" OR reference_no LIKE "%' . $searchString . '%" OR amount LIKE "%' . $searchString . '%")';
        }



        $query = 'SELECT id,voucher_no,code,is_posted,is_allocated,imported,transaction_number,voucher_type_id,file_id,reference_no,voucher_type,ledger_name,subledger_name,net_amount,voucher_date,warehouse_name,warehouse_id FROM view_acc_voucher_items WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_acc_voucher_items WHERE ' . $condition . ' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();



        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItem['file_id'] == 0 ? $file_id = '-' : $file_id = $eachItem['file_id'];

            $eachItem['transaction_number'] == 0 ? $transaction_number = '-' : $transaction_number = $eachItem['transaction_number'];

            if ($eachItem['imported'] == "Y") {
                $imported = 'Yes';
            } else {
                $imported = 'No';
            }


            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['code'] . "/" . $eachItem['voucher_no'],
                    $file_id,
                    $transaction_number,
                    $eachItem['reference_no'],
                    (!empty($eachItem['voucher_date'])) ? date('d/m/Y', strtotime($eachItem['voucher_date'])) : "-",
                    $eachItem['voucher_type'],
                    $eachItem['warehouse_name'],
                    $imported,
                    $eachItem['ledger_name'],
                    $eachItem['subledger_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['net_amount']),
                    $eachItem['id'],
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionGetimportvouchers17_01_2024()
    {

        $status     = $_POST['status'];
        $voucher    = $_POST['voucher'];
        $from_date  = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date    = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        //   ---------------------AccAuditClose check------------------------------------
        $modelAccAuditClose = new AccAuditClose();
        $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
        $from_date_check = strtotime($from_date);
        $to_date_check = strtotime($to_date);

        if ($from_date_check <= $existing_date || $to_date_check <= $existing_date) {
            echo 'auditclose';
        } else {
            //   ---------------------------------------------------------
            $modelAccVoucherType   = new AccVoucherType;
            $model_vouchertype     = $modelAccVoucherType->findBypk($voucher);

            if ($model_vouchertype['code'] == 'SI') {
                // Sales Invoice
                $this->render('import_si_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
            } else if ($model_vouchertype['code'] == 'PI') {
                //Purchase Invoice
                $this->render('import_pi_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
            } else if ($model_vouchertype['code'] == 'CN') {
                //Credit Note
                $this->render('import_cn_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
            } else if ($model_vouchertype['code'] == 'DN') {
                //debite Note
                $this->render('import_dn_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
            } else if ($model_vouchertype['code'] == 'GI') {
                //Goods  issues
                $this->render('import_gi_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
            } else if ($model_vouchertype['code'] == 'GR') {
                //Goods  receipts
                $this->render('import_gr_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
            }
            // -----------------------------------------------------
        }
    }


    // -----------------------------------------------------------------------------------------------------------
    //Listing Sales Invoice in  finance voucher Import
    //view page ->accounts/voucher/import_si_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportSalesList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new Invoice();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.invoice_no',
            3 => 't.invoice_date',
            4 => 'customer.customer_name',
            5 => 't.grand_total',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = 't.invoice_status!="C"';

        if ($status != '') {
            $condition .= ' AND t.posted ="' . $status . '"';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND t.invoice_date>="' . $start_date . '" AND t.invoice_date<="' . $end_date . '"';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {

            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (t.invoice_no LIKE "%' . $searchString . '%"
			 OR t.id LIKE "%' . $searchString . '%"
			 OR t.invoice_date LIKE "%' . $searchString . '%"
            OR customer.customer_name LIKE "%' . $searchString . '%" 
            OR t.grand_total LIKE "%' . $searchString . '%" 
            OR t.id LIKE "%' . $searchString . '%")';
        }


        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['invoice_no'],
                    date('d/m/Y', strtotime($eachItem['invoice_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['grand_total']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }



    // -----------------------------------------------------------------------------------------------------------
    //Listing Purchasing Invoice in  finance voucher Import
    //view page ->accounts/voucher/import_pi_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportPurchaseList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new PurchasingInvoice();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.invoice_no',
            3 => 't.invoice_date',
            4 => 'vendor_details.vendor_name',
            5 => 't.grand_total',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (invoice_date>="' . $start_date . '" AND invoice_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= '  AND (t.invoice_no LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.invoice_date LIKE "%' . $searchString . '%"
        OR vendor_details.vendor_name LIKE "%' . $searchString . '%" 
        OR t.grand_total LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%") ';
        }

        $count = $model->with('vendor_details')->count(array('condition' => $condition));
        $model = $model->with('vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['invoice_no'],
                    date('d/m/Y', strtotime($eachItem['invoice_date'])),
                    $eachItem['vendor_details']['vendor_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['grand_total']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }


    // -----------------------------------------------------------------------------------------------------------
    //Listing Creditnote in  finance voucher Import
    //view page ->accounts/voucher/import_cn_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportCreditNoteList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new Creditnote();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.invoice_id',
            3 => 't.credited_date',
            4 => 'customer.customer_name',
            5 => 't.credited_amount',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1 AND is_updated_store = "Y" ';

        if ($status != '') {
            $condition .= ' AND (t.posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (credited_date>="' . $start_date . '" AND credited_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND(t.invoice_id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.credited_date LIKE "%' . $searchString . '%"
        OR customer.customer_name LIKE "%' . $searchString . '%" 
        OR t.credited_amount LIKE "%' . $searchString . '%" 
        OR invoice.invoice_no LIKE "%' . $searchString . '%")';
        }

        $count = $model->with('customer', 'invoice')->count(array('condition' => $condition));
        $model = $model->with('customer', 'invoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['invoice']['invoice_no'],
                    date('d/m/Y', strtotime($eachItem['credited_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['credited_amount']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    // -----------------------------------------------------------------------------------------------------------
    //Listing Purchasing debitnote in  finance voucher Import
    //view page ->accounts/voucher/import_dn_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportDebitNoteList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new Purchasingdebitnote();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.purchasing_invoice_id',
            3 => 't.debited_date',
            4 => 'vendor_details.vendor_name',
            5 => 't.debited_amount',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (debited_date>="' . $start_date . '" AND debited_date<="' . $end_date . '")';
        }
        $condition .= 'AND t.is_goods_returned="Y"';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND(t.purchasing_invoice_id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.debited_date LIKE "%' . $searchString . '%"
        OR vendor_details.vendor_name LIKE "%' . $searchString . '%" 
        OR t.debited_amount LIKE "%' . $searchString . '%" 
        OR t.file_id LIKE "%' . $searchString . '%")';
        }

        $count = $model->with('vendor_details')->count(array('condition' => $condition));
        $model = $model->with('vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],

                    $eachItem['purchasing_invoice_id'],
                    date('d/m/Y', strtotime($eachItem['debited_date'])),
                    $eachItem['vendor_details']['vendor_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['debited_amount']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }


    // -----------------------------------------------------------------------------------------------------------
    //Listing  Inventory Goods Issue in  finance voucher Import
    //view page ->accounts/voucher/import_gi_list.php
    //------------------------------------------------------------------------------------------------------------

    public function actionGetImportGoodsissueList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new InventoryGoodsIssue();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.id',
            3 => 't.goods_issue_date',
            4 => 'customer.customer_name',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (goods_issue_date>="' . $start_date . '" AND goods_issue_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND(t.id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.goods_issue_date LIKE "%' . $searchString . '%"
        OR customer.customer_name LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%")';
        }
        $condition .= 'AND t.stock_updated="Y"';
        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_issue_item where inventory_goods_issue_id='" . $eachItem['id'] . "' ")->queryScalar();

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['reference'],
                    date('d/m/Y', strtotime($eachItem['goods_issue_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }




    // -----------------------------------------------------------------------------------------------------------
    //Listing  Inventory Goods Receipt in  finance voucher Import
    //view page ->accounts/voucher/import_gr_list.php
    //------------------------------------------------------------------------------------------------------------


    public function actionGetImportGoodsreceiptList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new InventoryGoodsReceipt();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.id',
            3 => 't.goods_receipt_date',
            4 => 'customer.customer_name',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';
        $condition = 't.isActive="Y" AND t.stock_updated="Y"';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (goods_receipt_date>="' . $start_date . '" AND goods_receipt_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (t.id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.goods_receipt_date LIKE "%' . $searchString . '%"
        OR customer.customer_name LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%")';
        }
        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_receipt_item where inventory_goods_receipt_id='" . $eachItem['id'] . "' ")->queryScalar();

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['reference'],
                    date('d/m/Y', strtotime($eachItem['goods_receipt_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    //end

    public function actionAdd_commission()
    {
        $model = new AccVoucher;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_commission_voucher', array('model' => $model));
    }
    public function actionget_commissionemployee()
    {
        $warehouse_id = (int)$_POST['warehouse_id'];



        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        $commision_payable = $modelAccSystemAccountsMapping->getSystemdefault('commision_payable');

        $condition = 'VI.ledger_id = ' . (int)$commision_payable;
        if ($warehouse_id > 0) {
            $condition .= ' AND VI.warehouse_id = ' . (int)$warehouse_id;
        }
        $list = Yii::app()->db->createCommand(
            '
             SELECT IFNULL(-1*SUM(VI.amount),0) as commission_amount ,S.subledger_name AS subledger_name,S.id AS subledger_id
             FROM erp_acc_voucher_items VI
             LEFT JOIN erp_acc_subledger S ON S.id=VI.subledger_id
              WHERE ' . $condition . '
             GROUP BY  VI.subledger_id,VI.warehouse_id'
        )->queryAll();

        $tbl_contents = '';
        $colspan = 4;
        $tbl_contents = '<table class="table table-hover table-bordered personal-task" id="tbl_commission_employee">        
        <tr>            
        <th>No</th>     
        <th>Subledger Name</th>            
        <th>Commission Amount</th>   
        <th>Paid Amount</th>
       </tr>';
        $n = 0;
        if (!empty($list)) {
            foreach ($list as $i => $eachemployee) {

                if (floatval($eachemployee['commission_amount']) != 0) {
                    $tbl_contents .= '<tr>';
                    $tbl_contents .= '<td>' . CHtml::CheckBox("AccVoucherItems[$n]['check']", '', array('class' => 'debit', 'value' => $eachemployee['subledger_id'], 'onChange' => 'copyValue("AccVoucherItems", this, this.id); calculatecommissionValue();')) .
                        CHtml::hiddenField("AccVoucherItems[$n][subledger_id]", $eachemployee['subledger_id']) .
                        CHtml::hiddenField("AccVoucherItems[$n][commission_amount]", $eachemployee['commission_amount']) .
                        ' ' . ($n + 1) . '</td>';
                    $tbl_contents .= '<td>' . $eachemployee['subledger_name'] . '</td>';
                    $tbl_contents .= '<td class="text-right">' . $eachemployee['commission_amount'] . '</td>';
                    $tbl_contents .= '<td class="text-right">' . CHtml::textField("AccVoucherItems[$n][paid_amount]", '0', array('class' => 'go', 'onkeyup' => 'calculatecommissionValue();', 'onkeypress' => 'return isNumberKey(event);')) . '</td>';
                    $tbl_contents .= '</tr>';
                    $n++;
                }
            }
        } else {
            $tbl_contents .=  '<tr><td colspan="' . $colspan . '" class="text-center text-bold">No Commission Exist</td></tr>';
        }
        $tbl_contents .= '</table>';
        $data['tbl_contents'] = $tbl_contents;
        $data['success'] = $tbl_contents;
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    // ----------------added on 23_06_2023---------------------------------------

    public function actionGetallocationdataFromPayment()
    {
        $modelMasCurrency = new MasCurrency();
        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];


        $allocationCredit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_credit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        ABS(VI.amount * VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationCredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_credit}} WHERE balance > 0')->queryScalar();

        if ($creditAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';

            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';

            if ($creditAllocatables != '') {

                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_credit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (" . $creditAllocatables . ")
                        GROUP BY V.id
                        ORDER BY V.voucher_date";

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();

                foreach ($allItems as $i => $each) {
                    $tables['credit'] .= '<tr>
										<td>' . CHtml::CheckBox('Credit[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("Credit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['voucher_type'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('Credit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Credit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Credit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Credit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Credit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
                }

                $tables['credit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';

                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }


        echo json_encode($tables);
    }


    public function actionGetExchangeRateFromExchangeMaster_deleted()
    {
        $response = ['success' => true, 'debit' => '', 'error' => ''];
        $modeAccLedger = new AccLedger();
        $base_currency_code = $modeAccLedger->baseCurrencycode();
        $voucher_currency_code       =  $_POST['voucher_currency_code'];
        $receiptledger_currency_code =  $_POST['receiptledger_currency_code'];
        $amount_selected_currency    =  $_POST['amount_selected_currency'];

        $modelMasCurrencyExchange = new MasCurrencyExchange();

        $exchange_rate = $modelMasCurrencyExchange->getcurrencyexchange($voucher_currency_code, $base_currency_code);

        $exchange_rate_diff = $modelMasCurrencyExchange->getcurrencyexchange($receiptledger_currency_code, $voucher_currency_code);

        $response['exchange_rate'] = ($exchange_rate > 0) ? $exchange_rate : 0;

        $exchange_rate_diff = ($exchange_rate_diff > 0) ? $exchange_rate_diff : 0;

        $response['exchange_difference_amount'] = ((float)abs($amount_selected_currency) * (float)$exchange_rate_diff);

        echo json_encode($response);
    }

    public function actionGetMultipleExchangeRates()
    {
        $currencyPairs = $_POST['currencyPairs'];
        $exchangeRates = [];

        $modelMasCurrencyExchange = new MasCurrencyExchange();
        $modeAccLedger = new AccLedger();
        $base_currency_code = $modeAccLedger->baseCurrencycode();
        foreach ($currencyPairs as $pair) {
            $voucher_currency_code = $pair['voucher_currency_code'];
            $receiptledger_currency_code = $pair['receiptledger_currency_code'];

            $exchange_rate = $modelMasCurrencyExchange->getcurrencyexchange($voucher_currency_code, $base_currency_code);
            $exchange_rate_diff = $modelMasCurrencyExchange->getcurrencyexchange($receiptledger_currency_code, $voucher_currency_code);

            $exchangeRates[] = [
                'voucher_currency_code' => $voucher_currency_code,
                'receiptledger_currency_code' => $receiptledger_currency_code,
                'exchange_rate' => ($exchange_rate > 0) ? $exchange_rate : 0,
                'exchange_rate_diff' => ($exchange_rate_diff > 0) ? $exchange_rate_diff : 0
            ];
        }

        echo json_encode($exchangeRates);
    }




    public function actionGetallocationdataFromReceiptDebitxxxxxxxxx()
    {
        $modelMasCurrency = new MasCurrency();
        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];


        $allocationdebit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_debit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        (VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount > 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationdebit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_debit}} WHERE balance > 0')->queryScalar();



        if ($debitAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['debit'] = '';

            $tables['debit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['debit'] .= '<tbody id="credit_table">';


            if ($debitAllocatables != '') {


                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_debit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_debit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $debitAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();




                foreach ($allItems as $i => $each) {

                    $tables['debit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class' => 'debit', 'value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValuedebit();')) . '</td>
									</tr>';
                }

                $tables['debit'] .= '<tr>
									<td colspan="6" class="text-right"><b></b></td>
									<td>' . CHtml::hiddenfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
                $tables['debit'] .= '</tbody>';
                $tables['debit'] .= '</table>';
            } else {
                $tables['debit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }



        echo json_encode($tables);
    }

    public function actionGetallocationdataFromReceiptDebit()
    {
        $response = ['success' => true, 'debit' => '', 'error' => ''];
        $modelAccLedger = new AccLedger();
        $modelMasCurrency = new MasCurrency();
        $ledger    = (int) $_POST['ledger'];

        $subledger = (int) $_POST['subledger'];


        $allocationdebit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_debit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        (VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount > 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationdebit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_debit}} WHERE balance > 0')->queryScalar();


        if ($debitAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {
            $tables = array();
            $tables['debit'] = '';

            $tables['debit'] .= '<table class="table table-bordered" id="table_credit">        
                                <thead>
                                    <tr>
                                       <th style="width:5%"><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>  
                                    </tr>
                                </thead>';
            $tables['debit'] .= '<tbody id="credit_table">';

            if ($debitAllocatables != '') {
                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_debit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_debit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $debitAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();

                foreach ($allItems as $i => $each) {


                    $tables['debit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class' => 'debit', 'value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValuedebit();')) . '</td>
									</tr>';
                }

                $tables['debit'] .= '<tr>
                                            <td colspan="6" class="text-right"><b></b></td>
                                            <td>' . CHtml::hiddenField('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
                                        </tr>';
                $tables['debit'] .= '</tbody>';
                $tables['debit'] .= '</table>';
                //}
            } else {
                $tables['debit'] .= '<tr>
                                        <td colspan="13" class="text-center"><b>No Data</b></td>
                                    </tr>';
            }
        }

        $response['debit'] = $tables['debit'];
        echo json_encode($response);
    }


    public function actionGetallocationdataFromReceiptCredit()
    {

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $modelMasCurrency = new MasCurrency();

        $allocationcredit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_credit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                       ABS( (VI.amount*VI.exchange_rate)) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationcredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_credit}} WHERE balance > 0')->queryScalar();



        if ($creditAllocatables === false) {
            $tables = array();
            $tables['credit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['credit'] = '';

            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-allcredit" onclick="toggleSelectAllCREDIT()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';


            if ($creditAllocatables != '') {


                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        -COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_credit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_credit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $creditAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();




                foreach ($allItems as $i => $each) {

                    $tables['credit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('CREDIT[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("CREDIT", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('CREDIT[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('CREDIT[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("CREDIT", this.id, this.value); calculateValuecredit();')) . '</td>
									</tr>';
                }

                $tables['credit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Grand Total</b></td>
									<td>' . CHtml::hiddenfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) .
                    CHtml::textfield('total_amount_crdr', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }
        echo json_encode($tables);
    }


    public function actionGetallocationdataFromReceiptCredit26_08_2024()
    {
        $response = ['success' => true, 'debit' => '', 'error' => ''];
        $modelAccLedger = new AccLedger();

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];

        $receipt_acc_currencyid = (int)$modelAccLedger->findByPk($ledger)->currency_id;

        // --------------------Receipt mode---------------------------------------------------
        $to_account = (int) $_POST['to_account'];
        $modelAccLedger_currencyid = $modelAccLedger->findByPk($to_account)->currency_id;

        $modelMasCurrency = new MasCurrency();
        $receipt_currency_code = $modelMasCurrency->findByPk($modelAccLedger_currencyid)->currency_code;
        // -----------------------------------------------------------------------------------


        $allocationcredit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_credit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                       ABS( (VI.amount*VI.exchange_rate)) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationcredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_credit}} WHERE balance > 0')->queryScalar();



        if ($creditAllocatables === false) {
            $tables = array();
            $tables['credit'] = '';
            $tables['credit'] = '';
        } else {
            $tables = array();
            $tables['credit'] = '';
            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-allcredit" onclick="toggleSelectAllCREDIT()"></th>
                                    <th>#</th>
                                        <th>Ref.</th>  
                                        <th>Type</th>      
                                        <th>Date</th>
                                        <th>Inv.Amt</th>
                                        <th>Currency</th>
                                        <th>Inv.Balance</th> 
                                        <th>Alloc.</th>     
                                        <th>EXC.Rate</th> 
                                        <th title="Alloc * Exchangerate">Amt In Selected Currency</th> 
                                        <th>Base Currency Amt</th> 
                                        <th>EXC Diff Amt.</th>                               
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';


            if ($creditAllocatables != '') {

                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                       COALESCE(C.amount, 0) AS amount,
                        -COALESCE(C.balance, 0) AS balance, CUR.currency_code
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                           LEFT JOIN {{mas_currency}} CUR ON CUR.id = V.currency_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_credit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_credit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $creditAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();
                // ----------------------customer_currencycode-----------------------------------------
                $sqlcur = "SELECT CUR.currency_code AS currency_code, C.customer_currency_id AS currency_id
                FROM erp_acc_subledger S 
                LEFT JOIN erp_customer C ON C.id = S.reference_id
                LEFT JOIN erp_mas_currency CUR ON CUR.id = C.customer_currency_id
                WHERE S.id = :subledger";
                $commandcur = Yii::app()->db->createCommand($sqlcur);
                $commandcur->bindParam(':subledger', $subledger, PDO::PARAM_INT);
                $curr = $commandcur->queryRow();
                $customer_currencycode = $curr['currency_code'];
                //if ($customer_currencycode !== $receipt_currency_code) {
                // if ((int)$receipt_acc_currencyid !== (int)$modelAccLedger_currencyid) {
                //     $response['success'] = false;
                //     $response['error'] = "Customer and ReceiptMode  currency must be equal.";
                // } else {
                foreach ($allItems as $i => $each) {
                    // ----------------------------------------------
                    $modelMasCurrencyExchange = new MasCurrencyExchange();
                    $exchange_rate = $modelMasCurrencyExchange->getcurrencyexchange($each['currency_code'], $receipt_currency_code);
                    $modeAccLedger = new AccLedger();
                    $baseCurrencycode = $modeAccLedger->baseCurrencycode();

                    /*  $amt_in_selected_currency = (float)$each['balance'] * (float)$exchange_rate;                  

                    $sqlbase_currency  = "SELECT * FROM {{mas_currency_exchange}} WHERE currency_code = '" . $each['currency_code'] . "'";
                    $commandbase_currency = Yii::app()->db->createCommand($sqlbase_currency);
                    $base_currency_det = $commandbase_currency->queryRow();

                    $exchange_rate_for_exch_diff = $modelMasCurrency->find(array('condition' => 'currency_code="' . $receipt_currency_code . '"'))->exchange_rate;

                    $base_currency_amount = (float)$base_currency_det[$baseCurrencycode] * (float)$each['balance'];

                    $exchange_difference_amount = ((float)$amt_in_selected_currency * (float)$exchange_rate_for_exch_diff) - (float)$base_currency_amount;
                     */
                    // ----------------------------------------------

                    $tables['credit'] .= '<tr>                    
										<td>' . CHtml::CheckBox('CREDIT[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("CREDIT", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
                                        <td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['amount']) . '</td>
                                        <td>' . $each['currency_code'] . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
                                        <td>' . CHtml::hiddenfield('CREDIT[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenField('Debit[' . $i . '][receiptledger_currency_code]', $receipt_currency_code) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('CREDIT[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("CREDIT", this.id, this.value); calculateValuecredit();')) . '
                                        </td>
                                        <td>' . CHtml::textField('CREDIT[' . $i . '][exchange_rate]', $exchange_rate, array('value' => $exchange_rate, 'class' => 'form-control text-right', 'readonly' => true)) . '</td> 
                                        <td>' . CHtml::textField('CREDIT[' . $i . '][amount_selected_currency]', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td> 
                                        <td>' .
                        CHtml::hiddenField('CREDIT[' . $i . '][voucher_currency_code]', $each['currency_code']) .
                        CHtml::hiddenField('CREDIT[' . $i . '][base_currency_code]', $baseCurrencycode) .
                        CHtml::textField('CREDIT[' . $i . '][base_currency_amount]', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '
                                        </td> 
                                        <td>' . CHtml::textField('CREDIT[' . $i . '][exchange_difference_amount]', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td> 
                                        </tr>';
                }

                $tables['credit'] .= '<tr>
									<td colspan="12" class="text-right"><b>Grand Total</b></td>
									<td>' . CHtml::hiddenfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) .
                    CHtml::textfield('total_amount_crdr', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
                // }
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="13" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }
        $response['credit'] = $tables['credit'];
        echo json_encode($response);
    }


    public function actionGetallocationdataFromReceiptDebit29_07_2024()
    {

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];

        // --------------------Receipt mode---------------------------------------------------
        $to_account = (int) $_POST['to_account'];
        $modelAccLedger = new AccLedger();
        $modelAccLedger_currencyid = $modelAccLedger->findBypk((int) $to_account)->currency_id;

        $modelMasCurrency      = new MasCurrency();
        $receipt_currency_code = $modelMasCurrency->findBypk((int)$modelAccLedger_currencyid)->currency_code;
        // -----------------------------------------------------------------------

        $allocationdebit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_debit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        (VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount > 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationdebit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_debit}} WHERE balance > 0')->queryScalar();

        if ($debitAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['debit'] = '';

            $tables['debit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style=""><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="">#</th>
                                <th style="">Ref.</th>  
                                <th style="">Type</th>      
                                <th style="">Date</th>
                                <th style="">Inv.Amt</th>
                                <th style="">Currency</th>
                                 <th style="">Inv.Balance</th> 
                                 <th style="">EXC.Rate</th> 
                                <th style="">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['debit'] .= '<tbody id="credit_table">';


            if ($debitAllocatables != '') {

                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                       COALESCE(C.amount, 0) AS amount,
                        COALESCE(C.balance, 0) AS balance,CUR.currency_code
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{mas_currency}} CUR ON CUR.id = V.currency_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_debit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_debit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $debitAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();


                // ----------------------customer_currencycode-----------------------------------------
                $sqlcur = "SELECT CUR.currency_code as currency_code,C.customer_currency_id as currency_id
                        FROM erp_acc_subledger S 
                        LEFT JOIN erp_customer C ON C.id = S.reference_id
                        LEFT JOIN erp_mas_currency CUR ON CUR.id = C.customer_currency_id
                        WHERE S.`id` = '" . $subledger . "'";
                $commandcur = Yii::app()->db->createCommand($sqlcur);
                $curr = $commandcur->queryAll();
                $customer_currencycode = $curr[0]['currency_code'];

                // ----------------------payment mode currencycode-----------------------------------------
                $sqlcur = "SELECT CUR.currency_code as currency_code,C.customer_currency_id as currency_id
                        FROM erp_acc_subledger S 
                        LEFT JOIN erp_customer C ON C.id = S.reference_id
                        LEFT JOIN erp_mas_currency CUR ON CUR.id = C.customer_currency_id
                        WHERE S.`id` = '" . $subledger . "'";
                $commandcur = Yii::app()->db->createCommand($sqlcur);
                $curr = $commandcur->queryAll();

                $customer_currencycode = $curr[0]['currency_code'];
                $modelMasCurrency = new MasCurrency();
                // ---------------------------------------------------------------
                foreach ($allItems as $i => $each) {
                    $modelMasCurrencyExchange = new MasCurrencyExchange();
                    $exchange_rate = $modelMasCurrencyExchange->getcurrencyexchange($each['currency_code'], $receipt_currency_code);


                    $tables['debit'] .= '<tr>
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class' => 'debit', 'value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
									    <td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['amount']) . '</td>
                                    	<td>' . $each['currency_code'] . '</td>										
                                    	<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
                                    	<td>' . $exchange_rate . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValuedebit();')) . '</td>
									</tr>';
                }

                $tables['debit'] .= '<tr>
									<td colspan="6" class="text-right"><b></b></td>
									<td>' . CHtml::hiddenfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
                $tables['debit'] .= '</tbody>';
                $tables['debit'] .= '</table>';
            } else {
                $tables['debit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }



        echo json_encode($tables);
    }

    public function actionGetallocationdataFromReceiptCredit30_07_2024()
    {

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $modelMasCurrency = new MasCurrency();

        $allocationcredit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_credit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                       ABS( (VI.amount*VI.exchange_rate)) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationcredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_credit}} WHERE balance > 0')->queryScalar();



        if ($creditAllocatables === false) {
            $tables = array();
            $tables['credit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['credit'] = '';

            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-allcredit" onclick="toggleSelectAllCREDIT()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';


            if ($creditAllocatables != '') {


                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        -COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_credit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_credit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $creditAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();




                foreach ($allItems as $i => $each) {

                    $tables['credit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('CREDIT[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("CREDIT", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('CREDIT[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('CREDIT[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("CREDIT", this.id, this.value); calculateValuecredit();')) . '</td>
									</tr>';
                }

                $tables['credit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Grand Total</b></td>
									<td>' . CHtml::hiddenfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) .
                    CHtml::textfield('total_amount_crdr', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }
        echo json_encode($tables);
    }

    public function actionVouchersExcel()
    {

        $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $voucher_type   = (int) $_REQUEST['voucher_type'];
        $warehouse_id   = (int)$_REQUEST['warehouse_id'];
        $outlet_id   = (int)$_REQUEST['outlet_id'];

        $param = array(
            'from_date'    => $from_date,
            'to_date'      => $to_date,
            'voucher_type' => $voucher_type,
            'warehouse_id' => $warehouse_id,
            'outlet_id'    => $outlet_id,

        );

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'voucher_Excel.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.modules.accounts.views.voucher.excel.voucher_Excel', $param, false, true);
        Yii::app()->end();
    }

    public function actionPrintPaymentReciptvoucherPdf()
    {
        $model      = new AccVoucher();
        $id         = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model  = $model->findbyPK($id);
        }
        $mPDF1      = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name  = "voucher_list_new_pdf";
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("Voucher_" . $id . "_" . strtoupper($model->voucher_no) . ".pdf", 'I');
    }


    function copyVoucher($voucher_id, $voucher_date)
    {
        $existVoucher = AccVoucher::model()->findByPk((int)$voucher_id);

        if ($existVoucher !== null) {
            $modelVoucher = new AccVoucher();
            $modelVoucher->setAttributes($existVoucher->getAttributes());
            $modelVoucher->voucher_date = $voucher_date;
            $modelVoucher->isNewRecord = true;
            $modelVoucher->general_narration = $existVoucher['general_narration'];
            $modelVoucher->imported = 'N';
            $modelVoucher->voucher_no    = AccVoucherType::getVoucherno($existVoucher->voucher_type, true);
            $modelVoucher->transaction_number    =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_id        =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_date      =  $modelVoucher->voucher_date;
            $modelVoucher->lead_owner            = (int)Yii::app()->user->id;
            $modelVoucher->is_posted         = $existVoucher['is_posted'];
            $modelVoucher->created_by       = Yii::app()->user->id;
            $modelVoucher->created_datetime = date('Y-m-d h:i:s');
            $modelVoucher->updated_by       = Yii::app()->user->id;
            $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
            $modelVoucher->save(false);
            $modelVoucher->refresh();
            // inserting to audit log  
            if($existVoucher['is_posted']=='Y'){
                $audit_type='POSTED';
            }else{
                $audit_type='CREATED';
            }      
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                $audit_type,
                "{$existVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
            );
            // end audit log

            $new_id = $modelVoucher->id;

            $modelItems = AccVoucherItems::model()->findAll('acc_voucher_id=:voucher_id', array(':voucher_id' => $voucher_id));
            foreach ($modelItems as $eachvItem) {
                $modelVi = new AccVoucherItems();
                $modelVi->setAttributes($eachvItem->getAttributes());
                $modelVi->acc_voucher_id = $new_id;
                $modelVi->isNewRecord = true;
                $modelVi->updated_by       = Yii::app()->user->id;
                $modelVi->updated_datetime = date('Y-m-d H:i:s');
                $modelVi->created_by       = Yii::app()->user->id;
                $modelVi->created_datetime = date('Y-m-d H:i:s');
                $modelVi->save(false);
            }
            return true;
        }
    }
}
