<?php

/* Subledgers
 
 date 21-09-2022
 author -Indhu 
 main setup
 Tables - acc_subledger
 Model - AccSubledger */

class SubledgersController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'GetList', 'Create', 'Save', 'Subledgerlist', 'GetReferenceid', 'Syncsubledgers', 'Subledgerlist_all','DeleteSublegder',
                    'SaveSubledger', 'GetSubledgerlist'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    // public $modelMasCurrency; 

    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }
    
    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_subLedgers_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_subLedgers_menu_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}


    public function actionGetList()
    {
        $model             = new AccSubledger();
        $draw              = $_POST['draw'];
        $offset            = $_POST['start'];
        $limit             = $_POST['length'];
        $subledger_type_id = $_POST['subledger_type_id'];


        $columns = array(
            // datatable column index  => database column name
            0 => 't.reference_id',
            1 => 't.subledger_name',
            2 => 't.subledger_type',
            3 => 't.last_sync',
            4 => 't.id',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy     = $filterColumn . " " . $filterOrder;
        $condition   = '1=1';

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    = 't.subledger_name LIKE "%' . $searchString . '%" OR t.reference_id LIKE "%' . $searchString . '%"';
        }
        if ((int)$subledger_type_id > 0) {
            $condition .= " AND subledger_type = " . $subledger_type_id;
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->with('subledgertype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        $eachItemData            = array();
        $m = 1;

        foreach ($model as $eachItem) {
            $div      = '<div class="btn-wrap text-center">';
            if ($eachItem['is_system'] == 'N') {
                // -----------------------------------------------------------------
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_subLedgers_edit"])) {
                    $div .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/subledgers/Create&id=' . $eachItem['id'] . '\',\'Edit Subledgers \',\'lg\')"><i class="fa fa-edit"></i></a>';
                }
                $modelAccVoucherItems = new AccVoucherItems;
                if ($modelAccVoucherItems->no_of_subledger_entries($eachItem['id']) == 0) {
                    // -----------------------------------------------------------------
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_subLedgers_delete"])) {
                        $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteSublegder(' . $eachItem['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                    }
                }
            }
            $eachItemData[] = array(
                $eachItem['reference_id'],
                $eachItem['subledger_name'],
                $eachItem->subledgertype->description,
                ($eachItem['last_sync'] != "0000-00-00") ? date('d/m/Y', strtotime($eachItem['last_sync'])) : "-", $eachItem->related_ledgers(),
                $div
            );
            $m++;
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model     = new AccSubledger();
        $id        = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findBypk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model));
    }


    public function actionSave()
    {
        $model = new AccSubledger();
        if (isset($_POST['AccSubledger'])) {
            if ((int)$_POST['AccSubledger']['id'] > 0) {
                $id                      = $_POST['AccSubledger']['id'];
                $model                   = $model->findByPk($id);
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
            } else {
                $model->created_by       = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
            }
            $model->attributes           = $_POST['AccSubledger'];
            $model->is_system            = 'N';
            if ($_POST['AccSubledger']['last_sync'] != '0000-00-00' && $_POST['AccSubledger']['last_sync'] != '') {
                $model->last_sync        = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccSubledger']['last_sync'])));
            }

            if ($model->save()) {
                echo json_encode(array('status' => 'success'));
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                echo CJSON::encode(array_merge_recursive($error1));
            }
        }
    }



    public function actionGetReferenceid()
    {
        $subledger_type            = $_POST['subledger_type'];
        $modelAccSubledgerType     = new AccSubledgerType();
        $modelAccSubledgerType_det = $modelAccSubledgerType->findBypk((int) $subledger_type);
        $start_serial = $modelAccSubledgerType_det['start_serial'];
        //   SELECT * FROM `erp_acc_subledger` ORDER BY `erp_acc_subledger`.`id` DESC
        $modelAccSubledger     =  new AccSubledger();
        $condition             = 't.subledger_type= ' . $subledger_type;
        $modelAccSubledger_det = $modelAccSubledger->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
        if (!empty($modelAccSubledger_det[0]->reference_id)) {
            $next_id           = $modelAccSubledger_det[0]->reference_id + 1;
        } else {
            $next_id           =  $start_serial;
        }
        echo CJSON::encode($next_id);
    }

    // --------added-by-indhu-17-11-2022-----------------------------------------------------

    //  synchronizing customer, and vendor tables to sub-ledger

    public function actionSyncsubledgers()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('sync_subledgers');
    }

    public function actionSaveSubledger()
    {

        // Add All customers, and vendors As sub-ledger

        $subledger_type    = $_POST['AccSubledger']['subledger_type'];
        $modelAccSubledger = new AccSubledger();

        if ($subledger_type == 'C') {
            $data          = $modelAccSubledger->saveCustomerSubledger();
            $type          = "Customers";
        } else if ($subledger_type == 'V') {
            $data          = $modelAccSubledger->saveVendorSubledger();
            $type          = "Suppliers";
        } else if ($subledger_type == 'E') {
            $data          = $modelAccSubledger->saveEmployeeSubledger();
            $type          = "Employee";
        } else if ($subledger_type == 'AG') {
            $data          = $modelAccSubledger->saveAgentSubledger();
            $type          = "Agent";
        }
        else {
            $data          = 'failed';
            $type          = "";
        }
        echo json_encode(array('status' => $data, 'subledger_type' => $type));
    }
    //end


    // -----------------------------------------------------------------------------------------------------------
    //  Get Subledger list based on customer / vendor
    //------------------------------------------------------------------------------------------------------------

    public function actionGetSubledgerlist()
    {

        $term     = trim($_GET['term']);
        $ledger   = (int)$_GET['ledger'];
        $override = $_GET['override'] == 'true' ? true : false;
        $type     = (int) $_GET['type'];
        $response = array();
        if ($term != '' && ($ledger > 0 || $override)) {
            $legderModel = AccLedger::model()->findBypk($ledger);
            $sub_types   = $override ? $type : $legderModel->subledger_types;
            if ($sub_types != '') {
                $subledgers = AccSubledger::model()->findAll(array('select' => 'subledger_name, subledger_name, id', 'condition' => '( subledger_name LIKE "%' . $term . '%" OR subledger_name LIKE "%' . $term . '%" ) AND subledger_type IN (' . $sub_types . ') AND subledger_name NOT  LIKE "%- CRM%"', 'limit' => 10));
                foreach ($subledgers as $i => $each) {
                    $ledgers = Yii::app()->db->createCommand("select SUM(I.amount) AS amount from {{acc_voucher_items}} AS I 
                    LEFT JOIN {{acc_voucher}} AS H ON I.acc_voucher_id=H.id where H.is_posted='Y' AND I.ledger_id=" . $ledger . " 
                    AND I.subledger_id=" . $each['id'])->queryScalar();
                    $response[$i]['label'] = $each['subledger_name'] . ' : ' . $each['subledger_name'] . ' : AED ' . (float)$ledgers;
                    $response[$i]['value'] = $each['id'];
                }
            }
        }

        echo json_encode($response);
    }

    // -----------------------------------------------------------------------------------------------------------
    //  Get all 'type and select' sub ledgers
    //frm SubledgerDetailReport
    //------------------------------------------------------------------------------------------------------------

    public function actionSubledgerlist_all()
    {
        $term     = trim($_GET['term']);
        $response = array();

        if ($term != '') {
            $modelAccSubledger = new AccSubledger();
            $subledgers        = $modelAccSubledger->findAll(array('condition' => 'subledger_name LIKE "%' . $term . '%" AND subledger_name NOT  LIKE "%- CRM%"', 'limit' => 200));
            foreach ($subledgers as $i => $each) {
                $response[$i]['label'] = $each->subledger_name;
                $response[$i]['value'] = $each->id;
            }
        }
        echo json_encode($response);
    }


    public function actionDeleteSublegder()
    {
        $id = $_POST['id'];
        $modelAccVoucherItems = new AccVoucherItems;
        if ((int)$id > 0) {
            if ($modelAccVoucherItems->no_of_subledger_entries($id) == 0) {
                $modelAccSubledger = new AccSubledger();
                $modelAccSubledger      = $modelAccSubledger->findByPk($id);
                $modelAccSubledger->deleteByPk($id);
                $jsonData['status']    = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $jsonData[]            = 'This subledger exists in the vouchers';
                echo CJSON::encode($jsonData);
            }
        } else {
            $jsonData[]            = 'failed';
            echo CJSON::encode($jsonData);
        }
    }
}
