<?php

/*
"Used for direct insertion of data from finance into accounts."

 */
class SettingsController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'index',
                    'FindMisMachVouchers',
                    'PostUnpostVouchers',
                    'TruncateTables',
                    'ResetVoucherTypeLastNumber',
                    'FindDuplicateVouchers',
                    'TruncateVouchers',
                    'TruncateSubledgers',
                    'CheckPosting',
                    'Checkinvoiceposting',
                    'Checkcreditnoteposting',
                    'Loadsettingserrormodel',
                    'Checkpurchaseinvoice',
                    'Checkdebitnote',
                    'Checkgoodsissue',
                    'Checkgoodsreceipt',
                    'Checkdeliverynote',
                    'ImportSI',
                    'ExecuteAccountViews',
                    'Executevoucherindexviews',
                    'ExecuteglReportChild',
                    'ExecuteVatReportViews',
                    'CheckmodelExistence',
                    'CheckTableExistence',
                    'Generalsettings'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionindex()
    {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && Yii::app()->user->havePermissionOn['accounts_menu_view'] 
        )
    ) {
        $this->render('index_settings');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
    }

    public function actionFindMisMachVouchers()
    {

        $this->render('mismach_vouchers_list');
    }

    public function actionTruncateTables()
    {
        $this->render('truncate_tables_list');
    }
    public function actionFindDuplicateVouchers()
    {
        $this->render('find_duplicate_vouchers_list');
    }
    public function actionCheckPosting()
    {
        $this->render('check_posting_list');
    }



    public function actionResetVoucherTypeLastNumber()
    {
        $sql = "UPDATE {{acc_voucher_type}} SET last_number = start_number";
        $command = Yii::app()->db->createCommand($sql);
        $result = $command->execute();
        if ($result) {
            $jsonData = array('status' => 'success');
        } else {
            $jsonData = array('message' => 'Already Reseted voucher type last number');
        }
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }


    public function actionTruncateVouchers()
    {
        $transaction = Yii::app()->db->beginTransaction();

        try {
            // Truncate commands
            Yii::app()->db->createCommand("TRUNCATE `erp_acc_allocation`")->execute();
            Yii::app()->db->createCommand("TRUNCATE `erp_acc_allocation_items`")->execute();
            Yii::app()->db->createCommand("TRUNCATE `erp_acc_voucher`")->execute();
            Yii::app()->db->createCommand("TRUNCATE `erp_acc_voucher_items`")->execute();

            // Update command
            Yii::app()->db->createCommand("UPDATE {{invoice}} SET `posted` = 'N'")->execute();
            Yii::app()->db->createCommand("UPDATE {{creditnote}} SET `posted` = 'N'")->execute();
            Yii::app()->db->createCommand("UPDATE {{purchasinginvoice}} SET `posted` = 'N'")->execute();
            Yii::app()->db->createCommand("UPDATE {{purchasing_debit_note}} SET `posted` = 'N'")->execute();
            Yii::app()->db->createCommand("UPDATE {{inventory_goods_issue}} SET `posted` = 'N'")->execute();
            Yii::app()->db->createCommand("UPDATE {{inventory_goods_receipt}} SET `posted` = 'N'")->execute();

            // Commit transaction
            $transaction->commit();

            // Success response
            $jsonData = array('status' => 'success');
        } catch (Exception $e) {
            // Rollback on error
            $transaction->rollback();

            // Error response
            $jsonData = array('message' => 'Failed Truncate and Update: ' . $e->getMessage());
        }

        // Send JSON response
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    public function actionTruncateSubledgers()
    {
        $transaction = Yii::app()->db->beginTransaction();

        try {
            // Truncate commands
            Yii::app()->db->createCommand("TRUNCATE `erp_acc_subledger`")->execute();
            // Commit transaction
            $transaction->commit();
            // Success response
            $jsonData = array('status' => 'success');
        } catch (Exception $e) {
            // Rollback on error
            $transaction->rollback();

            // Error response
            $jsonData = array('message' => 'Failed Truncate and Update: ' . $e->getMessage());
        }

        // Send JSON response
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }

    public function actionCheckinvoicepostingold()
    {
        // Function to check for missing columns
        function checkMissingColumnsx($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        // -----------------------------------------------
        // Define the expected column names
        $array_invoice_header = [
            'id',
            'file_id',
            'invoice_date',
            'invoice_no',
            'customer_id',
            'lead_owner_id',
            'sales_group_id',
            'currency_id',
            'exchange_rate',
            'total_tax_amount',
            'total_discount_amount',
            'round_off_amount',
            'grand_total',
            'invoice_type',
            'order_id',
            'delivery_ids',
            'is_direct_invoice',
            'payment_terms_id',
            'project_id',
            'paymentmode_id',
            'received_amount',
        ];

        $array_invoice_item = [
            'product_id',
            'unit_id',
            'rate',
            'quantity',
            'amount',
            'tax_vat_amount',
            'deduction_amount',
            'net_amount',
            'cost_rate',
            'deduction_percentage'
        ];
        // -----------------------------------------------

        // Check for missing columns in header
        $missing_columns_header = checkMissingColumnsx('erp_invoice', $array_invoice_header);

        // Check for missing columns in item
        $missing_columns_item = checkMissingColumnsx('erp_invoice_item', $array_invoice_item);

        // Prepare the response
        if (empty($missing_columns_header) && empty($missing_columns_item)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                $messages[] = 'Header Missing columns: ' . implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                $messages[] = 'Item Missing columns: ' . implode('<br>', $missing_columns_item);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }
        // Return the JSON response
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    public function actionLoadsettingserrormodel()
    {
        $errorMessage = Yii::app()->getRequest()->getParam('errorMessage'); // Retrieve errorMessage from request parameters

        // Example: Render error_popup.php with errorMessage passed to it
        $this->render('error_popup', array(
            'errorMessage' => $errorMessage,
        ));
    }
    // -------------------------------invoice-------------------------------------------------

    public function actionCheckinvoiceposting()
    {
        // Function to check for missing columns
        function checkMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        // Define the expected column names
        $array_invoice_header = [
            'id',
            'file_id',
            'invoice_date',
            'invoice_no',
            'customer_id',
            'lead_owner_id',
            'sales_group_id',
            'currency_id',
            'exchange_rate',
            'total_tax_amount',
            'total_discount_amount',
            'round_off_amount',
            'grand_total',
            'invoice_type',
            'order_id',
            'delivery_ids',
            'is_direct_invoice',
            'payment_terms_id',
            'project_id',
            'paymentmode_id',
            'received_amount',
            'posted',
            'invoice_status',

        ];

        $array_invoice_item = [
            'product_id',
            'unit_id',
            'rate',
            'quantity',
            'amount',
            'tax_vat_amount',
            'deduction_amount',
            'net_amount',
            'cost_rate',
            'deduction_percentage',
        ];

        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];
        
        
        $array_cutomers    = ['ledger_id', 'id'];
        
        $array_store    = ['ledger_id'];

        $header_table = '{{invoice}}';
        $item_table = '{{invoice_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";
        $header_customer = '{{customer}}';
        $header_store = '{{store}}';


        // Check for missing columns in header
        $missing_columns_header = checkMissingColumns($header_table, $array_invoice_header);

        // Check for missing columns in item
        $missing_columns_item = checkMissingColumns($item_table, $array_invoice_item);

        $missing_columns_user = checkMissingColumns($header_user, $array_users);
        
        $missing_columns_customer = checkMissingColumns($header_customer, $array_cutomers);
        
        $missing_columns_store = checkMissingColumns($header_store, $array_store);


        // Prepare the response
        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)&& empty($missing_columns_customer)&& empty($missing_columns_store)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                //  $messages[] = 'Header Missing columns: ' . implode('<br>', $missing_columns_header);
                $messages[] = 'Invoice Header Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                //   $messages[] = 'Item Missing columns: ' . implode('<br>', $missing_columns_item);
                $messages[] = 'Invoice Item Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'User Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_user);
            }
            if (!empty($missing_columns_customer)) {
                $messages[] = 'Customer Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_customer);
            }
            if (!empty($missing_columns_store)) {
                $messages[] = 'Store Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_store);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }

        // Return the JSON response
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    // -------------------------------creditnote-------------------------------------------------


    public function actionCheckcreditnoteposting()
    {
        // Function to check for missing columns
        function checkCreditnoteMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        // Define the expected column names
        $array_header = [
            'id',
            'file_id',
            'credited_date',
            'invoice_id',
            'customer_id',
            'paymentmode_id',
            'paid_amount',
            'credited_amount',
            'currency',
            'exchange_rate',
            'total_tax_amount',
            'tax_type',
            'crm_user_id',
            'posted',
            'outlet_id',
            'warehouse_id'
        ];

        $array_item = [
            'product_id',
            'unit',
            'rate',
            'quantity',
            'rate',
            'net_amount',
            'tax_vat_amount'
        ];

        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];
         $array_cutomers    = ['ledger_id', 'id'];
        
        $array_store    = ['ledger_id'];

        $header_table = '{{creditnote}}';
        $item_table = '{{creditnote_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";
         $header_customer = '{{customer}}';
        $header_store = '{{store}}';


        // Check for missing columns in header
        $missing_columns_header = checkCreditnoteMissingColumns($header_table, $array_header);

        // Check for missing columns in item
        $missing_columns_item = checkCreditnoteMissingColumns($item_table, $array_item);
        $missing_columns_user = checkCreditnoteMissingColumns($header_user, $array_users);
        $missing_columns_customer = checkCreditnoteMissingColumns($header_customer, $array_cutomers);
        $missing_columns_store = checkCreditnoteMissingColumns($header_store, $array_store);

        // Prepare the response
        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)&& empty($missing_columns_customer)&& empty($missing_columns_store)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                //  $messages[] = 'Header Missing columns: ' . implode('<br>', $missing_columns_header);
                $messages[] = 'Header Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                //   $messages[] = 'Item Missing columns: ' . implode('<br>', $missing_columns_item);
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_user);
            }
             if (!empty($missing_columns_customer)) {
                $messages[] = 'Customer Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_customer);
            }
            if (!empty($missing_columns_store)) {
                $messages[] = 'Store Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_store);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }

        // Return the JSON response
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }

    // -------------------------------purchaseinvoice-------------------------------------------------

    public function actionCheckpurchaseinvoice()
    {
        function checkpurchaseinvoiceMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        $array_header = [
            'invoice_date',
            'invoice_no',
            'id',
            'grand_total',
            'currency',
            'exchange_rate',
            'total_tax_amount',
            'file_id',
            'total_discount',
            'round_off_amount',
            'tax_type',
            'is_direct_invoice',
            'vendor_id',
            'payment_terms',
            'crm_user_id',
            'project_id',
            'posted'
        ];

        $array_item = [
            'product_id',
            'unit',
            'quantity',
            'net_amount',
            'deduction_amount',
            'rate',
            'tax_amount',
            'deduction_percentage'
        ];
        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];
        
        $array_vendor    = ['ledger_id', 'id'];
        
        $array_store    = ['ledger_id'];
        

        $header_table = '{{purchasinginvoice}}';
        $item_table = '{{purchasinginvoice_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";
        $header_vendor = '{{vendor}}';
        $header_store = '{{store}}';

        $missing_columns_header = checkpurchaseinvoiceMissingColumns($header_table, $array_header);
        $missing_columns_item = checkpurchaseinvoiceMissingColumns($item_table, $array_item);
        $missing_columns_user = checkpurchaseinvoiceMissingColumns($header_user, $array_users);
        $missing_columns_vendor = checkpurchaseinvoiceMissingColumns($header_vendor, $array_vendor);
        $missing_columns_store = checkpurchaseinvoiceMissingColumns($header_store, $array_store);


        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)&& empty($missing_columns_vendor)&& empty($missing_columns_store)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                $messages[] = 'Header Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_user);
            }
             if (!empty($missing_columns_vendor)) {
                $messages[] = 'Vendor Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_vendor);
            }
            if (!empty($missing_columns_store)) {
                $messages[] = 'Store Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_store);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    // -------------------------------debitnote-------------------------------------------------
    public function actionCheckdebitnote()
    {
        function checkdebitnoteMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        $array_header = [
            'debited_date',
            'purchasing_invoice_id',
            'file_id',
            'debited_amount',
            'currency',
            'exchange_rate',
            'total_tax_amount',
            'tax_type',
            'vendor_id',
            'crm_user_id',
            'posted',
            'invoice_type'
        ];

        $array_item = [
            'product_id',
            'unit',
            'purchased_quantity',
            'net_amount',
            'tax_vat_amount',
            'rate',
        ];
        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];
        $array_vendor    = ['ledger_id', 'id'];
        $array_store    = ['ledger_id'];

        $header_table = '{{purchasing_debit_note}}';
        $item_table = '{{purchasing_debit_note_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";
        $header_vendor = '{{vendor}}';
        $header_store = '{{store}}';

        $missing_columns_header = checkdebitnoteMissingColumns($header_table, $array_header);
        $missing_columns_item = checkdebitnoteMissingColumns($item_table, $array_item);
        $missing_columns_user = checkdebitnoteMissingColumns($header_user, $array_users);
        $missing_columns_vendor = checkdebitnoteMissingColumns($header_vendor, $array_vendor);
        $missing_columns_store = checkdebitnoteMissingColumns($header_store, $array_store);

        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)&& empty($missing_columns_vendor)&& empty($missing_columns_store)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                $messages[] = 'Header Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_user);
            }
             if (!empty($missing_columns_vendor)) {
                $messages[] = 'Vendor Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_vendor);
            }
            if (!empty($missing_columns_store)) {
                $messages[] = 'Store Missing columns:-';
                $messages[] = implode('<br>', $missing_columns_store);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    // -------------------------------Checkgoodsissue-------------------------------------------------
    public function actionCheckgoodsissue()
    {
        function checkgoodsissueMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        $array_header = [
            'goods_issue_date',
            'reference',
            'file_id',
            'id',
            'customer_id',
            'created_by',
            'posted',
            'issue_type',
            'project_id'
        ];

        $array_item = [
            'product_id',
            'unit',
            'picked_qty',
            'rate',
        ];
        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];

        $header_table = '{{inventory_goods_issue}}';
        $item_table = '{{inventory_goods_issue_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";

        $missing_columns_header = checkgoodsissueMissingColumns($header_table, $array_header);
        $missing_columns_item = checkgoodsissueMissingColumns($item_table, $array_item);
        $missing_columns_user = checkgoodsissueMissingColumns($header_user, $array_users);


        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                $messages[] = 'Header Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_user);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    // -------------------------------Checkgoodsreceipt-------------------------------------------------
    public function actionCheckgoodsreceipt()
    {
        function checkgoodsreceiptMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        $array_header = [
            'goods_receipt_date',
            'reference',
            'file_id',
            'id',
            'posted',
            'created_by',
            'receipt_type',
            'customer_id'
        ];

        $array_item = ['product_id', 'unit', 'picked_qty', 'rate'];

        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];

        $header_table = '{{inventory_goods_receipt}}';
        $item_table = '{{inventory_goods_receipt_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";

        $missing_columns_header = checkgoodsreceiptMissingColumns($header_table, $array_header);
        $missing_columns_item = checkgoodsreceiptMissingColumns($item_table, $array_item);
        $missing_columns_user = checkgoodsreceiptMissingColumns($header_user, $array_users);

        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                $messages[] = 'Header Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_user);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    // -------------------------------Checkdeliverynote-------------------------------------------------
    public function actionCheckdeliverynote()
    {
        function checkdeliverynoteMissingColumns($tableName, $expectedColumns)
        {
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            $actualColumns = array_keys($tableSchema->columns);
            return array_diff($expectedColumns, $actualColumns);
        }

        $array_header = [
            'status',
            'posted',
            'order_id',
            'id',
            'lead_owner_id',
            'file_id',
            'customer_id',
            'delivery_date'
        ];

        $array_item = ['product_id', 'quantity', 'unit_id', 'picked_qty', 'delivery_note_id'];

        $array_users    = ['connected_employee_id', 'company_id', 'branch_id', 'available_warehouses'];

        $header_table = '{{delivery_note}}';
        $item_table = '{{delivery_item}}';
        $company_db_name = MasCompany::MainDB;
        $header_user = "$company_db_name.{{user}}";

        $missing_columns_header = checkdeliverynoteMissingColumns($header_table, $array_header);
        $missing_columns_item = checkdeliverynoteMissingColumns($item_table, $array_item);
        $missing_columns_user = checkdeliverynoteMissingColumns($header_user, $array_users);

        if (empty($missing_columns_header) && empty($missing_columns_item) && empty($missing_columns_user)) {
            $jsonData = array('status' => 'success');
        } else {
            $messages = [];
            if (!empty($missing_columns_header)) {
                $messages[] = 'Header Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_header);
            }
            if (!empty($missing_columns_item)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_item);
            }
            if (!empty($missing_columns_user)) {
                $messages[] = 'Item Missing columns:- ';
                $messages[] = implode('<br>', $missing_columns_user);
            }
            $jsonData = array(
                'message' => implode('<br>', $messages)
            );
        }
        header('Content-Type: application/json');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }
    // -------------------------------------------------------

    public function actionPostUnpostVouchers()
    {
        $this->render('post_unpost_vouchers_list');
    }




    public function actionImportSI()
    {
        $sql = "SELECT id FROM {{invoice}} WHERE posted='N' AND  invoice_status!='C'  LIMIT 2";
        $voucher_list = Yii::app()->db->createCommand($sql)->queryAll();
        $arrayq = [];
        foreach ($voucher_list as $each) {
            array_push($arrayq, $each['id']);
        }


        Yii::import('application.modules.accounts.controllers.PostingController');

        PostingController::addpostSales($arrayq, '');
        if (!empty($arrayq)) {
            foreach ($arrayq as $each_invoice_id) {
                //PostingController::addPostReceipt_frm_invoice($each_invoice_id);
                //PostingController::allocateInvoiceVoucherwithreceipt($each_invoice_id);


            }
        } else {
            // echo 'All Invoice Posted To Accounts';
        }

        echo 'Success';
    }


    public function actionExecuteAccountViews()
    {

        $this->render('execute_account_views');
    }


    public function actionExecutevoucherindexviews()
    {

        $sql1 = "CREATE  OR REPLACE  VIEW view_acc_ledgers_new AS SELECT
                `VI`.`acc_voucher_id` AS `acc_voucher_id`,
                GROUP_CONCAT(
                    DISTINCT `VI`.`ledger_id` SEPARATOR ','
                ) AS ledger_id,
                GROUP_CONCAT(
                    DISTINCT `VI`.`subledger_id` SEPARATOR ','
                ) AS subledger_id,
                GROUP_CONCAT(
                    DISTINCT `L`.`ledger_acc_name` SEPARATOR ','
                ) AS `ledger_name`,
                GROUP_CONCAT(
                    DISTINCT `S`.`subledger_name` SEPARATOR ','
                ) AS `subledger_name`
            FROM
                erp_acc_voucher_items VI
            LEFT JOIN erp_acc_subledger S ON
                S.id = VI.subledger_id
            LEFT JOIN erp_acc_ledger L ON
                L.id = VI.ledger_id
            GROUP BY
            VI.acc_voucher_id";


        $sql = "CREATE OR REPLACE  VIEW view_account_voucher_items_new AS 
            SELECT
                V.id AS id,
                V.voucher_no AS voucher_no,
                L.id AS ledger_id,
                L.ledger_acc_no AS ledger_acc_no,
                L.ledger_acc_name AS ledger_acc_name,
                L.level AS level,
                L.ledger_main_acc AS ledger_main_acc,
                L.ledger_parent_acc AS ledger_parent_acc,
                L.root AS root,
                L.is_parent AS is_parent,
                VI.subledger_id AS subledger_id,
                SL.subledger_name AS subledger_name,
                V.voucher_date AS voucher_date,
                V.is_posted AS is_posted,
                V.reference_no AS reference_no,
                VI.narration AS narration,
                VI.outlet_id AS outlet_id,
                V.cheque_date AS cheque_date,
                V.cheque_no AS cheque_no,
                VI.warehouse_id AS warehouse_id,
                VI.amount AS amount,
                VI.year AS year,
                VI.company_id AS company_id,
                VI.branch_id AS branch_id,
                VI.salegroup_id AS salegroup_id,
                VI.brand_id AS brand_id,
                VI.costcenter_id AS costcenter_id,
                VI.generic_id AS generic_id,
                VI.department_id AS department_id,
                VI.project_id AS project_id,
                VI.allocated_amount AS allocated_amount,
                VI.employee_id AS employee_id,
                CASE WHEN VI.amount > 0 THEN VI.amount ELSE 0 END AS debit,
                CASE WHEN VI.amount <= 0 THEN VI.amount ELSE 0 END AS credit
            FROM {{acc_voucher_items}} VI
            LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
            LEFT JOIN {{acc_ledger}} L ON VI.ledger_id = L.id
            LEFT JOIN erp_acc_subledger SL ON SL.id = VI.subledger_id
            ORDER BY L.ledger_acc_no";

        try {

            $command1 = Yii::app()->db->createCommand($sql1);
            $command1->execute();
            $command = Yii::app()->db->createCommand($sql);
            $command->execute();
            echo CJSON::encode(['status' => 'success']); // JSON response for success
        } catch (Exception $e) {
            echo CJSON::encode(['status' => 'error', 'message' => $e->getMessage()]); // JSON response for error
        }
    }

    public function actionExecuteglReportChild()
    {

        $sql = "CREATE OR REPLACE VIEW `view_acc_gl_report_parent` AS SELECT
            `t`.`id` AS `id`,
            `t`.`acc_voucher_id` AS `acc_voucher_id`,
            `parent`.`voucher_no` AS `voucher_no`,
            `W`.`warehouse_name` AS `warehouse_name`,
            `W`.`id` AS `warehouse_id`,
            `t`.`exchange_rate` AS `exchange_rate`,
            `t`.`currency_id` AS `currency_id`,
            `t`.`amount` AS `amount`,
            `t`.`subledger_id` AS `subledger_id`,
            `t`.`ledger_id` AS `ledger_id`,
            `S`.`subledger_name` AS `subledger_name`,
            `L`.`ledger_acc_name` AS `ledger_acc_name`,
            (
                CASE WHEN(
                    (`t`.`amount` < 0) AND(`t`.`subledger_id` > 0)
                ) THEN `S`.`subledger_name` ELSE `L`.`ledger_acc_name`
                END
            ) AS `particular1`,
            (
                CASE WHEN(
                    (`t`.`amount` > 0) AND(`t`.`subledger_id` > 0)
                ) THEN `S`.`subledger_name` ELSE `L`.`ledger_acc_name`
            END
            ) AS `particular2`,
            `parent`.`voucher_date` AS `voucher_date`,
            (
                CASE WHEN(`parent`.`transaction_id` > 0) THEN `parent`.`transaction_id` ELSE 0
            END
            ) AS `transaction_id`,
            `t`.`narration` AS `narration_main`,
            CONCAT(
                `t`.`narration`,
                '-',
                `W`.`warehouse_name`
            ) AS `narration`,
            `VT`.`code` AS `code`,
            (
                CASE WHEN(`t`.`amount` > 0) THEN(
                    ABS(`t`.`amount`) * `t`.`exchange_rate`
                ) ELSE 0
            END
            ) AS `debit`,
            (
                CASE WHEN(`t`.`amount` <= 0) THEN(
                    ABS(`t`.`amount`) * `t`.`exchange_rate`
                ) ELSE 0
            END
            ) AS `credit`
            FROM
                `erp_acc_voucher_items` `t`
            LEFT JOIN `erp_acc_voucher` `parent` ON
                `parent`.`id` = `t`.`acc_voucher_id`
            LEFT JOIN `erp_acc_subledger` `S` ON
                `S`.`id` = `t`.`subledger_id`
            LEFT JOIN `erp_acc_ledger` `L` ON
                `L`.`id` = `t`.`ledger_id`
            LEFT JOIN `erp_acc_voucher_type` `VT` ON
                `VT`.`id` = `parent`.`voucher_type`
            LEFT JOIN `erp_mas_inv_warehouse` `W` ON
                `t`.`warehouse_id` = `W`.`id`
            WHERE
                (`t`.`amount` <> 0) AND(`parent`.`is_posted` = 'Y')
            ORDER BY
                `parent`.`voucher_date`";

        try {
            $command = Yii::app()->db->createCommand($sql);
            $command->execute();
            echo CJSON::encode(['status' => 'success']); // JSON response for success
        } catch (Exception $e) {
            echo CJSON::encode(['status' => 'error', 'message' => $e->getMessage()]); // JSON response for error
        }
    }


    public function actionExecuteVatReportViews()
    {

        $sql1 = "CREATE OR REPLACE VIEW view_acc_sales_report AS 
                SELECT
                    I.invoice_id AS invoice_id,
                    H.file_id AS file_id,
                    H.order_id AS order_id,
                    H.invoice_no AS invoice_no,
                    H.customer_id AS customer_id,
                    H.created_by AS created_by,
                    H.warehouse_id AS warehouse_id,
                    W.warehouse_name AS warehouse_name,
                    H.grand_total AS grand_total,
                    H.total_tax_amount AS total_tax_amount,
                    H.net_amount AS net_amount,
                    H.posted AS posted,
                    0 AS received_card_amount,
                    0 AS received_cash_amount,
                    0 AS commission_percent,
                    0 AS commission_amount,
                    H.currency_id AS currency,
                    H.sales_group_id AS sales_group,
                    H.invoice_date AS invoice_date,
                    H.invoice_status AS invoice_status,
                    H.isActive AS isActive,
                    CU.customer_name AS customer_name,
                    SUM(I.quantity) AS item_quantity,
                    SUM(I.amount) AS item_amount,
                    SUM(I.tax_vat_amount) AS item_tax_vat_amount,
                    SUM(I.deduction_amount) AS item_deduction_amount,
                    SUM(I.net_amount) AS item_net_amount,
                    SUM(I.cost_rate * I.quantity) AS item_cost_amount,
                    CONCAT(U.first_name, ' ', U.last_name) AS user_name,
                    0 AS outlet_id,
                    '' AS outlet_name
                FROM
                    erp_invoice H
                    LEFT JOIN erp_invoice_item I ON H.id = I.invoice_id
                    LEFT JOIN erp_mas_inv_warehouse W ON H.warehouse_id = W.id
                    LEFT JOIN erpbluesky_erp_bluesky_main.erp_user U ON H.created_by = U.id
                    LEFT JOIN erp_customer CU ON H.customer_id = CU.id
                WHERE
                    H.invoice_status <> 'C'
                GROUP BY
                    I.invoice_id";


        $sql = "CREATE OR REPLACE VIEW view_acc_creditnote_report AS SELECT
                CI.creditnote_id AS creditnote_id,
                C.file_id AS file_id,
                C.creditnote_no AS creditnote_no,
                C.posted AS posted,
                C.invoice_id AS invoice_id,
                INV.invoice_no AS invoice_no,
                INV.exchange_rate AS exchange_rate,
                INV.invoice_type AS invoice_type,
                C.customer_id AS customer_id,
                C.created_by AS created_by,
                C.credited_amount AS credited_amount,
                C.total_tax_amount AS total_tax_amount,
                0 AS paid_card_amount,
                0 AS paid_cash_amount,
                '' AS payment_type,
                C.paid_amount AS paid_amount,
                C.commision_percentage AS commision_percentage,
                C.commision_amount AS commision_amount,
                C.credited_date AS credited_date,
                C.isActive AS isActive,
                SUM(CI.returned_quantity) AS item_returned_quantity,
                SUM(CI.rate * CI.returned_quantity) AS item_rate,
                SUM(CI.net_amount) AS item_net_amount,
                SUM(CI.tax_vat_percentage) AS item_tax_vat_percentage,
                SUM(CI.tax_vat_amount) AS item_tax_vat_amount,
                C.warehouse_id AS warehouse_id,
                W.warehouse_name AS warehouse_name,
                CU.customer_name AS customer_name,
                CONCAT(U.first_name, ' ', U.last_name) AS user_name,
                0 AS outlet_id,
                '' AS outlet_name
            FROM
                erp_creditnote C
            LEFT JOIN erp_creditnote_item CI ON
                C.id = CI.creditnote_id
            LEFT JOIN erp_mas_inv_warehouse W ON
                C.warehouse_id = W.id
            LEFT JOIN erp_invoice INV ON C.invoice_id = INV.id
            LEFT JOIN erpbluesky_erp_bluesky_main.erp_user U
            ON
                C.created_by = U.id
            LEFT JOIN erp_customer CU ON
                C.customer_id = CU.id
            WHERE
                C.isActive = 'Y' AND C.is_updated_store = 'Y' AND C.invoice_id > 0
            GROUP BY
                CI.creditnote_id";

        try {

            $command1 = Yii::app()->db->createCommand($sql1);
            $command1->execute();
            $command = Yii::app()->db->createCommand($sql);
            $command->execute();
            echo CJSON::encode(['status' => 'success']); // JSON response for success
        } catch (Exception $e) {
            echo CJSON::encode(['status' => 'error', 'message' => $e->getMessage()]); // JSON response for error
        }
    }

    public function actionCheckmodelExistence()
    {
        $models = [
            'MasInventoryWarehouse',
            'MasOutlet',
            'MasProjectClassification',
            'FmPlannedMaintenance',
            'TicketHeader',
            'MasPaymentTerm',
            'MasDepartment',
            'Employee',
            'WsProject',
            'User',
            'MasSalesGroup',
            'MasCompany',
            'Store',
            'ProductClass',
            'MasGeneric',
            'MasInvoiceType',
            'MasCurrency',
            'MasInventoryStockAdjustmentType',
            'Invoice',
            'InvoiceItem',
            'PurchasingInvoice',
            'PurchasingInvoiceItem',
            'InventoryGoodsIssue',
            'InventoryGoodsIssueItem',
            'InventoryGoodsReceipt',
            'InventoryGoodsReceiptItem',
            'Creditnote',
            'CreditnoteItem',
            'Purchasingdebitnote',
            'PurchasingdebitnoteItem',
            'DeliveryNote',
            'DeliveryNoteItem', 
            
        ];

        $arrayfailedmodel = $arraysuccessmodel = [];

        foreach ($models as $model) {
            if (class_exists($model)) {
                $arraysuccessmodel[] = $model;
            } else {
                $arrayfailedmodel[] = $model;
            }
        }

        // Return JSON response
        if (!empty($arrayfailedmodel)) {
            echo CJSON::encode([
                'status' => 'failed',
                'failedModels' => $arrayfailedmodel
            ]);
        } else {
            echo CJSON::encode([
                'status' => 'success',
                'message' => 'All models exist!'
            ]);
        }
        Yii::app()->end();
    }


    public function actionCheckTableExistence()
    {
        $models = [
            'MasInventoryWarehouse',
            'MasOutlet',
            'MasProjectClassification',
            'FmPlannedMaintenance',
            'TicketHeader',
            'MasPaymentTerm',
            'MasDepartment',
            'Employee',
            'WsProject',
            'User',
            'MasSalesGroup',
            'MasCompany',
            'Store',
            'ProductClass',
            'MasGeneric',
            'MasInvoiceType',
            'MasCurrency',
            'MasInventoryStockAdjustmentType',
            'Invoice',
            'InvoiceItem',
            'PurchasingInvoice',
            'PurchasingInvoiceItem',
            'InventoryGoodsIssue',
            'InventoryGoodsIssueItem',
            'InventoryGoodsReceipt',
            'InventoryGoodsReceiptItem',
            'Creditnote',
            'CreditnoteItem',
            'Purchasingdebitnote',
            'PurchasingdebitnoteItem',
            'DeliveryNote',
            'DeliveryNoteItem'
        ];

        $arrayfailedtables = $arraysuccesstables = [];

        foreach ($models as $model) {
            if (class_exists($model)) {
                try {
                    // Create a new instance of the current model
                    $modelInstance = new $model();
                    // Get the table name from the model
                    $tableName = $modelInstance->tableName();

                    // Check if the table exists in the database
                    if ($this->checkTableExists($tableName)) {
                        $arraysuccesstables[] = $tableName; // Add to success array if table exists
                    } else {
                        $arrayfailedtables[] = $tableName;  // Add to failure array if table does not exist
                    }
                } catch (Exception $e) {
                    // Catch any exceptions (like missing tables) and add to the failed array
                    $arrayfailedtables[] = $model;
                }
            }
        }

        // Determine status based on success or failure
        $status = empty($arrayfailedtables) ? 'success' : 'failed';

        // Prepare the response
        $response = [
            'status' => $status,  // Include a status key
            'message' => $status == 'success' ? 'All tables exist.' : 'Some tables are missing.',
            'tableStatus' => [
                'success' => $arraysuccesstables,
                'failed' => $arrayfailedtables,
            ]
        ];

        // Return the response in JSON format
        echo CJSON::encode($response);
        Yii::app()->end();
    }

    // Function to check if the table exists in the database
    public function checkTableExists($tableName)
    {
        try {
            // Attempt to retrieve the table schema
            $tableSchema = Yii::app()->db->schema->getTable($tableName);
            return ($tableSchema !== null);  // Return true if the table exists, otherwise false
        } catch (Exception $e) {
            // If an exception occurs (table not found), return false
            return false;
        }
    }
    
     public function actionGeneralsettings()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('general_settings');
    }
}
