<?php

class SecuritychequeController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetChequeList','Create','SaveDetails','ReturnCheque','Savereturndetail','deletecheque','Report','viewreport'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
    
    
 
//    public $modelMasCurrency; 

//     public function init()
//     {
//         parent::init();
//         $this->modelMasCurrency = new MasCurrency();
//     }
    
    

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetChequeList() {
        $model = new SecurityCheque();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'transaction_type',
            2 => 'transaction_date',
            3 => 'cheque_payee',
            4 => 'bank_name',
            5 => 'cheque_no',
            6 => 'cheque_date',
            7 => 'cheque_amount',
            8 => ''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (bank_name LIKE '%" . $searchString . "%' OR cheque_no LIKE '%" . $searchString . "%' OR cheque_payee LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            if (isset(Yii::app()->user->havePermissionOn['acc_securitycheque_add']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'accounts/securitycheque/create&id=' . $row['id'] . '\',\'Edit Cheque Details \',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';
            }
            if ((isset(Yii::app()->user->havePermissionOn['acc_securitycheque_add']) || Yii::app()->user->authorised_user == 1) && $row['transaction_return_by']==0) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Return" onclick="loadPopupModal(\'accounts/securitycheque/returncheque&id=' . $row['id'] . '\',\'Return Cheque \',\'lg\')"><i class="fa fa-reply"></i></button>&nbsp;';
            }
            if (isset(Yii::app()->user->havePermissionOn['acc_securitycheque_delete']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletecheque('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $type=array('I'=>'Issue','R'=>'Received');
            $transaction_date = $cheque_date="";
            if ($row['transaction_date'] != '' && $row['transaction_date'] != '0000-00-00') {
                $transaction_date = date("d/m/Y", strtotime($row->transaction_date));
            }
            if ($row['cheque_date'] != '' && $row['cheque_date'] != '0000-00-00') {
                $cheque_date = date("d/m/Y", strtotime($row->cheque_date));
            }
            $rowData[] = array($m, $type[$row['transaction_type']],$transaction_date, $row['cheque_payee'], $row['bank_name'], $row['cheque_no'],$cheque_date, $row['cheque_amount'], $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate(){
        $model=new SecurityCheque();  
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);       
        $this->renderPartial('create', array('model' => $model), false, true);
                                          
    }
    public function actionSaveDetails() {
        if (isset($_POST['SecurityCheque'])) {
            date_default_timezone_set("Asia/Dubai");
            $model = new SecurityCheque();
            if ((int) @$_POST['SecurityCheque']['id'] > 0) {                
                $model = SecurityCheque::model()->findByPK($_POST['SecurityCheque']['id']);
                $model->id = (int) $_POST['SecurityCheque']['id'];         
                $model->scenario = 'update';
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->scenario = 'add';
                $model->created_by= Yii::app()->user->id;
                $model->transaction_done_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['SecurityCheque'];
            $model->location = $_POST['SecurityCheque']['location'];
            $model->notes = $_POST['SecurityCheque']['notes'];
            if ($_POST['SecurityCheque']['transaction_date'] != '0000-00-00' && $_POST['SecurityCheque']['transaction_date'] != '') {
                $model->transaction_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['SecurityCheque']['transaction_date'])));
            }else{
                $model->transaction_date ='';
            }
            if ($_POST['SecurityCheque']['cheque_date'] != '0000-00-00' && $_POST['SecurityCheque']['cheque_date'] != '') {
                $model->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['SecurityCheque']['cheque_date'])));
            }else{
                $model->cheque_date ='';
            }
            if($model->validate()){
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData); 
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionReturnCheque(){
        $model=new SecurityCheque();  
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);       
        $this->renderPartial('return_cheque', array('model' => $model), false, true);
                                          
    }
    public function actionSavereturndetail() {
        if (isset($_POST['SecurityCheque'])) {
              $id =$_POST['SecurityCheque']['id'];  
              $transaction_return_date='';
              if ($_POST['SecurityCheque']['transaction_return_date'] != '0000-00-00' && $_POST['SecurityCheque']['transaction_return_date'] != '') {
                  $transaction_return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['SecurityCheque']['transaction_return_date'])));
              }
              SecurityCheque::model()->updateByPK($id, array('transaction_return_by'=>Yii::app()->user->id,'transaction_return_date' =>$transaction_return_date,'updated_by'=>Yii::app()->user->id,'updated_date_time'=> date('Y-m-d h:i:s'))); 
              $jsonData['status'] = 'success';
              echo CJSON::encode($jsonData);          
        }
    }
    public function actiondeletecheque(){
        $id = $_POST['id'];
        if($id>0){
            SecurityCheque::model()->deleteByPk($id); 
            $jsonData['status'] = 'success';
        }
        else{
             $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);     
    }
    public function actionReport() {
        $this->render('report');
    }
    public function actionviewreport() {
        $from=(int) Yii::app()->request->getParam('from');
        $type=Yii::app()->request->getParam('type');
        if($from==1 || $from==2){
            if($from==1){
                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
                $this->renderPartial('html_report', array('type' => $type), false, true);
            }else if($from==2){
                $filename = 'SecurityChequeDetails.xls';
                header("Content-type: application/vnd.ms-excel");
                header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                $this->renderPartial('excel_report', array('type' => $type), false, true);
                Yii::app()->end();
            }
        }else{
            throw new CHttpException(404, 'Page not found.');
        }
    }
}
