<?php

/*
 chart of accounts
 payment mode, Save
 date 18-11-2022
 author -Indhu
 main setup
 Tables    - acc_payment_mode
 models used   - AccPaymentMode

 */


class PaymentmodeController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'RemoveAccVoucherTypeDetails', 'GetMappingAttribute', 'CheckPaymentModeDetails'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    // public $modelMasCurrency;

    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }


    public function actionIndex()
    {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_payment_mode_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_payment_mode_menu_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
    }

    public function actionGetList()
    {
        $model  = new AccPaymentMode();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.code',
            1 => 't.ledger_id',
            2 => 't.id',
            3 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    = 't.id LIKE "%' . $searchString . '%" OR t.mode LIKE "%' . $searchString . '%"';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {

            $div      = '<div class="btn-wrap text-center">';
            // -----------------------------------------------------------------
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_payment_mode_edit"])) {

                $div     .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/paymentmode/Create&id=' . $eachItem['id'] . '\',\'Edit Payment Mode \',\'xl\')"><i class="fa fa-edit"></i></a>';
            }
            // -----------------------------------------------------------------

            $div     .= '</div>';
            $eachItemData[] = array(
                $eachItem['mode'],
                $eachItem->ledger->ledger_acc_name,
                $div,
                array('active' => $eachItem['isActive'])
            );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new AccPaymentMode();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model     = $model->findBypk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('paymentmode_form', array('model' => $model));
    }



    public function actionSave()
    {
        $model = new AccPaymentMode();
        $validate = true;
        $other = array();
        if (isset($_POST['AccPaymentMode'])) {
            $model->created_by           = Yii::app()->user->id;
            $model->created_datetime     = date('Y-m-d h:i:s');
            if ((int) @$_POST['AccPaymentMode']['id'] > 0) {
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id                      = (int) @$_POST['AccPaymentMode']['id'];
                $model                   = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes           = $_POST['AccPaymentMode'];
            $model->ledger_id           = $_POST['AccPaymentMode']['ledger_id'];
            $model->code           = trim($_POST['AccPaymentMode']['code']);;

            $validate                    = $model->validate();

            //to check  AccPaymentMode existence
            $condition = 'mode LIKE"%' . $_POST['AccPaymentMode']['mode'] . '%"';
            $sql = 'SELECT * FROM {{acc_payment_mode}}  WHERE ' . $condition . '';
            $modelsql = Yii::app()->db->createCommand($sql)->queryAll();

            if ($model->isNewrecord) {
                if (!empty($modelsql)) {
                    $validate = false;
                    $other[]  = 'Mode has already been taken';
                }
            } else {
                if (!empty($modelsql)) {
                    if (((int)$modelsql[0]['id'] !== (int)$_POST['AccPaymentMode']['id'])) {
                        $validate = false;
                        $other[]  = 'Mode has already been taken';
                    }
                }
            }
            //end


            // ------------------------

            if ($validate) {
                $model->save();
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "Paymentmode {$model->mode}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['id']     = $model->id;
                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error  = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
    // ----------added -by-indhu-18-11-2022----------------------------
    public function actionCheckPaymentModeDetails()
    {
        //to find payment modes list//comming from add receipt voucher page
        $modeid = $_POST['modeid'];
        $model  = new AccPaymentMode();
        $model  = $model->findByPk($modeid);
        $data['id']           =  $model->id;
        $data['mode']         =  $model->mode;
        $data['bank_name']    =  $model->bank_name;
        $data['card_no']      =  $model->card_no;
        $data['cheque_no']    =  $model->cheque_no;
        $data['cheque_date']  =  $model->cheque_date;
        $data['reference_no'] =  $model->reference_no;
        $data['ledger_id']    =  $model->ledger_id;
        $data['discount']      =  $model->discount;
        echo json_encode($data);
    }
}
