<?php

/*
 chart of accounts
 payment ledger, Save
 date 18-11-2022
 author -Indhu
 main setup
 Tables    - erp_acc_payment_ledger
 models used   - AccPaymentLedger

 */


class PaymentledgerController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'RemoveAccVoucherTypeDetails', 'GetMappingAttribute','GetPaymentLedger','GetPaymentLedgerdetails'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetList()
    {
        $model  = new AccPaymentLedger();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.code',
            2 => 't.description',
            3 => 't.last_number',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    = 't.id LIKE "%' . $searchString . '%" OR t.attribute LIKE "%' . $searchString . '%"';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {
            $modelAccSystemAccountsMapping    = new AccSystemAccountsMapping();
            $AccSystemAccountsMapping_details = $modelAccSystemAccountsMapping->find(array('condition' => 'attribute="' . $eachItem['attribute'] . '"'));

            $div      = '<div class="btn-wrap text-center">';
            $div     .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/paymentledger/Create&id=' . $eachItem['id'] . '\',\'Edit Payment Ledger \',\'xs\')"><i class="fa fa-edit"></i></a>';
            $div     .= '</div>';
            $eachItemData[] = array($AccSystemAccountsMapping_details['description'], $div);
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new AccPaymentLedger();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model     = $model->findBypk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('paymentledger_from', array('model' => $model));
    }



    public function actionSave()
    {
        $model = new AccPaymentLedger();
        $validate = true;
        if (isset($_POST['AccPaymentLedger'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['AccPaymentLedger']['id'] > 0) {
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['AccPaymentLedger']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['AccPaymentLedger'];
            $model->attribute       = $_POST['AccPaymentLedger']['attribute'];
            $validate          = $model->validate();
            // ------------------------

            if ($validate) {
                $model->save();
                $jsonData['status'] = 'success';
                $jsonData['id']     = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error  = CJSON::encode(array_merge_recursive($error1));
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }


    // ----------added -by-indhu-18-11-2022----------------------------
    public function actionGetPaymentLedger(){
        //to find payment modes list//comming from add receipt voucher page
        $PaymentLedgerid = $_POST['PaymentLedgerid'];
        $model  = new AccPaymentLedger();
        $model  = $model->findByPk($PaymentLedgerid);
        $attribute =   $model->attribute;
        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        $ledger_id = $modelAccSystemAccountsMapping->getSystemdefault($attribute);
        $data['ledger_id']           =  $ledger_id;
        echo json_encode($data);
    }
    
    // ----------added -by-indhu-15-03-2023----------------------------
     public function actionGetPaymentLedgerdetails()
    {
        $ledger_id = (int)Yii::app()->request->getparam("ledger_id");  
       
        $columnWidth=Yii::app()->request->getparam("columnWidth"); 
       
        $drop='<li class="col-sm-'.$columnWidth.'">';
        $modelAccPaymentLedger = new AccPaymentLedger();
       
        $drop .= CHtml::dropDownList('payment_ledger', '', $modelAccPaymentLedger->getAccModePaymentLedgers($ledger_id), array('class' => 'tooltipster', 'data-label' => 'Payment Ledger'));

        $drop.='</li>';
        $status=array("dt" => $drop);
        echo CJSON::encode($status);

    }

  
}
