<?php

/* 
Mas Dimension Setting
 date 21-09-2022
 author -Indhu 
 main setup
 Tables - erp_acc_voucher_type,erp_mas_dimension_setting_items
 Model  - MasDimensionSetting,MasDimensionSettingItems 
 */


class MasdimensionsettingController extends Controller
{
	 public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','Create','Save','RemoveDimestionItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

	public function actionIndex()
    {
        $this->render('index');
    }
    public function actionGetList()
    {
        $model   = new MasDimensionSetting();
        $draw    = $_POST['draw'];
        $offset  = $_POST['start'];
        $limit   = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.dimension',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';
       
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    = 't.dimension LIKE "%' . $searchString . '%" OR t.dimension LIKE "%' . $searchString . '%"';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData            = array();
        $m = 1;

        foreach ($model as $eachItem) {
            $div  = '<div class="btn-wrap text-center">';
            $div .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/masdimensionsetting/Create&id=' . $eachItem['id'] . '\',\'Edit Dimension Setting \',\'lg\')"><i class="fa fa-edit"></i></a>';
            $div .= '</div>';
            $eachItemData[] = array($m, $eachItem['dimension'], $div);
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
        }
        

        public function actionCreate()
    {
        $model = new MasDimensionSetting();
        $id    = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model                          = $model->findBypk($id);
             $dimensionSettingItems_list    = MasDimensionSettingItems::model()->findAll(array('condition' => 'dimension_setting_id=' . $id));
             if (empty($dimensionSettingItems_list)) {
                $dimensionSettingItems_list = array(new MasDimensionSettingItems());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('id'=>$id,'model' => $model,'dimensionSettingItems_list'=>$dimensionSettingItems_list));
    }
   
   
   
    public function actionSave() {

        if (isset($_POST['MasDimensionSettingItems'])) {   
            $validate=true;
            foreach ($_POST['MasDimensionSettingItems'] as $i => $item) {  
                if ($item['id'] > 0) {
                    $modelSettingItems[$i]                   = MasDimensionSettingItems::model()->findByPK($item['id']);
                    $modelSettingItems[$i]->updated_by       = Yii::app()->user->id;
                    $modelSettingItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                }else{
                    $modelSettingItems[$i]                   = new MasDimensionSettingItems();
                    $modelSettingItems[$i]->created_by       = Yii::app()->user->id;
                    $modelSettingItems[$i]->created_datetime = date('Y-m-d H:i:s');
                }
                $modelSettingItems[$i]->attributes           = $item;
                $modelSettingItems[$i]->dimension_setting_id = $_POST['MasDimensionSetting']['id'];
                $modelSettingItems[$i]->dimension_name       = $item['dimension_name'];
                $modelSettingItems[$i]->dimension_length     = $item['dimension_length'];
                $validate                                    =$modelSettingItems[$i]->validate() && $validate;
            }
           
            if ($validate) {                
                if (!empty($modelSettingItems)) {
                    foreach ($modelSettingItems as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {             
                $error1 = json_decode(CActiveForm::validateTabular($modelSettingItems, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1));
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
        
    }


    
     public function actionRemoveDimestionItem() {
        $id       = $_POST['id'];
        if ($id > 0) {
           $model           = new MasDimensionSettingItems();
        // $model           = $model->findByPk($id);
        // $model->isActive = 'N';
           $model->deleteByPk($id);
           $model->save();
           echo "success";
        } else {
            echo "fail";
        }
    }




}