<?php
class ExcelController extends Controller
{

  public function accessRules()
  {
    return array(
      array(
        'allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('login', 'error', 'logout'),
        'users' => array('*'),
      ),
      array(
        'allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array(
          'Trial_balance_Excel',
          'Trial_balance_detailed_excel',
          'Trial_balance_excel_new',
          'Profit_loss_Excel',
          'Balance_Excel',
          'Balance_Ac_Excel',
          'Gl_report_Excel',
          'GldetailedreportExcel',
          'Statement_Excel',
          'Statement_as_on_excel',
          'ConsolidatedStatement_excel',
          'Aging_excel',
          'vat_summary_excel',
          'vat_register_excel',
          'subledger_detail_report_excel',
          'gl_summary_excel',
          'Profit_loss_detailed_Excel',
          'Balance_detailed_Excel',
          'Statement_pdc_Excel',
          'Auditclose_detailed_Excel',
          'ledger_report_Excel'
        ),
        'expression' => '$user->isMember()',
      ),
      array(
        'deny', // deny all users
        'users' => array('*'),
      ),
    );
  }




  // public $modelMasCurrency;

  // public function init()
  // {
  //   parent::init();
  //   $this->modelMasCurrency = new MasCurrency();
  // }

  public function actionTrial_balance_Excel()
  {

    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "TrialBalance_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.trial_balance_Excel', $param, false, true);
    Yii::app()->end();
  }
  
public function actionTrial_balance_excel_new()
{
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    $gl_auditclose_id      = (int) $_REQUEST['gl_auditclose_id'];
    
    $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);
    $trialBalanceDetails = AccAccount::model()->getTrialBalanceDetails($from_date, $to_date, $level, $gl_auditclose_id);

    $param = array(
      'from_date'           => $from_date,
      'to_date'             => $to_date,
      'level'               => $level,
      'type'                => $type,
      'brand'               => $acc_report_brand,
      'outlet_id'           => $outlet_id,
      'department_id'       => $department_id,
      'warehouse_id'        => $warehouse_id,
      'gl_auditclose_id'    => $gl_auditclose_id,
      'auditclose'          => $auditclose,
      'trialBalanceDetails' => $trialBalanceDetails
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "TrialBalance_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.trial_balance_excel_new', $param, false, true);
    Yii::app()->end();
}

public function actionTrial_balance_detailed_excel()
{
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $gl_auditclose_id       = $_REQUEST['gl_auditclose_id'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    $trialBalanceDetails = AccAccount::model()->getTrialBalanceDetails($from_date, $to_date, $level, $gl_auditclose_id);
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
      'trialBalanceDetails' => $trialBalanceDetails
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "TrialBalanceDetailed_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.trial_balance_detailed_excel', $param, false, true);
    Yii::app()->end();
}

  public function actionProfit_loss_Excel()
  {

    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "ProfitLoss_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.profit_loss_Excel', $param, false, true);
    Yii::app()->end();
  }

  public function actionBalance_Excel()
  {

    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "BalanceReport_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.balance_Excel', $param, false, true);
    Yii::app()->end();
  }
  
  public function actionBalance_Ac_Excel()
  {
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $gl_auditclose_id       = $_REQUEST['gl_auditclose_id'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    
    $balanceSheetDetails = AccAccount::model()->getBalanceSheetDetails($to_date, $level, $gl_auditclose_id);
    
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'gl_auditclose_id'         => $gl_auditclose_id,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
      'balanceSheetDetails' => $balanceSheetDetails
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "BalanceReport_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.balance_ac_excel', $param, false, true);
    Yii::app()->end();
  }

  public function actionGl_report_Excel()
  {

    $date_field            = $_REQUEST['date_field'];
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger_id             = (int) $_REQUEST['ledger_id'];
    $subledger             = (int) $_REQUEST['subledger_id'];
    $currency              = (int) $_REQUEST['currency'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $param = array(
      'date_field'    => $date_field,
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'currency'      => $currency,
      'ledger_id'     => $ledger_id,
      'subledger'     => $subledger,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $filename = "GlReport_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.gl_report_Excel', $param, false, true);
    Yii::app()->end();
  }

  public function actionGldetailedreportExcel()
  {



    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger_id      = (int) $_REQUEST['ledger_id'];
    $subledger_id   = (int) $_REQUEST['subledger_id'];
    $currency       = (int) $_REQUEST['currency'];
    $date_field     = $_REQUEST['date_field'];
    $acc_order_by   = $_REQUEST['acc_order_by'];
    $amount_type    = $_REQUEST['amount_type'];
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'ledger_id'    => $ledger_id,
      'subledger'    => $subledger_id,
      'currency'     => $currency,
      'date_field'   => $date_field,
      'order_by' => $acc_order_by,
      'amount_type'  => $amount_type
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = "GlDetailedReport_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.gl_detailed_report_Excel', $param, false, true);
    Yii::app()->end();
  }



  public function actionStatement_Excel()
  {

    $from      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');
    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');
    $cur                = MasCurrency::model()->findByPk($currency);
    $exchange_rate      = (float)$cur->exchange_rate;
    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
      'exchange_rate' => $exchange_rate,
    );

    $type_det = ($type == 'customer') ? 'CustomerStatement' : 'VendorStatement';
    $filename = $type_det . "_" . date("d-m-Y_H-i-s") . ".xls";

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.statement_Excel', $param, false, true);
    Yii::app()->end();
  }




  public function actionStatement_as_on_excel()
  {

    $from          = '2020-01-01';
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');
    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');
    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
    );

    $type_det = ($type == 'customer') ? 'CustomerStatementAsonDate' : 'VendorStatementAsonDate';
    $filename = $type_det . "_" . date("d-m-Y_H-i-s") . ".xls";

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.statement_as_on_Excel', $param, false, true);
    Yii::app()->end();
  }




  public function actionConsolidatedStatement_excel()
  {

    $from      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');
    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');
    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
    );

    $type_det     = "CustomerConsolidatedStatement_" . date("d-m-Y_H-i-s") . ".xls";

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = $type_det;
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.statement_consolidated_Excel', $param, false, true);
    Yii::app()->end();
  }




  public function actionAging_excel()
  {
    $from_date    = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-d');
    $to_date      = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger       = (int) Yii::app()->request->getParam('ledger_id');
    $subledger_id = (int) Yii::app()->request->getParam('subledger_id');
    $category     = (Yii::app()->request->getParam('category') == 'RECEIVABLE') ? 'RECEIVABLE' : 'PAYABLE';
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'aging_pdf';
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'ledger'        => $ledger,
      'subledger_id'  => $subledger_id,
      'category'      => $category,
    );
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $type_det =  $category == 'RECEIVABLE' ? 'ReceivableAaging' : 'PayableAging';
    $filename = $type_det . "_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.aging_excel', $param, false, true);
    Yii::app()->end();
  }




  public function actionVat_summary_excel()
  {

    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
    );
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename     = "VatSummary_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.vat_summary_excel', $param, false, true);
    Yii::app()->end();
  }



  public function actionVat_register_excel()
  {
    $from_date      = (count(explode('/', $_REQUEST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from_date']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-d');
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
    );
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename     = "VatRegister_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.vat_register_excel', $param, false, true);
    Yii::app()->end();
  }



  public function actionSubledger_detail_report_excel()
  {
    $from_date     = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date       = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
    $ledger_id     = (int) $_REQUEST['ledger_id'];
    $subledger     = (int) $_REQUEST['subledger'];
    $warehouse_id  = (int) $_REQUEST['warehouse_id'];
    $outlet_id  = (int) $_REQUEST['outlet_id'];

    $currency      = 1;
    $cur           = MasCurrency::model()->findByPk(1);
    $exchange_rate = $cur->exchange_rate;
    $currency_code = $cur->currency_code;
    $param = array(
      'from_date'      => $from_date,
      'to_date'        => $to_date,
      'currency'       => $currency,
      'ledger_id'      => $ledger_id,
      'subledger'      => $subledger,
      'exchange_rate'  => $exchange_rate,
      'currency_code'  => $currency_code,
      'warehouse_id'   => $warehouse_id,
      'outlet_id'     => $outlet_id,

    );
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename     = "SubledgerDetailReport_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.subledger_detail_report_excel', $param, false, true);
    Yii::app()->end();
  }



  public function actionGl_summary_excel()
  {

    $ledger        = (int) $_GET['ledger'];
    $from_date      = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
    $to_date        = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
    $brand          = (int) $_GET['brand'];
    $condition      = 'VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '"';
    $glSummaryquery = 'CREATE OR REPLACE VIEW {{acc_view_gl_summary}} AS SELECT
                                        SL.id AS subledger_id,
                                        L.ledger_acc_no AS ledger_no,
        								IFNULL(SL.subledger_name, "No Subledger") AS subledger_name,
                                        ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                        ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
        								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                        L.id AS ledger_id,VI.subledger_id AS voucher_sub_id
        							FROM {{acc_voucher_items}} VI
                                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
        							LEFT JOIN {{acc_ledger}} L ON L.id = VI.ledger_id
        							LEFT JOIN {{acc_subledger}} SL ON SL.id = VI.subledger_id
        							WHERE ' . $condition . '
        							GROUP BY  VI.ledger_id, VI.subledger_id';
    Yii::app()->db->createCommand($glSummaryquery)->execute();

    $param = array(
      'to_date'   => $to_date,
      'from_date' => $from_date,
      'ledger'    => $ledger,
    );
    $filename     = "LedgerSummary_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.gl_summary_report_excel', $param, false, true);
    Yii::app()->end();
  }




  public function actionProfit_loss_detailed_Excel()
  {
    set_time_limit(0);
    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level          = (int) $_REQUEST['level'];
    $type           = $_REQUEST['type'];

    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'level'        => $level,
      'type'         => $type,

    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename     = "ProfitLossDetailed_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.profit_loss_detailed_Excel', $param, false, true);
    Yii::app()->end();
  }



  public function actionBalance_detailed_Excel()
  {

    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level          = (int) $_REQUEST['level'];
    $type           = $_REQUEST['type'];
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'level'        => $level,
      'type'         => $type,
    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $filename     = "BalanceDetailed_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.balance_detailed_Excel', $param, false, true);
    Yii::app()->end();
  }

  public function actionStatement_pdc_Excel()
  {

    $from      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');
    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');
    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
    );

    $type_det     = ($type == 'customer') ? 'customer_statement_pdc_Excel.xls' : 'vendor_statement_pdc_Excel.xls';

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = $type_det;
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.statement_pdc_Excel', $param, false, true);
    Yii::app()->end();
  }

  public function actionAuditclose_detailed_Excel()
  {
    $auditclose_id = (int) $_REQUEST['ac_id'];
    $auditclose = AccAuditClose::model()->findByPk($auditclose_id);
    $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($auditclose_id);
    $param = array('auditclose'    => $auditclose, 'auditCloseLedgerResults' => $auditCloseLedgerResults);
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename     = "AuditcloseDetailed_" . date("d-m-Y_H-i-s") . ".xls";
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.auditclose_detailed_Excel', $param, false, true);
    Yii::app()->end();
  }

  public function actionledger_report_Excel()
  {

    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level          = (int) $_REQUEST['level'];
    $year           = (int)$_REQUEST['year'];
    $company        = (int) $_REQUEST['company'];
    $branch         = (int) $_REQUEST['branch'];
    $salesgroup     = (int) $_REQUEST['salesgroup'];
    $brand          = (int) $_REQUEST['brand'];
    $employee       = (int) $_REQUEST['employee'];
    $dep            = (int) $_REQUEST['dep'];
    $costcenter     = (int) $_REQUEST['costcenter'];
    $cate           = (int) $_REQUEST['cate'];
    $project        = (int) $_REQUEST['project'];
    $item           = (int) $_REQUEST['item'];
    $ledger_id      = (int) $_REQUEST['ledger_id'];
    $subledger_id   = (int) $_REQUEST['subledger_id'];
    $currency       = (int) $_REQUEST['currency'];
    $warehouse_id   = (int) $_REQUEST['warehouse_id'];
    $date_field     =  $_REQUEST['date_field'];
    $outlet_id     =  (int)$_REQUEST['acc_outlet_id'];


    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'level'        => $level,
      'year'         => $year,
      'company'      => $company,
      'branch'       => $branch,
      'salesgroup'   => $salesgroup,
      'brand'        => $brand,
      'employee'     => $employee,
      'department'   => $dep,
      'costcenter'   => $costcenter,
      'category'     => $cate,
      'project'      => $project,
      'item'         => $item,
      'ledger_id'    => $ledger_id,
      'subledger'    => $subledger_id,
      'currency'     => $currency,
      'warehouse_id' => $warehouse_id,
      'date_field'   => $date_field,
      'outlet_id'   => $outlet_id,
    );
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $filename = 'ledger_report_Excel.xls';
    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
    $this->renderPartial('application.modules.accounts.views.reports.excel.ledger_report_Excel', $param, false, true);
    Yii::app()->end();
  }
  //end
}
