<?php


class BudgetingController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'SaveDataToTemp', 'BudgetingExcel', 'MonthWiseList', 'Save'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


//  public $modelMasCurrency; 

//     public function init()
//     {
//         parent::init();
//         $this->modelMasCurrency = new MasCurrency();
//     }
    
    public function actionIndex()
    {

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('index', array());
    }

    public function actionSave()
    {
        $modelMasCurrency = new MasCurrency();
       
        // Check if the temp_budgeting_ledger_data table exists
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE 'budgeting_ledger_data'")->queryScalar();

        if ($tableExists) {
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS budgeting_ledger_data")->execute();
        }

        // If the table doesn't exist, create it
        // if (!$tableExists) {

        /* $columns = array_keys($_POST['AccLedger'][0]); // Assuming the first array has all possible keys
            $columnDefinitions = implode(', ', array_map(function ($column) {
                return "$column DECIMAL(10, 2)";
            }, $columns));

            $sql = "CREATE  TABLE temp_budgeting_ledger_data ($columnDefinitions)";
            Yii::app()->db->createCommand($sql)->execute(); */

        $columns = array_keys($_POST['AccLedger'][0]); // Assuming the first array has all possible keys
        
        $decimal = $modelMasCurrency->baseCurrencyDefultDecimal();

        $columnDefinitions = implode(', ', array_map(function ($column) use ($decimal) {
            // Assuming you want to set specific data types for the first two columns
            if ($column === 'id') {
                return "$column INT";
            } else if ($column === "ledger_acc_no") {
                return "$column BIGINT";
            } else if ($column === "ledger_acc_name") {
                return "$column VARCHAR(255)";
            } else {
                return "$column DECIMAL(10,$decimal)";
            }
        }, $columns));

        $sql = "CREATE TABLE budgeting_ledger_data ($columnDefinitions)";
        Yii::app()->db->createCommand($sql)->execute();

        /*  CREATE TEMPORARY TABLE temp_budgeting_ledger_data (
            ledger_acc_no DECIMAL(10, 2),
            id DECIMAL(10, 2),
            balance_2022 DECIMAL(10, 2),
            balance_2023 DECIMAL(10, 2),
            balanceactual_2024 DECIMAL(10, 2),
            balance_2024_another_name DECIMAL(10, 2), 
            balance_2025 DECIMAL(10, 2)
        ); */
        //}
        

        // Now you can use the temporary table for further operations
        foreach ($_POST['AccLedger'] as $ledgerData) {
            $columns = implode(', ', array_keys($ledgerData));
            $placeholders = ':' . implode(', :', array_keys($ledgerData));
            $sql = "INSERT INTO budgeting_ledger_data ($columns) VALUES ($placeholders)";
            $command = Yii::app()->db->createCommand($sql);
            // Bind parameters
            foreach ($ledgerData as $key => $value) {
                $command->bindValue(":$key", $value);
            }
            $command->execute();
        }
        $jsonData['status'] = 'success';
       
        echo CJSON::encode($jsonData);
    }



    public function actionSaveDataToTemp()
    {

        
        // Check if the temp_budgeting_ledger_data table exists
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE 'budgeting_ledger_data'")->queryScalar();

        if ($tableExists) {
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS budgeting_ledger_data")->execute();
        }

        // If the table doesn't exist, create it
        // if (!$tableExists) {

        /* $columns = array_keys($_POST['AccLedger'][0]); // Assuming the first array has all possible keys
            $columnDefinitions = implode(', ', array_map(function ($column) {
                return "$column DECIMAL(10, 2)";
            }, $columns));

            $sql = "CREATE  TABLE temp_budgeting_ledger_data ($columnDefinitions)";
            Yii::app()->db->createCommand($sql)->execute(); */

$decimal = $modelMasCurrency->baseCurrencyDefultDecimal();

            
        $columns = array_keys($_POST['AccLedger'][0]); // Assuming the first array has all possible keys
        $columnDefinitions = implode(', ', array_map(function ($column) use ($decimal) {
            // Assuming you want to set specific data types for the first two columns
            if ($column === 'id') {
                return "$column INT";
            } else if ($column === "ledger_acc_no") {
                return "$column BIGINT";
            } else if ($column === "ledger_acc_name") {
                return "$column VARCHAR(255)";
            } else {
                return "$column DECIMAL(10, 3)";
            }
        }, $columns));

        $sql = "CREATE TABLE budgeting_ledger_data ($columnDefinitions)";
        Yii::app()->db->createCommand($sql)->execute();

        /*  CREATE TEMPORARY TABLE temp_budgeting_ledger_data (
            ledger_acc_no DECIMAL(10, 2),
            id DECIMAL(10, 2),
            balance_2022 DECIMAL(10, 2),
            balance_2023 DECIMAL(10, 2),
            balanceactual_2024 DECIMAL(10, 2),
            balance_2024_another_name DECIMAL(10, 2), 
            balance_2025 DECIMAL(10, 2)
        ); */
        //}

        // Now you can use the temporary table for further operations
        foreach ($_POST['AccLedger'] as $ledgerData) {
            $columns = implode(', ', array_keys($ledgerData));
            $placeholders = ':' . implode(', :', array_keys($ledgerData));
            $sql = "INSERT INTO budgeting_ledger_data ($columns) VALUES ($placeholders)";
            $command = Yii::app()->db->createCommand($sql);
            // Bind parameters
            foreach ($ledgerData as $key => $value) {
                $command->bindValue(":$key", $value);
            }
            $command->execute();
        }
        $jsonData['status'] = 'success';
               echo CJSON::encode($jsonData);
    }

    public function actionBudgetingExcel()
    {

        $param = array();

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Budgeting_Excel.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.modules.accounts.views.reports.excel.budgeting_excel', $param, false, true);
        Yii::app()->end();
    }

    public function actionMonthWiseList()
    {
        $ledger_id        = (int) Yii::app()->request->getParam('ledger_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('month_wise_list', array('ledger_id' => $ledger_id));
    }
}
