<?php



class AccGeneralSettingsController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Generalsettings', 'Save'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }



    public function actionGeneralsettings()
    {
        $model = new AccGeneralSettings();
        $id = 1;
        if ($id > 0) {
            $model     = $model->findBypk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('general_settings', array('model' => $model));
    }



    public function actionSave()
    {
        $model = new AccGeneralSettings();
        $validate = true;
        $other = array();
        if (isset($_POST['AccGeneralSettings'])) {
            // $model->created_by           = Yii::app()->user->id;
            // $model->created_datetime     = date('Y-m-d h:i:s');
            if ((int) @$_POST['AccGeneralSettings']['id'] > 0) {
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id                      = (int) @$_POST['AccGeneralSettings']['id'];
                $model                   = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes           = $_POST['AccGeneralSettings'];
            $model->tax_type           = $_POST['AccGeneralSettings']['tax_type'];
            $model->costcenter_1           = trim($_POST['AccGeneralSettings']['costcenter_1']);
            $model->costcenter_2           = trim($_POST['AccGeneralSettings']['costcenter_2']);
            $model->have_sales_receipt           = trim($_POST['AccGeneralSettings']['have_sales_receipt']);
            $model->allow_multiple_voucher           = trim($_POST['AccGeneralSettings']['allow_multiple_voucher']);
            $model->allow_multi_receipt           = trim($_POST['AccGeneralSettings']['allow_multi_receipt']);
            $model->allow_deliverynote           = trim($_POST['AccGeneralSettings']['allow_deliverynote']);
            $validate                    = $model->validate();
            // ------------------------

            if ($validate) {
                $model->save();
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "general settings"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['id']     = $model->id;
                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error  = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
}
