<?php

/**
 * This is the model class for table "{{vendor_contact}}".
 *
 * The followings are the available columns in table '{{vendor_contact}}':
 * @property integer $id

 * @property string $vendor_id
 * @property string $title
 * @property string $person_name
 * @property string $designation
 * @property string $ph_no
 * @property string $department
 * @property string $mobile1
 * @property string $mobile2
 * @property string $email1
 * @property string $email2
 * @property string $dob
 * @property integer $contact_method
 * @property string $notes
 * @property string $do_not_call
 * @property string $do_not_email
 * @property string $news_letter
 * @property string $facebook
 * @property string $skype
 * @property string $linkedin
 * @property string $instagram
 * @property string $googleplus
 * @property string $twitter
 * @property string $myspace
 * @property string $youtube
 * @property string $isActive
 * @property string $created_date
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 */
class VendorContact extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{vendor_contact}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('person_name', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('vendor_id', 'length', 'max'=>20),
                        array('person_name, notes,designation, contact_phone_no, department, contact_mobile_no, contact_email_id', 'length', 'max'=>255),
			array('dob', 'length', 'max'=>5),
//			array('do_not_call, do_not_email, news_letter, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,vendor_id, person_name, designation, contact_mobile_no, department, contact_phone_no,contact_email_id notes, isActive, created_date, created_by, updated_date_time, updated_by,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'vendor' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			
			'vendor_id' => 'Vendor',
			'person_name' => 'Contact Person Name',
			'designation' => 'Designation',
			'contact_phone_no' => 'Contact Phone No',
			'department' => 'Department',
			'contact_mobile_no' => 'Mobile',
			'contact_email_id' => 'Email',
			'notes' => 'Notes',
			'isActive' => 'Is Active',
			'created_date' => 'Created Date',
			'created_by' => 'Created By',
			'updated_date_time' => 'Last Updated Date',
			'updated_by' => 'Last Updated By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		
		$criteria->compare('vendor_id',$this->vendor_id,true);
		$criteria->compare('person_name',$this->person_name,true);
		$criteria->compare('designation',$this->designation,true);
		$criteria->compare('contact_phone_no',$this->ph_no,true);
		$criteria->compare('department',$this->department,true);
		$criteria->compare('contact_mobile_no',$this->mobile1,true);
		$criteria->compare('contact_email_no',$this->email1,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return VendorContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getContacts()
	{		
                $condition='isActive="Y"';
		$model = self::model()->findAll(array('condition'=>$condition,'order'=>'person_name'));
		return CHtml::listData($model, 'id', 'person_name');
	}
        public static function getVendorContacts($id)
	{		
		$model = self::model()->findAll(array('condition'=>'vendor_id='.$id));
		return CHtml::listData($model, 'id', 'person_name');
	}

	public function setDefault() {
		if (!empty($this->id)) {
			$sql = "UPDATE {{vendor_contact}} SET isDefault = 'N' WHERE vendor_id = " . $this->vendor_id;
			Yii::app()->db->createCommand($sql)->execute();
			self::model()->updateByPk($this->id, ['isDefault' => 'Y']);
		}
	}
}
