<?php

/**
 * This is the model class for table "{{customers}}".
 *
 * The followings are the available columns in table '{{customers}}':
 * @property string $id
 * @property integer $crm_user_id
 * @property string $vendor_name
 * @property string $vendor_credit_limit
 * @property integer $vendor_currency_id
 * @property string $vendor_address
 * @property string $vendor_city
 * @property string $vendor_postal_code
 * @property string $vendor_state
 * @property string $vendor_country
 * @property string $vendor_bank_tax_id
 * @property string $vendor_bank_account_no
 * @property string $vendor_bank_swift
 * @property string $vendor_bank_account_name
 * @property integer $vendor_bank_id
 * @property string $vendor_bank_name
 * @property string $vendor_bank_branch_name
 * @property string $vendor_bank_iban
 * @property string $vendor_bank_ifsc
 * @property string $vendor_bank_others
 * @property string $vendor_phone_no
 * @property string $vendor_email_id
 * @property string $vendor_location
 * @property string $vendor_payment_term
 * @property string $vendor_fax
 * @property string $vendor_web
 * @property string $vendor_industry
 * @property string $is_approved
 * @property string $isActive
 * @property string $created_date_time
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 */
class Vendor extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $file_title;
        public $contract_no;
        public $type_of_contract;
        public $contract_date_to;
        public $contract_date_from;
	public function tableName()
	{
		return '{{vendor}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_name,vendor_country,vendor_phone_no,type', 'required'),
                        array(' vendor_currency_id,ledger_id,vendor_bank_id,vendor_country, created_by, updated_by, approve', 'numerical', 'integerOnly'=>true),
			array('vendor_name, vendor_city, vendor_postal_code, vendor_state,  vendor_bank_tax_id, vendor_bank_account_no, vendor_bank_swift, vendor_bank_account_name, vendor_bank_name, vendor_bank_branch_name, vendor_bank_iban, vendor_bank_ifsc, vendor_bank_others, vendor_phone_no, vendor_email_id, vendor_location, vendor_payment_term, vendor_fax, vendor_web, vendor_industry,vendor_trn_no,score,vendor_email_id', 'length', 'max'=>255),
			array('vendor_name','checkUniqueApplication'),
			array('is_approved, isActive', 'length', 'max'=>1),
           // array('vendor_email_id','email'),
                      
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,  vendor_name,ledger_id,vendor_currency_id, vendor_address, vendor_city, vendor_postal_code, vendor_state, vendor_country, vendor_bank_tax_id, vendor_bank_account_no, vendor_bank_swift, vendor_bank_account_name, vendor_bank_id, vendor_bank_name, vendor_bank_branch_name, vendor_bank_iban, vendor_bank_ifsc, vendor_bank_others, vendor_phone_no, vendor_email_id, vendor_location, vendor_payment_term, vendor_fax, vendor_web, vendor_industry, is_approved, isActive, created_date_time, created_by, updated_date_time, updated_by, notes,created_by,updated_by,created_date_time,updated_date_time,approve', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry','vendor_country'),
                    'currency_detail' => array(self::BELONGS_TO, 'MasCurrency','vendor_currency_id'),
                    'contractdetails' => array(self::HAS_MANY, 'Contract','vendor_id'),
                    'registrationdetails' => array(self::HAS_MANY, 'Registration','vendor_id'),
                    'customercontact' => array(self::HAS_ONE, 'CustomerContact','vendor_id'),
                    'payterm' => array(self::BELONGS_TO, 'MasPaymentTerm','vendor_payment_term'),
                    'state' => array(self::BELONGS_TO, 'MasEmiratesList','vendor_state'),

		);
	}



	public function checkUniqueApplication($attribute, $params)
    {        if($this->id <= 0){
        if ($this->vendor_name !== "") {
            $model = Vendor::model()->find('vendor_name = ?', array($this->vendor_name));
            if ($model != null) {
                $this->addError('id', 'Supplier name  exists');
            }

        }
    }
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			
			'vendor_name' => 'Name',
			
			'vendor_currency_id' => 'Currency',
			'vendor_address' => 'Billing Address',
			'vendor_city' => 'City',
			'vendor_postal_code' => 'Postal Code',
			'vendor_state' => 'State',
			'vendor_country' => 'Billing Country',
			'vendor_bank_tax_id' => ' Bank Tax',
			'vendor_bank_account_no' => 'Bank Account No',
			'vendor_bank_swift' => 'Bank Swift',
			'vendor_bank_account_name' => 'Bank Account Name',
			'vendor_bank_id' => 'Bank',
			'vendor_bank_name' => ' Bank Name',
			'vendor_bank_branch_name' => 'Branch Name',
			'vendor_bank_iban' => 'Bank Iban',
			'vendor_bank_ifsc' => 'Bank Ifsc',
			'vendor_bank_others' => 'Bank Others',
			'vendor_phone_no' => 'Phone No',
			'vendor_email_id' => 'Email',
			'vendor_location' => 'Location',
			'vendor_payment_term' => ' Payment Term',
			'vendor_fax' => ' Fax',
			'vendor_web' => 'Web',
			'vendor_industry' => 'Industry',
			'vendor_trn_no'=>'TRN#',
			'is_approved' => 'Is Approved',
			'isActive' => 'Is Active',                       
			'created_date_time' => 'Created Date',
			'created_by' => 'Created By',
			'updated_date_time' => 'Last Updated Date',
			'updated_by' => 'Last Updated By',
			'approve'=>'Approved by Finance',
                        'notes' =>'notes',
                         'type' =>'Type'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		
		$criteria->compare('vendor_name',$this->vendor_name,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('vendor_currency_id',$this->vendor_currency_id);
		$criteria->compare('vendor_address',$this->vendor_address,true);
		$criteria->compare('vendor_city',$this->vendor_city,true);
		$criteria->compare('vendor_postal_code',$this->vendor_postal_code,true);
		$criteria->compare('vendor_state',$this->vendor_state,true);
		$criteria->compare('vendor_country',$this->vendor_country,true);
		$criteria->compare('vendor_bank_tax_id',$this->vendor_bank_tax_id,true);
		$criteria->compare('vendor_bank_account_no',$this->vendor_bank_account_no,true);
		$criteria->compare('vendor_bank_swift',$this->vendor_bank_swift,true);
		$criteria->compare('vendor_bank_account_name',$this->vendor_bank_account_name,true);
		$criteria->compare('vendor_bank_id',$this->vendor_bank_id);
		$criteria->compare('vendor_bank_name',$this->vendor_bank_name,true);
		$criteria->compare('vendor_bank_branch_name',$this->vendor_bank_branch_name,true);
		$criteria->compare('vendor_bank_iban',$this->vendor_bank_iban,true);
		$criteria->compare('vendor_bank_ifsc',$this->vendor_bank_ifsc,true);
		$criteria->compare('vendor_bank_others',$this->vendor_bank_others,true);
		$criteria->compare('vendor_phone_no',$this->vendor_phone_no,true);
		$criteria->compare('vendor_email_id',$this->vendor_email_id,true);
		$criteria->compare('vendor_location',$this->vendor_location,true);
		$criteria->compare('vendor_payment_term',$this->vendor_payment_term,true);
		$criteria->compare('vendor_fax',$this->vendor_fax,true);
		$criteria->compare('vendor_web',$this->vendor_web,true);
		$criteria->compare('vendor_industry',$this->vendor_industry,true);
		$criteria->compare('is_approved',$this->is_approved,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}	
	
	public function getConcatenedVendorname()
        {
                if(!empty($this->vendor_location)){
                    return $this->vendor_name.'['.$this->vendor_location."]";
                }
                else
                {
                    return $this->vendor_name;
                }
        }
	
        public static function getVendors()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'vendor_name'));
		return CHtml::listData($model, 'id', 'concatenedvendorname');
	}
	
        public static function getVendorsEnquiry($id)
	{
              
            $vendor_ids=  array();
            $condition = 'isActive =  "Y" AND t.id ="'.$id.'"';
            $model = PurchasingEnquiry::model()->find(array('condition' => $condition));	
            $sql = "SELECT vendor_name,id FROM `erp_vendor` WHERE id IN(".$model->vendor_id.")";

         $data = Yii::app()->db->createCommand($sql)->queryAll();
       return CHtml::listData($data,'id', 'vendor_name');
                              //print_r($model);
		}
		
		public function saveSublegder()
		{
			if (isset(Yii::app()->modules['finance'])) {
				Yii::import('application.modules.finance.models.*');
				$existence = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=2 AND parent_id=' . $this->id));
				if ($existence->id > 0) {
					FinanceSubledger::model()->updateBypk(
						$existence->id,
						array(
							'description' => $this->vendor_name,
							'address' => $this->vendor_address,
							'phone' => $this->vendor_phone_no,
						)
					);
				} else {
					$newItem = new FinanceSubledger;
					$newItem->description = $this->vendor_name;
					$newItem->account_no = $this->id;
					$newItem->address = $this->vendor_address;
					$newItem->phone = $this->vendor_phone_no;
					$newItem->subledger_type_id = 2; //creditor
					$newItem->parent_id = $this->id;
					$newItem->save(false);

					$this->subledger_added = 'Y';
					$this->save(false);
				}
			}
		}  
		public static function getVendorsByType($type)
    	{
    		$condition = 'isActive =  "Y" AND type='.$type;
    		$model = self::model()->findAll(array('condition' => $condition,'order'=>'vendor_name'));
    		return CHtml::listData($model, 'id', 'vendor_name');
    	}
    	
    	
        public static function GetVendorName($vendor_id=0)
    	{
    		$model = self::model()->findByPk($vendor_id);
    		return $model->vendor_name;
    	}
}
