<?php

/**

 * This is the model class for table "{{unit}}".

 *

 * The followings are the available columns in table '{{unit}}':

 * @property integer $id
 * @property string $unit_name
 * @property string $symbol
 * @property string $isActive
 */
class Unit extends CActiveRecord {
    
    PUBLIC CONST LTR = 7;

    /**

     * @return string the associated database table name

     */
    public function tableName() {
        return '{{unit}}';
    }

    /**

     * @return array validation rules for model attributes.

     */
    public function rules() {

        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.

        return array(
            array('unit_name, symbol', 'required'),
            array('unit_name', 'length', 'max' => 255),
            array('unit_name', 'unique'),
        
            array('unit_name', 'filter', 'filter'=>'trim'),
            array('symbol', 'length', 'max' => 10),
            array('isActive,is_base_unit', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, unit_name, symbol, isActive,is_base_unit,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**

     * @return array relational rules.

     */
    public function relations() {

        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**

     * @return array customized attribute labels (name=>label)

     */
    public function attributeLabels() {

        return array(
            'id' => 'ID',
            'unit_name' => 'Unit Name',
            'symbol' => 'Symbol',
            'isActive' => 'Is Active',
        );
    }

    /**

     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.

     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('unit_name'));
       //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('unit_name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.unit_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Unit the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getUnits() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'unit_name'));
        return CHtml::listData($model, 'id', 'unit_name');
    }
    public static function getUnitEach(){
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" AND unit_name="Each"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'id', 'unit_name');
    }
    
    public static function getDefaultUnit() {
     	$condition = 'isActive =  "Y" AND is_base_unit="Y"';
     	$model = self::model()->find(array('condition' => $condition));
     	return $model;
     }

    public static function base_unit_id()
    {
        return self::model()->find(array('select' => 'id', 'condition' => 'is_base_unit="Y"'))->id;
    }
    public static function getUnits_2($id) {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" AND id='.(int)$id;
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'symbol'));
        return CHtml::listData($model, 'id', 'symbol');
    }

}

