<?php

/**
 * This is the model class for table "{{order_item}}".
 *
 * The followings are the available columns in table '{{order_item}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $product_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 * @property double $rate
 * @property double $amount
 * @property double $addition_percentage
 * @property double $addition_amount
 * @property double $deduction_percentage
 * @property double $deduction_amount
 * @property double $net_amount
 *
 * The followings are the available model relations:
 * @property Order $order
 * @property Store $product
 */
class SubstituteOrderItem extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $unit;
    public $unit_id;
    public $item_qty;
    public $hiring_item_id;

    public function tableName() {
        return '{{order_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, description, quantity, amount, net_amount', 'required'),
            array('order_id, product_id', 'numerical', 'integerOnly' => true),
            array('description', 'length', 'max' => 1000),
            array('bonus_qty,quantity', 'length', 'max'=>10),
            array('bonus_qty,quantity, rate, amount, addition_amount, deduction_amount, net_amount', 'numerical'),
            array('addition_percentage, deduction_percentage,tax_vat_amount', 'length', 'max' => 50),
            array('quantity', 'length', 'max'=>10),
            //array('description', 'length', 'max' => 255),
            array('product_id, rate', 'check_inventory'),
            /*array(
                'rate',
                'compare',
                'compareValue' => 0,
                'operator' => '>',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),*/
            array(
                'net_amount',
                'compare',
                'compareValue' => 0,
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than or equal to "{compareValue}".'
            ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, order_id, product_id, description, quantity, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'safe', 'on' => 'search'),
        );
    }


    public function check_inventory($attribute,$params)
    {           
            if( $this->product_id!=999999 && $this->rate<0){//$this->product->inventory_type !=2 &&
                $this->addError('rate','Rate must be greater than 0');
            }
               
    }
    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'order' => array(self::BELONGS_TO, 'Order', 'order_id'),
            'parent' => array(self::BELONGS_TO, 'Order', 'order_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'orderunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
            'hiringorderitem' => array(self::BELONGS_TO, 'HiringItems', 'hiring_item_id'),
  
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'order_id' => 'Order',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'amount' => 'Amount',
            'addition_percentage' => 'Addition Percentage',
            'addition_amount' => 'Addition Amount',
            'deduction_percentage' => 'Deduction Percentage',
            'deduction_amount' => 'Deduction Amount',
            'net_amount' => 'Net Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return OrderItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
}
