<?php

/**
 * This is the model class for table "{{store}}".
 *
 * The followings are the available columns in table '{{store}}':
 * @property integer $id
 * @property string $part_number
 * @property string $oem_number
 * @property string $alias_name
 * @property integer $generic_id
 * @property integer $brand_class_id
 * @property integer $unit_id
 * @property string $item_image
 * @property string $description
 * @property string $rate
 * @property integer $inventory_item_type
 * @property string $default_service_item
 * @property integer $tax_code
 * @property string $weight
 * @property string $volume
 * @property integer $re_order_level
 * @property integer $re_order_lot
 * @property string $hsir_code
 * @property string $version
 * @property string $bar_code
 * @property string $others
 * @property string $notes
 * @property string $have_expiry_date
 * @property string $have_serial_no
 * @property integer $warehouse_id
 * @property integer $rack_id
 * @property integer $bin_id
 * @property string $length
 * @property string $width
 * @property string $height
 * @property string $thickness
 * @property string $cubic_meter
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Store extends CActiveRecord
{
    public $oldBarCode;
    public $oldPartNo;
    public $oldOemNo;

    public $id;
  public $part_number;
  public $description;

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{store}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('part_number, description, unit_id, tax_code', 'required'),
            array('part_number', 'unique'),
            array('part_number,hsir_code,bar_code', 'filter', 'filter' => 'trim', 'on' => 'add'),
            array('part_number', 'unique', 'on' => 'add'),
            array('bar_code', 'unique'),
            //array('bar_code', 'checkUniqueness'),
            //array('oem_number', 'checkUniquenessOemNumber'),
            array('warehouse_id', 'checkWarehouse'),
            //array('machine_type', 'checkMachineType'),
            array('rack_id', 'checkRack'),
            //array('bin_id', 'checkBin'),
            // array('brand_class_id', 'checkBrandClass'),
            array('part_number', 'checkUniqueBarcode'),
            array('generic_id, brand_class_id, unit_id,ledger_id,inventory_item_type, tax_code, re_order_level, re_order_lot, warehouse_id, rack_id, bin_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('part_number, oem_number, item_image, description, hsir_code, version, bar_code, others,finished,material,notes', 'length', 'max' => 255),
            array('rate, weight, volume', 'length', 'max' => 15),
            array('default_service_item, have_expiry_date, have_serial_no, isActive', 'length', 'max' => 1),
            array('length, width, height, thickness, cubic_meter', 'length', 'max' => 10),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, part_number, oem_number,ledger_id,alias_name, generic_id, brand_class_id, unit_id, item_image, description, rate, inventory_item_type, default_service_item, tax_code, weight, volume, re_order_level, re_order_lot, hsir_code, version, bar_code, others, notes, have_expiry_date, have_serial_no, warehouse_id, rack_id, bin_id, length, width, height, thickness, cubic_meter, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'brand_detail' => array(self::BELONGS_TO, 'MasInvBrand', 'brand_class_id'),
            'tax' => array(self::BELONGS_TO, 'MasInvTax', 'tax_code'),
            'unit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
            'salesunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'default_sales_unit_id'),
            'genericdetails' => array(self::BELONGS_TO, 'MasGeneric', 'generic_id'),
            'item_type' => array(self::BELONGS_TO, 'MasInventoryItemType', 'inventory_item_type'),
            'products' => array(self::HAS_MANY, 'Product', 'store_id'),
            //'totalQuantity' => array(self::STAT, 'StockLedger', 'product_id', 'select' => 'SUM(quantity * unit_factor)','condition' => 'stock_updated="Y"'),
            /*'total_allocated_quantity' => array(self::STAT, 'AllocatedMaterial', 'product_id', 'select' => 'SUM(quantity)',
                'condition' => 'allocation_end_date >="' . date('Y-m-d') . '"'),*/
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'part_number' => 'Part Number',
            'oem_number' => 'Purchasing Part No',
            'alias_name' => 'Alias Name',
            'generic_id' => 'Generic',
            'brand_class_id' => 'Brand Class',
            'unit_id' => 'Unit',
            'item_image' => 'Item Image',
            'description' => 'Description',
            'rate' => 'Rate',
            'inventory_item_type' => '1 - stock item, 2- service item, 3- raw material,4-Equipments',
            'default_service_item' => 'Default Service Item',
            'tax_code' => 'Tax Code',
            'weight' => 'Weight',
            'volume' => 'Volume',
            're_order_level' => 'Re Order Level',
            're_order_lot' => 'Re Order Lot',
            'hsir_code' => 'Hsir Code',
            'version' => 'Version',
            'bar_code' => 'Bar Code',
            'others' => 'Others',
            'notes' => 'Notes',
            'have_expiry_date' => 'Have Expiry Date',
            'have_serial_no' => 'Have Serial No',
            'warehouse_id' => 'Warehouse',
            'rack_id' => 'Rack',
            'bin_id' => 'Bin',
            'length' => 'Length',
            'width' => 'Width',
            'height' => 'Height',
            'thickness' => 'Thickness',
            'cubic_meter' => 'Cubic Meter',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('part_number', $this->part_number, true);
        $criteria->compare('oem_number', $this->oem_number, true);
        $criteria->compare('alias_name', $this->alias_name, true);
        $criteria->compare('generic_id', $this->generic_id);
        $criteria->compare('brand_class_id', $this->brand_class_id);
        $criteria->compare('unit_id', $this->unit_id);
        $criteria->compare('item_image', $this->item_image, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('rate', $this->rate, true);
        $criteria->compare('inventory_item_type', $this->inventory_item_type);
        $criteria->compare('default_service_item', $this->default_service_item, true);
        $criteria->compare('tax_code', $this->tax_code);
        $criteria->compare('weight', $this->weight, true);
        $criteria->compare('volume', $this->volume, true);
        $criteria->compare('re_order_level', $this->re_order_level);
        $criteria->compare('re_order_lot', $this->re_order_lot);
        $criteria->compare('hsir_code', $this->hsir_code, true);
        $criteria->compare('version', $this->version, true);
        $criteria->compare('bar_code', $this->bar_code, true);
        $criteria->compare('others', $this->others, true);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('have_expiry_date', $this->have_expiry_date, true);
        $criteria->compare('have_serial_no', $this->have_serial_no, true);
        $criteria->compare('warehouse_id', $this->warehouse_id);
        $criteria->compare('rack_id', $this->rack_id);
        $criteria->compare('bin_id', $this->bin_id);
        $criteria->compare('length', $this->length, true);
        $criteria->compare('width', $this->width, true);
        $criteria->compare('height', $this->height, true);
        $criteria->compare('thickness', $this->thickness, true);
        $criteria->compare('cubic_meter', $this->cubic_meter, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Store the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function checkUniqueness($attribute, $params)
    {
        if (($this->bar_code !== $this->oldBarCode) && ($this->inventory_item_type == 1) && trim($this->bar_code) != '') {
            $model = Store::model()->find('part_number = ? OR  bar_code = ?', array($this->part_number, $this->bar_code));
            if ($model != null) {
                $this->addError('id', 'This ACE code already exist in either part number or Purchasing Part No');
            }
        }
    }
    public function checkUniquenessOemNumber($attribute, $params)
    {
        if ($this->oem_number !== $this->oldOemNo && $this->inventory_item_type == 1 && $this->oem_number != '') {
            $model = Store::model()->find('part_number = ? OR  oem_number = ?', array($this->part_number, $this->oem_number));
            if ($model != null) {
                $this->addError('id', 'This purchasing part no already exist in either part number or ACE code');
            }
        }
    }

    public function checkWarehouse($attribute, $params)
    {
        if ((int) $this->warehouse_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('warehouse_id', 'Warehouse cannot be blank');
        }
    }

    public function checkMachineType($attribute, $params)
    {
        if ($this->machine_type == "" && $this->inventory_item_type == 1) {
            $this->addError('machine_type', 'Machine Type cannot be blank');
        }
    }

    public function checkRack($attribute, $params)
    {
        if ((int) $this->rack_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('rack_id', 'Rack cannot be blank');
        }
    }

    public function checkBin($attribute, $params)
    {
        if ((int) $this->bin_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('bin_id', 'Bin cannot be blank');
        }
    }

    public function checkBrandClass($attribute, $params)
    {
        if ((int) $this->brand_class_id == 0 && $this->inventory_item_type == 1) {
            $this->addError('brand_class_id', 'Brand/Class cannot be blank');
        }
    }

    public function checkUniqueBarcode($attribute, $params)
    {
        if ($this->part_number !== $this->oldPartNo) {
            $model = Store::model()->find('bar_code = ? AND bar_code != ?', array($this->part_number, ''));
            if ($model != null) {
                $this->addError('id', 'This Part Number already exist in other product Bar Code');
            }
        }
    }

    public function checkPurchaseFrom($attribute, $params)
    {
        if ($this->purchase_from == "" && $this->inventory_item_type == 1) {
            $this->addError('purchase_from', 'Purchase From cannot be blank');
        }
    }

    protected function afterFind()
    {
        parent::afterFind();
        $this->oldBarCode = $this->bar_code;
        $this->oldPartNo = $this->part_number;
        $this->oldOemNo = $this->oem_number;
    }



    public function getFullname()
    {
        return ($this->part_number . ' : ' . $this->description);
    }

    public static function getProducts()
    {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'part_number'));
        return CHtml::listData($model, 'id', 'fulldetails');
    }

    public function save_ledger()
    {
        if (isset(Yii::app()->modules['finance'])) {
            Yii::import('application.modules.finance.models.*');

            //configuration
            $service_sales = 106;
            $employee_subledger_type = 3;

            $existence = FinanceLegder::model()->find(array('condition' => 'parent_id=' . (int) $this->id));
            if ($existence->id > 0) {
                FinanceLegder::model()->updateBypk(
                    $existence->id,
                    array(
                        'description' => $this->part_number,
                    )
                );
            } else {

                $parentModel = FinanceLegder::model()->findByPk($service_sales);
                $count_of_child = FinanceLegder::model()->count(array('condition' => 'parent_account=' . $service_sales));
                if ($count_of_child > 0) {
                    $account_no = Yii::app()->db->createCommand('SELECT MAX(account_no)+1 AS account_no FROM {{finance_legder}} WHERE parent_account=' . $service_sales)->queryScalar();
                } else {
                    $account_no = $parentModel->account_no . '1';
                }
                $exist = true;
                while ($exist) {
                    $existenceModel = FinanceLegder::model()->find(array('condition' => 'account_no=' . $account_no));
                    if ($existenceModel->id > 0) {
                        $account_no += 1;
                    } else {
                        $exist = false;
                    }
                }

                $newLedger = new FinanceLegder;
                $newLedger->account_no = $account_no;
                $newLedger->description = $this->part_number;
                $newLedger->type_of_account = 'P';
                $newLedger->main_account_type = 'I';
                $newLedger->parent_account = $parentModel->id;

                $root_array = ($parentModel->root != null) ? array($parentModel->root, $newLedger->parent_account) : array($newLedger->parent_account);
                $newLedger->root = implode(',', $root_array);

                $newLedger->level = $parentModel->level + 1;
                $newLedger->sort_order = 1;
                $newLedger->haveSubledger = 'Y';
                $newLedger->subledger_types = $employee_subledger_type;
                $newLedger->system_generated = 'Y';
                $newLedger->parent_id = $this->id;
                $newLedger->created_by = Yii::app()->user->id;
                $newLedger->created_datetime = date('Y-m-d');
                $newLedger->save(false);
            }
        }
    }


    //code added on 16-08-2022 by sarika to get the total quantity
    public function gettotalQuantity()
    {
        if ($this->id) {
            $sql = "SELECT IFNULL(SUM(quantity),0) AS totalQuantity FROM view_all_stock_items WHERE id=" . $this->id;
            $total_qty = Yii::app()->db->createCommand($sql)->queryScalar();

            $modelMasInventoryWarehouse = new MasInventoryWarehouse();

            $damage_warehouse_id = $modelMasInventoryWarehouse->find(array('condition' => 'warehouse_code="DAM"'))->id;

            $SQL = "SELECT IFNULL(SUM(quantity),0) AS damage_quantity FROM erp_stock_ledger WHERE product_id=" . $this->id . " AND warehouse_id=" . $damage_warehouse_id;
            $total_damage_qty = (float) Yii::app()->db->createCommand($SQL)->queryScalar();

            $total_qty = $total_qty - $total_damage_qty;
            return (float) $total_qty;
        }
    }
    public function gettotal_allocated_quantity()
    {
        if ($this->id) {
            $sql = "SELECT SUM(allocated_qty) AS totalQuantity FROM view_all_stock_items WHERE id=" . $this->id;
            $allocated_qty = Yii::app()->db->createCommand($sql)->queryScalar();
            return (float) $allocated_qty;
        }
    }
    public static function getProductslist()
    {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'part_number'));
        return CHtml::listData($model, 'id', 'part_number');
    }

    public static function getProductName($product_id)
    {
        if (empty($product_id)) {
            return '';
        }

        $product = self::model()->findByPk((int) $product_id, [
            'select' => 'part_number, description'
        ]);

        if ($product === null) {
            return '';
        }
        return $product->part_number ?: $product->description;
    }

}
