<?php

/**
 * This is the model class for table "{{stock_ledger}}".
 *
 * The followings are the available columns in table '{{stock_ledger}}':
 * @property integer $id
 * @property integer $header_id
 * @property integer $header_item_id
 * @property string $transaction_date
 * @property string $transaction_type
 * @property integer $product_id
 * @property string $quantity
 * @property integer $warehouse_id
 * @property integer $rack_id
 * @property integer $bin_id
 * @property integer $created_by
 * @property string $created_date
 * @property string $cost_price
 * @property string $sales_price
 */
class StockLedgerHiring extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{stock_ledger_hiring}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_id, header_item_id, transaction_date, transaction_type, product_id, unit_id, quantity, warehouse_id, rack_id, bin_id, created_by, created_date, cost_price', 'required'),
			array('header_id, header_item_id, product_id, unit_id, warehouse_id, rack_id, bin_id, created_by', 'numerical', 'integerOnly'=>true),
			array('transaction_type', 'length', 'max'=>255),
			array('quantity, cost_price, sales_price', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, header_id, header_item_id, transaction_date, transaction_type, product_id, quantity, warehouse_id, rack_id, bin_id, created_by, created_date, cost_price, sales_price', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
			'unit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
			'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
			'rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
			'bin' => array(self::BELONGS_TO, 'MasInvBin', 'bin_id'),
			'user' => array(self::BELONGS_TO, 'User', 'created_by'),
			'product_location' => array(self::BELONGS_TO, 'ProductLocationDetails', 'product_location_id'),
                        'product_location_hiring' => array(self::BELONGS_TO, 'ProductLocationHiringDetails', 'product_location_id'),
			//Purchase 
			'purchase' => array(self::BELONGS_TO, 'PurchasingMaterialreceipt', 'header_id'),
			'purchaseItem' => array(self::BELONGS_TO, 'PurchasingMaterialreceiptItem', 'header_item_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'header_id' => 'Header',
			'header_item_id' => 'Header Item',
			'transaction_date' => 'Transaction Date',
			'transaction_type' => 'Transcation Type',
			'product_id' => 'Product',
			'quantity' => 'Quantity',
			'warehouse_id' => 'Warehouse',
			'rack_id' => 'Rack',
			'bin_id' => 'Bin',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'cost_price' => 'Cost / Item',
			'sales_price' => 'Sales Price / Item',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('header_id',$this->header_id);
		$criteria->compare('header_item_id',$this->header_item_id);
		$criteria->compare('transaction_date',$this->transaction_date,true);
		$criteria->compare('transaction_type',$this->transaction_type,true);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('warehouse_id',$this->warehouse_id);
		$criteria->compare('rack_id',$this->rack_id);
		$criteria->compare('bin_id',$this->bin_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('cost_price',$this->cost_price,true);
		$criteria->compare('sales_price',$this->sales_price,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return StockLedger the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getBatchNo($header_id=0,$product_id,$type){
            $batch_no='';
            $model = self::model()->findAll(array('condition'=>'header_id IN ('.$header_id.') AND product_id='.$product_id.' AND transaction_type="'.$type.'"'));
            if(!empty($model)){
                foreach ($model as $each){
                    $productlocatin_id = $each->product_location_id;
                    $eachbatch_no=ProductLocationDetails::getBatchNo($productlocatin_id);
                    if($batch_no==''){
                        $batch_no=$eachbatch_no;
                    }else{
                        $batch_no.=' , '.$eachbatch_no;
                    }
                }
            }	
            return $batch_no;
        }
        public static function getBatchNoWithExpDate($header_id=0,$product_id,$type){
            $batch_no='';
            $model = self::model()->findAll(array('condition'=>'header_id IN ('.$header_id.') AND product_id='.$product_id.' AND transaction_type="'.$type.'"','group'=>'t.product_id'));
            if(!empty($model)){
                foreach ($model as $each){
                    $productlocatin_id = $each->product_location_id;
                    $eachbatch_no=ProductLocationDetails::getBatchNoWithExpDate($productlocatin_id);
                    if($batch_no==''){
                        $batch_no=$eachbatch_no;
                    }else{
                        $batch_no.=' , '.$eachbatch_no;
                    }
                }
            }	
            return $batch_no;
        }
        public static function getSerialNo($header_id=0,$product_id,$type){
            $sl_no='';
            $model = self::model()->findAll(array('condition'=>'header_id IN ('.$header_id.') AND product_id='.$product_id.' AND transaction_type="'.$type.'"'));
            if(!empty($model)){
                foreach ($model as $each){
                    $productlocatin_id = $each->product_location_id;
                    $eachsl_no=ProductLocationDetails::getSerialNo($productlocatin_id);
                    if($sl_no==''){
                        $sl_no=$eachsl_no;
                    }else{
                        $sl_no.=' , '.$eachsl_no;
                    }
                }
            }	
            return $sl_no;
        }
}
