<?php

/**
 * This is the model class for table "{{stock_ledger}}".
 *
 * The followings are the available columns in table '{{stock_ledger}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $header_id
 * @property integer $header_item_id
 * @property integer $customer_vendor_id
 * @property string $customer_vendor_name
 * @property integer $product_id
 * @property string $product_name
 * @property string $product_description
 * @property integer $brand_id
 * @property string $brand_name
 * @property integer $warehouse_id
 * @property integer $rack_id
 * @property integer $bin_id
 * @property integer $unit_id
 * @property string $unit_name
 * @property string $quantity
 * @property string $batch_no
 * @property string $serial_no
 * @property string $manufacturing_date
 * @property string $expiry_date
 * @property string $cost_price
 * @property string $sales_price
 * @property string $transaction_date
 * @property string $transaction_from
 * @property string $transaction_type
 * @property integer $created_by
 * @property string $created_date
 */
class StockLedger extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $to_warehouse_id;
	public $to_rack_id;
	public $to_bin_id;

	public $total_value;
	public $product_id;
	public $serial_number;
	public $description;
	public $in_out; // 'IN
	public function tableName()
	{
		return '{{stock_ledger}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_id, header_item_id, product_id, product_name, product_description, brand_id, warehouse_id, rack_id, unit_id, unit_name, quantity, cost_price, sales_price, transaction_date, transaction_from, transaction_type, created_by, created_date', 'required'),
			array('file_id, header_id, customer_vendor_id, product_id, brand_id, warehouse_id, rack_id, bin_id, unit_id, created_by,master_stock_ledger_id,lead_owner_id,location_id', 'numerical', 'integerOnly' => true),
			array('customer_vendor_name, header_item_id, product_name, brand_name, unit_name, batch_no, serial_no, transaction_from,rack_name,bin_name,warehouse_name', 'length', 'max' => 255),
			array('quantity, cost_price, sales_price,unit_factor,batch_date', 'length', 'max' => 15),
			array('transaction_type,available_status', 'length', 'max' => 3),
			array('stock_updated', 'length', 'max' => 1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, file_id, header_id, header_item_id, customer_vendor_id,lead_owner_id,location_id, customer_vendor_name, product_id, product_name, product_description, brand_id, brand_name, warehouse_id, rack_id, bin_id, unit_id, unit_name, quantity, batch_no, serial_no, manufacturing_date, expiry_date, cost_price, sales_price, transaction_date, transaction_from, transaction_type, created_by, created_date', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
			'customer' => array(self::BELONGS_TO, 'Customer', 'customer_vendor_id'),
			'unit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
			'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
			'rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
			'bin' => array(self::BELONGS_TO, 'MasInvBin', 'bin_id'),
			'user' => array(self::BELONGS_TO, 'User', 'created_by'),
			'purchase' => array(self::BELONGS_TO, 'PurchasingMaterialreceipt', 'header_id'),
			'purchaseItem' => array(self::BELONGS_TO, 'PurchasingMaterialreceiptItem', 'header_item_id'),
			'invoice' => array(self::BELONGS_TO, 'Invoice', 'reference_no'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_id' => 'File',
			'header_id' => 'Header',
			'header_item_id' => 'Header Item',
			'customer_vendor_id' => 'Customer Vendor',
			'customer_vendor_name' => 'Customer Vendor Name',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'product_description' => 'Product Description',
			'brand_id' => 'Brand',
			'brand_name' => 'Brand Name',
			'warehouse_id' => 'Warehouse',
			'warehouse_name' => 'Warehouse Name',
			'rack_id' => 'Rack',
			'rack_name' => 'Rack Name',
			'bin_id' => 'Bin',
			'bin_name' => 'Bin Name',
			'warehouse_id' => 'Warehouse',
			'unit_id' => 'Unit',
			'unit_name' => 'Unit Name',
			'quantity' => 'Quantity',
			'batch_no' => 'Batch No',
			'serial_no' => 'Serial No',
			'manufacturing_date' => 'Manufacturing Date',
			'expiry_date' => 'Expiry Date',
			'cost_price' => 'Cost / Item',
			'sales_price' => 'Sales Price',
			'transaction_date' => 'Transaction Date',
			'transaction_from' => 'Transaction From',
			'transaction_type' => 'Transaction Type',
			'stock_updated' => 'Stock Updated',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('file_id', $this->file_id);
		$criteria->compare('header_id', $this->header_id);
		$criteria->compare('header_item_id', $this->header_item_id);
		$criteria->compare('customer_vendor_id', $this->customer_vendor_id);
		$criteria->compare('customer_vendor_name', $this->customer_vendor_name, true);
		$criteria->compare('product_id', $this->product_id);
		$criteria->compare('product_name', $this->product_name, true);
		$criteria->compare('product_description', $this->product_description, true);
		$criteria->compare('brand_id', $this->brand_id);
		$criteria->compare('brand_name', $this->brand_name, true);
		$criteria->compare('warehouse_id', $this->warehouse_id);
		$criteria->compare('rack_id', $this->rack_id);
		$criteria->compare('bin_id', $this->bin_id);
		$criteria->compare('unit_id', $this->unit_id);
		$criteria->compare('unit_name', $this->unit_name, true);
		$criteria->compare('quantity', $this->quantity, true);
		$criteria->compare('batch_no', $this->batch_no, true);
		$criteria->compare('serial_no', $this->serial_no, true);
		$criteria->compare('manufacturing_date', $this->manufacturing_date, true);
		$criteria->compare('expiry_date', $this->expiry_date, true);
		$criteria->compare('cost_price', $this->cost_price, true);
		$criteria->compare('sales_price', $this->sales_price, true);
		$criteria->compare('transaction_date', $this->transaction_date, true);
		$criteria->compare('transaction_from', $this->transaction_from, true);
		$criteria->compare('transaction_type', $this->transaction_type, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_date', $this->created_date, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return StockLedger the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	public static function getBatchNo($header_id = 0, $product_id, $type)
	{
		$batch_no = '';
		$model = self::model()->findAll(array('condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $product_id . ' AND transaction_from="' . $type . '"'));
		if (!empty($model)) {
			foreach ($model as $each) {
				if ($batch_no == '') {
					$batch_no = $each->batch_no;
				} else {
					$batch_no .= ' , ' . $each->batch_no;
				}
			}
		}
		return $batch_no;
	}
	public static function getBatchNoWithExpDate($header_id = 0, $product_id, $type)
	{
		$batch_no = '';
		$model = self::model()->findAll(array('condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $product_id . ' AND transaction_from="' . $type . '"'));
		if (!empty($model)) {
			foreach ($model as $each) {
				if ($batch_no == '') {
					$batch_no = $each->batch_no;
				} else {
					$batch_no .= ' , ' . $each->batch_no;
				}
			}
		}
		return $batch_no;
	}
	public static function getSerialNo($header_id = 0, $product_id, $type)
	{
		$sl_no = '';
		$typeCond = '';
		if ($type) {
			$typeCond = ' AND transaction_from="' . $type . '"';	
		}
		$model = self::model()->findAll(array('condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $product_id . $typeCond));
		if (!empty($model)) {
			foreach ($model as $each) {
				if ($sl_no == '') {
					$sl_no = $each->serial_no;
				} else {
					$sl_no .= ' , ' . $each->serial_no;
				}
			}
		}
		return $sl_no;
	}
	public static function getSerialNumber($id = 0, $product_id, $type)
	{
		$model_creditnote = Creditnote::model()->findbyPK($id);
		$invoice_id = $model_creditnote->invoice_id;
		$model_invoice = Invoice::model()->findbyPK($invoice_id);
		//code added by mereena on 19/03/2020
		if ($model_invoice->is_direct_invoice == 'Y') {
			$header_id = $invoice_id;
			$type = 'DIRECT SALES';
		} else {
			$header_id = $model_invoice->delivery_ids;
		}
		//end
		$product_location_array = array();
		//Getting serial number returned in this credit note
		$model_stck_credit = CreditnoteItem::model()->with('parent')->findAll(array('select' => 'creditnote_id', 'condition' => 'invoice_id="' . $model_creditnote->invoice_id . '" AND product_id="' . $product_id . '"', 'group' => 'creditnote_id'));
		$checked_creditnote_array = array();
		foreach ($model_stck_credit as $key => $value) {
			$checked_creditnote_array[] = $value->creditnote_id;
		}
		$credit_note_id = '';
		if (count($checked_creditnote_array) > 0) {
			$credit_note_id = implode(',', $checked_creditnote_array);
			$model_stck_cdt = self::model()->findAll(array('select' => 'serial_no', 'condition' => 'header_id IN (' . $credit_note_id . ') AND product_id=' . $product_id . ' AND transaction_from="CREDIT_NOTE"'));
			foreach ($model_stck_cdt as $key => $value) {
				$eachsl_no = $value->serial_no;
				if ($eachsl_no != '') {
					$stock_ledger_serial_no_array[] = $eachsl_no;
				}
			}

		}
		$new_pdt_lct_array = array();
		$model = self::model()->findAll(array('select' => 'serial_no', 'condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $product_id . ' AND transaction_from="' . $type . '"'));
		foreach ($model as $key => $value) {
			$eachsl_no = $value->serial_no;
			if ($eachsl_no != '') {
				if (!in_array($eachsl_no, $stock_ledger_serial_no_array)) {
					$new_pdt_lct_array[] = $eachsl_no;
				}
			}
		}
		$serialno_details = array();
		if (!empty($new_pdt_lct_array)) {
			$m = 0;
			foreach ($new_pdt_lct_array as $each) {
				if ($each != '') {
					$serialno_details[$m]['serialno'] = $each;
					$serialno_details[$m]['serial_no'] = $each;
					$m++;
				}
			}
		}
		return CHtml::listData($serialno_details, 'serialno', 'serial_no');
	}
	public static function getcreditnoteSerialNo($header_id = 0, $product_id, $type)
	{
		$sl_no = '';
		$model = self::model()->findAll(array('condition' => 'header_id IN (' . $header_id . ') AND product_id=' . $product_id . ' AND transaction_from="' . $type . '"'));
		if (!empty($model)) {
			foreach ($model as $each) {
				$productlocatin_id = $each->product_location_id;
				$eachsl_no = ProductLocationDetails::getSerialNo($productlocatin_id);
				if ($sl_no == '') {
					$sl_no = $eachsl_no;
				} else {
					$sl_no .= ' , ' . $eachsl_no;
				}
			}
		}
		return $sl_no;
	}
	public static function getPreviousCostPrice($product_id = 0, $vendor_id = 0)
	{

		$condition = 'product_id=' . $product_id . ' AND transaction_type="IN" AND transaction_from="QUALITY_CHECK" AND stock_updated="Y"';
		if ($vendor_id > 0) {
			$condition .= 'customer_vendor_id=' . $vendor_id;
		}
		$model = self::model()->find(array('select' => 'cost_price', 'condition' => $condition, 'order' => 'id DESC'));
		return $model->cost_price;
	}
	public static function getPreviousSalesPrice($product_id = 0, $customer_id = 0)
	{
		$condition = 'product_id=' . $product_id . ' AND transaction_type="OUT"';
		if ($customer_id > 0) {
			$condition .= 'customer_vendor_id=' . $customer_id;
		}
		$model = self::model()->find(array('select' => 'sales_price', 'condition' => $condition, 'order' => 'id DESC'));
		return $model->sales_price;
	}
	public static function update_cost($product_id, $stockLedger_id = 0)
	{
		if ($product_id > 0) {
			$arr_stock_ledger = StockLedger::model()->findAll(array('condition' => 'stock_updated="Y" AND product_id = ' . (int) $product_id, 'order' => 'transaction_date ASC'));
			$cur_qty = 0;
			$cur_value = 0;
			$prev_total = 0;
			foreach ($arr_stock_ledger as $each_ledger) {
				$cur_qty += ($each_ledger->quantity * $each_ledger->unit_factor);
				if ($each_ledger->transaction_from == 'GOODS_RECEIPT' || $each_ledger->transaction_from == 'QUALITY_CHECK') {
					$updatedcost_price = ($prev_total + ($each_ledger->buying_price * $each_ledger->quantity * $each_ledger->unit_factor)) / ($cur_qty);
				}
				$each_ledger->cost_price = $updatedcost_price;
				$cur_value = $updatedcost_price * $cur_qty;
				$each_ledger->save(false);
				$prev_total = $cur_value;
			}
			Store::model()->updateByPk($product_id, array('rate' => $updatedcost_price));

		}
	}

	//******To Update Existing Stockledger with transaction cost*********//    
	public static function UpdateExistingStockLedger($product_id)
	{
		if ($product_id > 0) {
			//echo '<br/>' . 'product_id = ' . $product_id . '<br/>';
			$update_existing = 'N';
			$arr_stock_ledger = StockLedger::model()->findAll(array('condition' => 'product_id = ' . (int) $product_id, 'order' => 't.transaction_date,t.transaction_type,t.id ASC'));
			$cur_qty = 0;
			$cur_value = 0;
			$prev_total = 0;
			$model_settings = new MasCompanySettings();
			$model_settings = $model_settings->find();
			$include_vat = '';
			if (!empty($model_settings)) {
				$include_vat = $model_settings->include_vat;
			}
			foreach ($arr_stock_ledger as $t => $each_ledger) {
				$buying_price = 0;
				$updatedsales_price = 0;
				$transaction_value = 0;
				$trn_qty = 0;
				//echo $t . ' $old_qty = ' . $cur_qty . $each_ledger->transaction_date . '<br/>';
				($each_ledger->unit_factor == 0) ? $each_ledger->unit_factor = 1 : '';
				$unit_factor = $each_ledger->unit_factor;
				//echo ' transaction_from =' . $each_ledger->transaction_from . '<br/>';
				if ($each_ledger->transaction_from == 'GOODS_RECEIPT') {
					$model_receipt = new InventoryGoodsReceiptItem();
					$model_receipt = $model_receipt->findByPK((int) $each_ledger->header_item_id);
					$buying_price = $model_receipt->rate;
					$cost_price = $model_receipt->rate;
					$trn_qty = $model_receipt->picked_qty;
					if ((int) $model_receipt->unit > 0) {
						$unit_factor = ($model_receipt->unitdetails->factor > 0) ? $model_receipt->unitdetails->factor : '1';
					} else {
						$unit_factor = '1';
					}
					$update_existing = 'Y';
					$transaction_cost = $buying_price;
				}
				if ($each_ledger->transaction_from == 'QUALITY_CHECK') {


					$modelMaterialReceiptItem = new PurchasingMaterialreceiptItem();
					$modelMaterialReceiptItem = $modelMaterialReceiptItem->with('parent')->findByPK((int) $each_ledger->header_item_id);
					$trn_qty = $modelMaterialReceiptItem->qc_checked_quantity;
					if ($each_ledger->stock_updated == 'Y') {
						$mod_pI = new PurchasingInvoice();
						$mod_pI = $mod_pI->find(array('condition' => 'materialreceived=' . (int) $each_ledger->header_id));
						if (!empty($mod_pI)) {
							$total_amount = 0;
							$total_quantity = 0;
							$cost_with_variance = 0;
							$date = $mod_pI->invoice_date;
							$total_net_value = $mod_pI->grand_total;
							$total_net_value_wo_add_ded = $mod_pI['netTotal'];
							$total_land_cost = 0;
							$total_net_value_wo_add_ded_with_excha = $total_net_value_wo_add_ded * $mod_pI->exchange_rate;
							$landing_total = 0;
							$landing_percent = 0;
							$footer_value = $mod_pI->adTotal - $mod_pI->dedTotal;

							$model_purchase_item = new PurchasingInvoiceItem();
							$arr_purchase_item = $model_purchase_item->findAll(array('condition' => 'purchasing_invoice_id=' . (int) $mod_pI->id . ' AND product_id=' . (int) $each_ledger->product_id));
							if (count($arr_purchase_item) > 1) {
								$model_purchase_item = $model_purchase_item->find(array('condition' => 'purchasing_invoice_id=' . (int) $mod_pI->id . ' AND product_id=' . (int) $each_ledger->product_id . ' AND quantity=' . $each_ledger->quantity));
							} else {
								$model_purchase_item = $model_purchase_item->find(array('condition' => 'purchasing_invoice_id=' . (int) $mod_pI->id . ' AND product_id=' . (int) $each_ledger->product_id));
							}
							$unit_factor = ($model_purchase_item->unitdetails->factor != 0) ? $model_purchase_item->unitdetails->factor : '1';
							$actual_cost = $model_purchase_item->net_amount * $mod_pI->exchange_rate;
							;
							$actual_cost_percentage = ($total_net_value_wo_add_ded_with_excha > 0) ? $actual_cost / $total_net_value_wo_add_ded_with_excha : 0;
							$actual_cost_percentage = round($actual_cost_percentage, 6);
							$item_footer_value = $actual_cost_percentage * $footer_value;
							$footer_cost = $item_footer_value / $trn_qty;
							$actual_cost_rate = $actual_cost / $trn_qty;
							$transaction_cost = $actual_cost_rate + $footer_cost;
							$buying_price = $actual_cost_rate;

						} else {
							if ((int) $modelMaterialReceiptItem->orderitem_det->stock_item_unit > 0) {
								$unit_factor = ($modelMaterialReceiptItem->orderitem_det->unitdetails->factor != 0) ? $modelMaterialReceiptItem->orderitem_det->unitdetails->factor : '1';
							} else {
								$unit_factor = '1';
							}
							$exchange_rate = $modelMaterialReceiptItem->parent->purchaseorder->exchange_rate;
							$buying_price = ($modelMaterialReceiptItem->rate * $exchange_rate) / $unit_factor;
							$transaction_cost = $buying_price;
						}
					} else {
						if ((int) $modelMaterialReceiptItem->orderitem_det->stock_item_unit > 0) {
							$unit_factor = ($modelMaterialReceiptItem->orderitem_det->unitdetails->factor != 0) ? $modelMaterialReceiptItem->orderitem_det->unitdetails->factor : '1';
						} else {
							$unit_factor = '1';
						}
						$exchange_rate = $modelMaterialReceiptItem->parent->purchaseorder->exchange_rate;
						$buying_price = ($modelMaterialReceiptItem->rate * $exchange_rate) / $unit_factor;
						$transaction_cost = $buying_price;
					}
					$update_existing = 'Y';
				}
				if ($each_ledger->transaction_from == 'OPENING_STOCK') {
					$buying_price = $updatedcost_price;
					$transaction_cost = $updatedcost_price;
					$trn_qty = $each_ledger->quantity;
				}
				if ($each_ledger->transaction_from == 'GOODS_ISSUE') {
					$buying_price = 0;
					$modelGoodsIssueItem = new InventoryGoodsIssueItem();
					$modelGoodsIssueItem = $modelGoodsIssueItem->with('inventorygoodsissue')->findByPK((int) $each_ledger->header_item_id);
					if (!empty($modelGoodsIssueItem)) {
						$update_existing = 'Y';
						$unit_factor = ($modelGoodsIssueItem->uom->factor != 0) ? $modelGoodsIssueItem->uom->factor != 0 : '1';
						$trn_qty = -($modelGoodsIssueItem->picked_qty);
						$updated_sales_price = $modelGoodsIssueItem->rate / $unit_factor;
						$update_existing = 'Y';
					}
					$transaction_cost = $updatedcost_price;
				}
				if ($each_ledger->transaction_from == 'DIRECT_INVOICE') {
					$buying_price = 0;
					$modelInvoiceItem = new InvoiceItem();
					if ((int) $each_ledger->header_item_id > 0) {
						$modelInvoiceItem = $modelInvoiceItem->with('invoice')->findByPK((int) $each_ledger->header_item_id);
					} else {
						$modelInvoiceItem = $modelInvoiceItem->with('invoice')->find(array('condition' => 'invoice_id=' . (int) $each_ledger->header_id . ' AND product_id=' . $each_ledger->product_id));
					}
					if (!empty($modelInvoiceItem)) {
						$trn_qty = -($modelInvoiceItem->quantity);
						$updatedsales_price = 0;
						if ((int) $modelInvoiceItem->unit_id > 0) {
							$unit_factor = ($modelInvoiceItem->invoiceunit->factor != 0) ? $modelInvoiceItem->invoiceunit->factor : 1;
						} else {
							$unit_factor = 1;
						}
						$updatedsales_price = $modelInvoiceItem->rate / $unit_factor;
					}
					$transaction_cost = $updatedcost_price;
				}
				if ($each_ledger->transaction_from == 'DIRECT_TRANSFER_IN') {
					$buying_price = 0;
					$modelInventoryDirectTransferItem = new InventoryDirectTransferItem();
					$modelInventoryDirectTransferItem = $modelInventoryDirectTransferItem->with('parent')->findByPK((int) $each_ledger->header_item_id);
					$transaction_cost = $updatedcost_price;
					if ((int) $modelInventoryDirectTransferItem->unit > 0) {
						$unit_factor = $modelInventoryDirectTransferItem->unitdetails->factor;
					} else {
						$unit_factor = '1';
					}
					$trn_qty = $modelInventoryDirectTransferItem->transfer_qty;
					$update_existing = 'Y';
				}
				if ($each_ledger->transaction_from == 'DIRECT_TRANSFER_OUT') {
					$buying_price = 0;
					$modelInventoryDirectTransferItem = new InventoryDirectTransferItem();
					$modelInventoryDirectTransferItem = $modelInventoryDirectTransferItem->with('parent')->findByPK((int) $each_ledger->header_item_id);
					$transaction_cost = $updatedcost_price;
					if ((int) $modelInventoryDirectTransferItem->unit > 0) {
						$unit_factor = $modelInventoryDirectTransferItem->unitdetails->factor;
					} else {
						$unit_factor = '1';
					}
					$trn_qty = -($modelInventoryDirectTransferItem->transfer_qty);
					$update_existing = 'Y';
				}
				if ($each_ledger->transaction_from == 'CREDIT_NOTE') {
					$buying_price = 0;
					$modelCreditnoteItem = new CreditnoteItem();
					$modelCreditnoteItem = $modelCreditnoteItem->with('parent', 'product')->findByPK((int) $each_ledger->header_item_id);
					if (!empty($modelCreditnoteItem)) {
						if ((int) $modelCreditnoteItem->unit > 0) {
							$unit_factor = $modelCreditnoteItem->orderunit->factor;
						} else {
							$unit_factor = '1';
						}
						$trn_qty = $modelCreditnoteItem->returned_quantity;
						$transaction_cost = 0;
						$updatedsales_price = $modelCreditnoteItem->rate / $unit_factor;
						$update_existing = 'Y';
					}
				}
				if ($each_ledger->transaction_from == 'DEBIT_NOTE') {
					$buying_price = 0;
					$updatedsales_price = 0;
					$update_existing = 'Y';
					if ((int) $each_ledger->unit_factor > 0) {
						$unit_factor = ($each_ledger->unit_factor != 0) ? $each_ledger->unit_factor : '1';
					} else {
						$unit_factor = 1;
					}
					$trn_qty = $each_ledger->quantity * $unit_factor;
					$transaction_cost = 0;
					$updatedsales_price = 0;
					$update_existing = 'Y';
				}
				if ($each_ledger->transaction_from == 'CANCEL_INVOICE') {
					$buying_price = 0;
					$modelInvoiceItem = new InvoiceItem();
					if ((int) $each_ledger->header_item_id > 0) {
						$modelInvoiceItem = $modelInvoiceItem->with('invoice')->findByPK((int) $each_ledger->header_item_id);
					} else {
						$modelInvoiceItem = $modelInvoiceItem->with('invoice')->find(array('condition' => 'invoice_id=' . (int) $each_ledger->header_id . ' AND product_id=' . $each_ledger->product_id));
					}
					if (!empty($modelInvoiceItem)) {
						$trn_qty = +($modelInvoiceItem->quantity);
						$updatedsales_price = 0;
						if ((int) $modelInvoiceItem->unit_id > 0) {
							$unit_factor = ($modelInvoiceItem->invoiceunit->factor != 0) ? $modelInvoiceItem->invoiceunit->factor : 1;
						} else {
							$unit_factor = 1;
						}
						$updatedsales_price = $modelInvoiceItem->rate / $unit_factor;
						$transaction_cost = 0;
					}
					$update_existing = 'Y';
				}
				$cur_qty += ($each_ledger->quantity * $unit_factor);
				$trn_qty = ($each_ledger->quantity * $unit_factor);
				//echo $t . ' $cur_qty = ' . $cur_qty . '<br/>';
				if ($cur_qty < 0) {
					$cur_qty = 0;
				}
				if ($cur_qty != 0 && ($each_ledger->transaction_from == 'GOODS_RECEIPT' || $each_ledger->transaction_from == 'QUALITY_CHECK' || $each_ledger->transaction_from == 'CANCEL_INVOICE' || $each_ledger->transaction_from == 'DEBIT_NOTE' || $each_ledger->transaction_from == 'CREDIT_NOTE')) {
					if ($each_ledger->transaction_from == 'GOODS_RECEIPT' || $each_ledger->transaction_from == 'QUALITY_CHECK') {
						$updatedcost_price = ($prev_total + ($transaction_cost * $each_ledger->quantity * $unit_factor)) / (abs($cur_qty));
					} else if ($each_ledger->transaction_from == 'CREDIT_NOTE' || $each_ledger->transaction_from == 'CANCEL_INVOICE') {
						$updatedcost_price = ($prev_total + ($transaction_cost * $each_ledger->quantity * $unit_factor)) / (abs($cur_qty));
					} else if ($each_ledger->transaction_from == 'DEBIT_NOTE') {
						$updatedcost_price = ($prev_total + ($transaction_cost * $each_ledger->quantity * $unit_factor)) / (abs($cur_qty));
					}
				} else {
					$updatedcost_price = $transaction_cost;
				}
				//echo $each_ledger->transaction_from.' $prev_total = ' . $prev_total . ' $transaction_cost = ' . $transaction_cost . ' $each_ledger->quantity = ' . $trn_qty .' $cur_qty='.$cur_qty. ' $unit_factor = ' . $unit_factor . '<br/>';
				//echo ' $updatedcost_price =' . $updatedcost_price . '<br/>';
				if ($each_ledger->transaction_from == 'GOODS_RECEIPT') {
					$each_ledger->cost_price = $cost_price;
				}

				$each_ledger->buying_price = $buying_price;
				$each_ledger->updated_cost_rate = $updatedcost_price;
				//$each_ledger->updated_sales_price = $updatedsales_price;
				//$each_ledger->transaction_value = $transaction_cost * $trn_qty;
				$cur_value = $updatedcost_price * $cur_qty;
				//$each_ledger->update_existing = $update_existing;
				//$each_ledger->invoice_date = $date;
				$each_ledger->save(false);
				$prev_total = $cur_value;
			}
			Store::model()->updateByPk($product_id, array('rate' => $updatedcost_price));
		}
	}

	public static function getLeadownerMachineSerialnoByleadownerid($product_id = '', $lead_owner_id)
	{
		$serial_no = '';
		// var_dump($product_id);
		// Build condition safely
		$condition = '';
		if (!empty($product_id)) {
			$condition = ' AND L.product_id IN (' . $product_id . ')';
		}
		// echo $condition;
		// Main query
		$serialnqry = '
        SELECT L.serial_no, L.id, L.product_name
        FROM erp_stock_ledger L
        WHERE L.lead_owner_id = ' . (int) $lead_owner_id . '
        AND L.serial_no != ""
        ' . $condition . '
        AND L.location_id = "0"
        AND L.customer_vendor_id = "0"
        AND L.id NOT IN (
            SELECT master_stock_ledger_id
            FROM erp_stock_ledger
            WHERE master_stock_ledger_id <> 0
        )
    ';

		$modelserial = Yii::app()->db->createCommand($serialnqry)->queryAll();

		// Prepare listData with serial_no | product_name
		$formatted = [];
		foreach ($modelserial as $each) {
			$formatted[] = [
				'id' => $each['id'],
				'serial_display' => $each['serial_no'] . ' | ' . $each['product_name'],
			];
		}

		// Return as ID => "serial_no | product_name"
		return CHtml::listData($formatted, 'id', 'serial_display');
	}



	public static function getLeadownerMachineSerialnoByFileId($customer_id, $file_id)
	{
		$serial_no = '';
		$serialnqry = 'SELECT L.serial_no,L.id FROM erp_stock_ledger L where  serial_no!="" AND header_id = ' . $file_id . ' AND L.location_id="0" AND customer_vendor_id =' . $customer_id . ' AND L.id NOT IN (Select master_stock_ledger_id From erp_stock_ledger where master_stock_ledger_id<>0)';
		echo $serialnqry;
		die;
		$modelserial = Yii::app()->db->createCommand($serialnqry)->queryAll();

		//echo$serialnqry;
		foreach ($modelserial as $each) {

			if ($serial_no == '') {
				$serial_no = $each['serial_no'];
			} else {
				$serial_no .= ' , ' . $each['serial_no'];
			}
		}
		var_dump($modelserial);

		return CHtml::listData($modelserial, 'id', 'serial_no');

	}




	public static function getStockLedetgerserialnumberByid($id)
	{
		$serial_no = '';
		$serialnqry = 'SELECT L.serial_no,L.id FROM erp_stock_ledger L where L.id=' . $id . ' AND serial_no!="" AND  L.location_id="0" AND L.id NOT IN (Select master_stock_ledger_id From erp_stock_ledger where master_stock_ledger_id<>0)';

		$modelserial = Yii::app()->db->createCommand($serialnqry)->queryAll();

		//echo$serialnqry;
		foreach ($modelserial as $each) {

			if ($serial_no == '') {
				$serial_no = $each['serial_no'];
			} else {
				$serial_no .= ' , ' . $each['serial_no'];
			}
		}

		return CHtml::listData($modelserial, 'id', 'serial_no');

	}

	public static function getLeadownerMachinebySerialno($id)
	{
		$machinenqry = 'SELECT product_id,product_name FROM erp_stock_ledger L where L.id=' . (int) $id . '';
		$modelmachine = Yii::app()->db->createCommand($machinenqry)->queryAll();
		return CHtml::listData($modelmachine, 'product_id', 'product_name');
	}
		public static function getMachinebySerialno($serial_no)
	{
		$machinenqry = 'SELECT product_id,product_name FROM erp_stock_ledger L where L.serial_no="' . $serial_no . '"';
		$modelmachine = Yii::app()->db->createCommand($machinenqry)->queryAll();
		return CHtml::listData($modelmachine, 'product_id', 'product_name');
	}

}
