<?php

/**
 * This is the model class for table "{{service_mas_customer_machines_item}}".
 *
 * The followings are the available columns in table '{{service_mas_customer_machines_item}}':
 * @property integer $id
 * @property integer $header_id
 * @property integer $customer_id
 * @property integer $type_service
 * @property string $is_active
 * @property integer $stock_ledger_id
 * @property string $serial_no
 * @property integer $machine_id
 * @property string $remarks
 * @property integer $return_stock_ledger_id
 * @property integer $created_by
 * @property integer $created_date_time
 * @property integer $updated_by
 * @property integer $updated_date_time
 */
class ServiceMasCustomerMachinesItem extends CActiveRecord
{

	/**
	 * @return string the associated database table name
	 */

	public $is_active;
	public $type_service;
	public $service_id;
	public function tableName()
	{
		return '{{service_mas_customer_machines_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_id, customer_id, is_active, stock_ledger_id, serial_no, machine_id, remarks', 'required'),
			array('header_id, customer_id, type_service, stock_ledger_id, machine_id, return_stock_ledger_id', 'numerical', 'integerOnly' => true),
			array('is_active', 'length', 'max' => 1),
			array('serial_no', 'length', 'max' => 225),
			array('remarks', 'length', 'max' => 255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, header_id, customer_id, type_service, return_remarks,returned_by,returned_date_time,is_active,customer_shipping_id,location_id,stock_ledger_id, serial_no, machine_id, remarks, return_stock_ledger_id, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'customerlocation' => array(self::BELONGS_TO, 'ServiceCustomerLocation', 'location_id'),
            'machine' => array(self::BELONGS_TO, 'Store', 'machine_id'),
            'parent' => array(self::BELONGS_TO, 'ServiceMasCustomerMachines', 'header_id'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'header_id' => 'Header',
			'customer_id' => 'Customer',
			'type_service' => 'Type Service',
			'is_active' => 'Is Active',
			'stock_ledger_id' => 'Stock Ledger',
			'serial_no' => 'Serial No',
			'machine_id' => 'Machine',
			'remarks' => 'Remarks',
			'return_stock_ledger_id' => 'Return Stock Ledger',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('header_id', $this->header_id);
		$criteria->compare('customer_id', $this->customer_id);
		$criteria->compare('type_service', $this->type_service);
		$criteria->compare('is_active', $this->is_active, true);
		$criteria->compare('stock_ledger_id', $this->stock_ledger_id);
		$criteria->compare('serial_no', $this->serial_no, true);
		$criteria->compare('machine_id', $this->machine_id);
		$criteria->compare('remarks', $this->remarks, true);
		$criteria->compare('return_stock_ledger_id', $this->return_stock_ledger_id);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_date_time', $this->created_date_time);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('updated_date_time', $this->updated_date_time);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ServiceMasCustomerMachinesItem the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
}
