<?php

/**
 * This is the model class for table "{{service_mas_customer_machines}}".
 *
 * The followings are the available columns in table '{{service_mas_customer_machines}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $stock_ledger_id
 * @property string $serial_no
 * @property integer $machine_id
 * @property integer $location_id
 * @property integer $fragrance_id
 * @property string $cost
 * @property integer $main_status
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ServiceMasCustomerMachines extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $machine_name; 
    public $description; 
    public $invoice_id; 
    public $customer_name; 
    public $lead_owner; 
    public $location_name; 

    public function tableName(): string {
        return '{{service_mas_customer_machines}}';
    }

    public $next_service;

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('customer_id,lead_owner_id', 'required'),
            array('customer_id, stock_ledger_id, machine_id, location_id, fragrance_id, main_status, created_by,return_stock_ledger_id, updated_by,customer_shipping_id', 'numerical', 'integerOnly' => true),
            array('serial_no,remarks', 'length', 'max' => 255),
            array('cost', 'length', 'max' => 15),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, customer_id, stock_ledger_id, serial_no, machine_id,issue_type,job_sheet_id,description, customer_shipping_id,location_id, fragrance_id, cost, main_status, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'stockledger' => array(self::BELONGS_TO, 'StockLedger', 'stock_ledger_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'owner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'customerlocation' => array(self::BELONGS_TO, 'ServiceCustomerLocation', 'location_id'),
            'fragrance' => array(self::BELONGS_TO, 'MasFragrance', 'fragrance_id'),
            'store' => array(self::BELONGS_TO, 'Store', 'machine_id'),
            'machine' => array(self::BELONGS_TO, 'Store', 'machine_id'),
            'customer_shiiping' => array(self::BELONGS_TO, 'CustomerOutletLocation', 'customer_shipping_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'masissue_type' => array(self::BELONGS_TO, 'MasIssueType', 'issue_type'),
            'items' => array(self::HAS_MANY, 'service_mas_customer_machines_item', 'header_id'),

        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'customer_id' => 'Customer',
            'stock_ledger_id' => 'Stock Ledger',
            'serial_no' => 'Serial No',
            'machine_id' => 'coming from erp_store',
            'location_id' => 'Location',
            'fragrance_id' => 'Fragrance',
            'cost' => 'Cost',
            'main_status' => 'Main Status',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('stock_ledger_id', $this->stock_ledger_id);
        $criteria->compare('serial_no', $this->serial_no, true);
        $criteria->compare('machine_id', $this->machine_id);
        $criteria->compare('location_id', $this->location_id);
        $criteria->compare('fragrance_id', $this->fragrance_id);
        $criteria->compare('cost', $this->cost, true);
        $criteria->compare('main_status', $this->main_status);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ServiceMasCustomerMachines the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getLeadownerMachinebySerialnumbersonly($machine_id) {
        $serial_no = '';
        $serialnqry = 'SELECT DISTINCT(serial_no) FROM erp_service_mas_customer_machines where machine_id=' . $machine_id;
        $modelserial = Yii::app()->db->createCommand($serialnqry)->queryAll();
        foreach ($modelserial as $each) {
            if ($serial_no == '') {
                $serial_no = $each['serial_no'];
            } else {
                $serial_no .= ' , ' . $each['serial_no'];
            }
        }
        return CHtml::listData($modelserial, 'serial_no', 'serial_no');
    }
}
