<?php

/**
 * This is the model class for table "{{service_customer_location}}".
 *
 * The followings are the available columns in table '{{service_customer_location}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $customer_outlet_location_id
 * @property string $location_name
 * @property string $is_default_location
 */
class ServiceCustomerLocation extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{service_customer_location}}';
    }


    public $customer_outlet_location_id;
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        return array(
            // Required fields
            array('customer_id, customer_outlet_location_id, location_name', 'required'),

            // Data types
            array('customer_id, customer_outlet_location_id', 'numerical', 'integerOnly' => true),

            // Length limits
            array('location_name', 'length', 'max' => 255),
            array('is_default_location', 'length', 'max' => 1),

            // Safe for search
            array('id, customer_id, customer_outlet_location_id, location_name, is_default_location', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        return array(
            // Optional: relation to Outlet
            'outlet' => array(self::BELONGS_TO, 'CustomerOutletLocation', 'customer_outlet_location_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'customer_id' => 'Customer',
            'customer_outlet_location_id' => 'Outlet',
            'location_name' => 'Location Name',
            'is_default_location' => 'Is Default Location',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider
     */
    public function search()
    {
        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('customer_outlet_location_id', $this->customer_outlet_location_id);
        $criteria->compare('location_name', $this->location_name, true);
        $criteria->compare('is_default_location', $this->is_default_location, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return ServiceCustomerLocation the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }


    public static function getLocation($customer_id = 0)
    {
        $condition = '1=1 ';
        if ($customer_id > 0) {
            $condition .= 'AND customer_id=' . $customer_id;
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'location_name'));
        return CHtml::listData($model, 'id', 'location_name');
    }

    public static function getLocationCustomer($id = 0)
    {
        $condition = '1=1 ';
        if ($id > 0) {
            $condition .= 'AND customer_id=' . $id;
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'location_name'));
        return CHtml::listData($model, 'id', 'location_name');
    }

    public static function getDefaultID()
    {
        $condition = 'isActive =  "Y" AND is_default_location="Y"';
        $model = self::model()->find(array('condition' => $condition, 'order' => 'location_name  ASC'));
        return $model->id;
    }

    public static function getAllLocationCustomer()
    {
        $condition = '1=1';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'location_name');
    }

    public static function getLocationCustomerByOutlet($customer_id, $outlet_id)
    {
        if (empty($customer_id) && empty($outlet_id)) {
            return;

        }
        $condition = '1=1 ';
        if ($customer_id > 0) {
            $condition .= 'AND customer_id=' . $customer_id;
        }
        if ($outlet_id > 0) {
            $condition .= ' AND customer_outlet_location_id=' . $outlet_id;
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'location_name'));
        return CHtml::listData($model, 'id', 'location_name');
    }
    public static function getLocationListByMachine($machine_id)
    {
        $criteria = new CDbCriteria;
        $criteria->compare('machine_id', (int) $machine_id);
        $criteria->compare('is_active', 1); // optional filter

        $locations = self::model()->findAll($criteria);

        return CHtml::listData($locations, 'id', 'location_name');
    }

}
