<?php

/**
 * This is the model class for table "{{purchasing_requisitions}}".
 *
 * The followings are the available columns in table '{{purchasing_requisitions}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $crm_user_id
 * @property string $title
 * @property string $note
 * @property string $requisition_date
 * @property string $required_date
 * @property integer $tel_ph
 * status
 * vendor_id
 * @property string $isActive
 */
class PurchasingRequisition extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
public $requisitionunit;
    public function tableName() {
        return '{{purchasing_requisition}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('requisition_date, required_date, isActive, required_date','required'),
            array('crm_user_id', 'numerical', 'integerOnly' => true),
            array('file_title', 'length', 'max' => 255),
            array('isActive,status', 'length', 'max' => 1),
            array('remarks', 'length', 'max' => 5000),
            //array('required_date', 'type', 'type'=>'datetime', 'datetimeFormat'=>'yyyy-MM-dd hh:mm'), 
            // array('required_date', 'CDateValidator'),
            array(
                'required_date',
                'compare',
                'compareAttribute' => 'requisition_date',
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id,file_title,requisition_date, required_date, isActive,status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            //'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'employee' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'stockitems' => array(self::HAS_MANY, 'PurchasingRequisitionStockItem', 'purchasing_requisition_id', 'order' => 'stockitems.id asc'),
            'nonstockitems' => array(self::HAS_MANY, 'PurchasingRequisitionNonStockItem', 'purchasing_requisition_id', 'condition' => 'non_stock_item_name !="" OR non_stock_item_description != "" ','order' => 'nonstockitems.id asc'),
            'requested' => array(self::BELONGS_TO, 'User', 'requested_by'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'file_title' => 'Title',
            'requisition_date' => 'Requisition Date',
            'required_date' => 'Required Date',
            'isActive' => 'Is Active',
            'status' => 'Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */


    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingRequisitions the static model class
     */
    public function getProduct() {
        $product = null;
        foreach ($this->items as $item)
            $product.=$item->description;
        return $product;
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
