<?php

/**
 * This is the model class for table "{{profit_calc_item}}".
 *
 * The followings are the available columns in table '{{profit_calc_item}}':
 * @property integer $id
 * @property integer $profit_calc_id
 * @property integer $product_id
 * @property string $product_part_number
 * @property string $product_description
 * @property string $product_quantity
 * @property string $product_unit
 * @property string $selling_value_per_unit
 * @property string $cost_value_per_unit
 * @property integer $total_selling_value
 * @property integer $total_cost_value
 */
class ProfitCalcItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{profit_calc_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('profit_calc_id, product_id, product_part_number, product_description, product_quantity, product_unit, selling_value_per_unit, cost_value_per_unit, total_selling_value, total_cost_value', 'required'),
			array('profit_calc_id, product_id, total_selling_value, total_cost_value', 'numerical', 'integerOnly'=>true),
			array('product_part_number, product_unit', 'length', 'max'=>255),
			array('product_quantity, selling_value_per_unit, cost_value_per_unit', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, profit_calc_id, product_id, product_part_number, product_description, product_quantity, product_unit, selling_value_per_unit, cost_value_per_unit, total_selling_value, total_cost_value', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'profitCalc' => array(self::BELONGS_TO, 'ProfitCalc', 'profit_calc_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'profit_calc_id' => 'Profit Calc',
			'product_id' => 'Product',
			'product_part_number' => 'Product Part Number',
			'product_description' => 'Product Description',
			'product_quantity' => 'Product Quantity',
			'product_unit' => 'Product Unit',
			'selling_value_per_unit' => 'Selling Value Per Unit',
			'cost_value_per_unit' => 'Cost Value Per Unit',
			'total_selling_value' => 'Total Selling Value',
			'total_cost_value' => 'Total Cost Value',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('profit_calc_id',$this->profit_calc_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_part_number',$this->product_part_number,true);
		$criteria->compare('product_description',$this->product_description,true);
		$criteria->compare('product_quantity',$this->product_quantity,true);
		$criteria->compare('product_unit',$this->product_unit,true);
		$criteria->compare('selling_value_per_unit',$this->selling_value_per_unit,true);
		$criteria->compare('cost_value_per_unit',$this->cost_value_per_unit,true);
		$criteria->compare('total_selling_value',$this->total_selling_value);
		$criteria->compare('total_cost_value',$this->total_cost_value);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProfitCalcItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
