<?php

/**
 * This is the model class for table "{{production_goods_issue_item}}".
 *
 * The followings are the available columns in table '{{production_goods_issue_item}}':
 * @property integer $id
 * @property integer $production_goods_issue_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $description
 * @property double $quantity
 * @property string $unit
 * @property double $picked_qty
 */
class ProductionGoodsIssueItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $remaining_quantity;
	public $allocated_qty;
        public $total_qty;
        public $pickable_quantity;                      
        public function tableName()
	{
		return '{{production_goods_issue_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('description, quantity, unit, picked_qty', 'required'),
			array('production_goods_issue_id, product_id,po_item_id', 'numerical', 'integerOnly'=>true),
			array('product_name, description', 'length', 'max'=>255),
			array('quantity', 'numerical'),
            array('unit', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, production_goods_issue_id, product_id, product_name, description, quantity, unit, picked_qty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'goodsissue' => array(self::BELONGS_TO, 'ProductionGoodsIssue', 'production_goods_issue_id'),
                    'giunit' => array(self::BELONGS_TO, 'Unit', 'unit'),
                    'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'production_goods_issue_id' => 'Production Goods Issue',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'unit' => 'Unit',
			'picked_qty' => 'Picked Quantity'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('production_goods_issue_id',$this->production_goods_issue_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('picked_qty',$this->picked_qty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductionGoodsIssueItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
