<?php

/**
 * This is the model class for table "view_product_location".
 *
 * The followings are the available columns in table 'view_product_location':
 * @property integer $product_id
 * @property integer $warehouse_id
 * @property integer $rack_id
 * @property integer $bin_id
 * @property string $warehouse_name
 * @property string $rack
 * @property string $bin
 * @property string $quantity
 */
class ProductLocation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'view_product_location';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, warehouse_id, rack_id, bin_id', 'required'),
			array('product_id, warehouse_id, rack_id, bin_id', 'numerical', 'integerOnly'=>true),
			array('warehouse_name, rack, bin', 'length', 'max'=>255),
			array('quantity', 'length', 'max'=>37),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('product_id, warehouse_id, rack_id, bin_id, warehouse_name, rack, bin, quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'product_id' => 'Product',
			'warehouse_id' => 'Warehouse',
			'rack_id' => 'Rack',
			'bin_id' => 'Bin',
			'warehouse_name' => 'Warehouse Name',
			'rack' => 'Rack',
			'bin' => 'Bin',
			'quantity' => 'Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('warehouse_id',$this->warehouse_id);
		$criteria->compare('rack_id',$this->rack_id);
		$criteria->compare('bin_id',$this->bin_id);
		$criteria->compare('warehouse_name',$this->warehouse_name,true);
		$criteria->compare('rack',$this->rack,true);
		$criteria->compare('bin',$this->bin,true);
		$criteria->compare('quantity',$this->quantity,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductLocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
