<?php

/**
 * This is the model class for table "{{product_location_change_rackbin}}".
 *
 * The followings are the available columns in table '{{product_location_change_rackbin}}':
 * @property integer $id
 * @property integer $old_pdt_location_id
 * @property integer $product_location_id
 * @property integer $product_id
 * @property string $quantity
 * @property integer $created_by
 * @property string $created_date_time
 */
class ProductHiringChangeRackbin extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{product_hiring_change_rackbin}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('old_pdt_location_id, product_location_id, product_id, created_by, created_date_time', 'required'),
			array('old_pdt_location_id, product_location_id, product_id, created_by', 'numerical', 'integerOnly'=>true),
			array('quantity', 'length', 'max'=>14),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, old_pdt_location_id, product_location_id, product_id, quantity, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'old_pdt_location_id' => 'Old Product Location Primary Key',
			'product_location_id' => 'Product Location',
			'product_id' => 'Product',
			'quantity' => 'Quantity',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('old_pdt_location_id',$this->old_pdt_location_id);
		$criteria->compare('product_location_id',$this->product_location_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductLocationChangeRackbin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
