<?php

/**
 * This is the model class for table "{{price_group_product_relation}}".
 *
 * The followings are the available columns in table '{{price_group_product_relation}}':
 * @property string $id
 * @property string $price_group_id
 * @property string $store_id
 * @property double $rate
 */
class PriceGroupProductRelation extends CActiveRecord {

    public $price_list_file_name;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{pricing_group_product_relation}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('price_list_file_name', 'required'),
            array('rate,pricing_product_class_id,percentage', 'numerical'),
            array('price_group_id, store_id', 'length', 'max' => 20),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, price_group_id, store_id, rate', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'priceGrp' => array(self::BELONGS_TO, 'PricingGroup', 'price_group_id'),
            'productclass' => array(self::BELONGS_TO, 'ProductClass', 'pricing_product_class_id'),
            'store' => array(self::BELONGS_TO, 'Store', 'store_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'price_group_id' => 'Price Group',
            'pricing_product_class_id' => 'Product class',
            'store_id' => 'Store',
            'rate' => 'Rate',
            'price_list_file_name' => 'Upload a price list file'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('price_group_id', $this->price_group_id, true);
        $criteria->compare('store_id', $this->store_id, true);
        $criteria->compare('rate', $this->rate);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function report($id) {
        $criteria = new CDbCriteria;
        $criteria->with = array('priceGrp', 'productclass', 'store');
        $id = Yii::app()->request->getParam('id');
        //if (!(int) Yii::app()->user->havePermissionOn['inventory_price_list_view_internal'])
            $criteria->addCondition('priceGrp.type="S"', 'AND');
            $criteria->addCondition('priceGrp.show_in_price_list="Y"', 'AND');
        $criteria->addCondition('store_id=' . $id, 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'priceGrp.type,priceGrp.pricing_group',
            ),
            'pagination' => false
        ));
    }

    public function pricinggroupreport() {
        $criteria = new CDbCriteria;
        $criteria->with = array('productclass', 'store', 'priceGrp');
        if (!empty($this->pricing_product_class_id))
            $condition[] = 't.pricing_product_class_id="' . $this->pricing_product_class_id . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        $criteria->group='t.store_id';
        /*$criteria->addCondition('       priceGrp.company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        priceGrp.company_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'store.part_number ASC',
            ),
            'pagination' => false
        ));
    }
    public function getpricinglistInternal($id,$id1){
        $items=PriceGroupProductRelation::model()->with('priceGrp')->findAll(array('condition'=>'pricing_product_class_id='.$id.' AND priceGrp.type="I" AND store_id='.$id1));
  foreach($items as $eachitem)
        {
         $result .=$eachitem->rate.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
        //$result .=$eachitem->rate.'     ';
        }
        //$result .=$result.'</td>';
        echo $result;
        
    }
     public function getpricinglistSales($id,$id1){
        $items=PriceGroupProductRelation::model()->with('priceGrp')->findAll(array('condition'=>'pricing_product_class_id='.$id.' AND priceGrp.type <>"I" AND store_id='.$id1));
     foreach($items as $eachitem)
        {
        $result .=$eachitem->rate.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
       // $result .=$eachitem->rate.'      ';
        }
        //$result .=$result.'</td>';
        echo $result;
        
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PriceGroupProductRelation the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
