<?php

/**
 * This is the model class for table "{{order_material_usage}}".
 *
 * The followings are the available columns in table '{{order_material_usage}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $product_id
 * @property string $description
 * @property string $quantity
 * @property integer $unit_id
 * @property string $rate
 * @property string $used_date
 * @property string $start_time
 * @property string $end_time
 * @property string $add_hrs
 * @property string $ded_hrs
 * @property string $net_hrs
 * @property string $invoiced
 * @property string $amount
 * @property string $addition_percentage
 * @property string $addition_amount
 * @property string $deduction_percentage
 * @property string $deduction_amount
 * @property string $tax_vat_percentage
 * @property string $tax_vat_amount
 * @property string $net_amount
 * @property string $actual_cost_rate
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class OrderMaterialUsage extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $product_name;
        public $unit;
        public $unit_id;
        public $item_qty;
        public $countval;
        public $overtime;
        public $usd_date;
	public function tableName()
	{
		return '{{order_material_usage}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, product_id, description, quantity, unit_id, rate, used_date', 'required'),
			array('order_id, product_id, unit_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, tax_vat_percentage, tax_vat_amount, net_amount, actual_cost_rate', 'length', 'max'=>15),
			array('invoiced', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, order_id, product_id, description, quantity, unit_id, rate, used_date, start_time, end_time, add_hrs, ded_hrs, net_hrs, invoiced, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, tax_vat_percentage, tax_vat_amount, net_amount, actual_cost_rate, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'usageorder' => array(self::BELONGS_TO, 'Order', 'order_id'),
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'product_id' => 'Product',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'unit_id' => 'Unit',
			'rate' => 'Rate',
			'used_date' => 'Used Date',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
			'add_hrs' => 'Add Hrs',
			'ded_hrs' => 'Ded Hrs',
			'net_hrs' => 'Net Hrs',
			'invoiced' => 'Invoiced',
			'amount' => 'Amount',
			'addition_percentage' => 'Addition Percentage',
			'addition_amount' => 'Addition Amount',
			'deduction_percentage' => 'Deduction Percentage',
			'deduction_amount' => 'Deduction Amount',
			'tax_vat_percentage' => 'Tax Vat Percentage',
			'tax_vat_amount' => 'Tax Vat Amount',
			'net_amount' => 'Net Amount',
			'actual_cost_rate' => 'Actual Cost Rate',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('used_date',$this->used_date,true);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);
		$criteria->compare('add_hrs',$this->add_hrs,true);
		$criteria->compare('ded_hrs',$this->ded_hrs,true);
		$criteria->compare('net_hrs',$this->net_hrs,true);
		$criteria->compare('invoiced',$this->invoiced,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('addition_percentage',$this->addition_percentage,true);
		$criteria->compare('addition_amount',$this->addition_amount,true);
		$criteria->compare('deduction_percentage',$this->deduction_percentage,true);
		$criteria->compare('deduction_amount',$this->deduction_amount,true);
		$criteria->compare('tax_vat_percentage',$this->tax_vat_percentage,true);
		$criteria->compare('tax_vat_amount',$this->tax_vat_amount,true);
		$criteria->compare('net_amount',$this->net_amount,true);
		$criteria->compare('actual_cost_rate',$this->actual_cost_rate,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OrderMaterialUsage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
