<?php

/**
 * This is the model class for table "{{mas_notification}}".
 *
 * The followings are the available columns in table '{{mas_notification}}':
 * @property integer $id
 * @property string $event_id
 * @property string $mail_required
 * @property string $mail_users
 * @property string $mail_cc
 * @property string $sms_required
 * @property string $sms_users
 * @property string $sms_mobile_number_cc
 * @property string $notification_required
 * @property string $notification_users
 * @property string $mail_content
 */
class Notification extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_notification}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_id', 'required'),
                        array('event_id', 'unique','message' => '{attribute} already exist!', ),
			array('mail_required, sms_required, notification_required', 'length', 'max'=>1),
			array('mail_users, sms_users, notification_users', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, event_id, mail_required, mail_users, mail_cc, sms_required, sms_users, sms_mobile_number_cc, notification_required, notification_users, mail_content', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'events' => array(self::BELONGS_TO, 'MailEvents', 'event_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'event_id' => 'Event Name',
			'mail_required' => 'Mail Required',
			'mail_users' => 'Mail Users',
			'mail_cc' => 'Mail Cc',
			'sms_required' => 'Sms Required',
			'sms_users' => 'Sms Users',
			'sms_mobile_number_cc' => 'Sms Mobile Number Cc',
			'notification_required' => 'Notification Required',
			'notification_users' => 'Notification Users',
			'mail_content' => 'Mail Content',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('event_id',$this->event_id,true);
		$criteria->compare('mail_required',$this->mail_required,true);
		$criteria->compare('mail_users',$this->mail_users,true);
		$criteria->compare('mail_cc',$this->mail_cc,true);
		$criteria->compare('sms_required',$this->sms_required,true);
		$criteria->compare('sms_users',$this->sms_users,true);
		$criteria->compare('sms_mobile_number_cc',$this->sms_mobile_number_cc,true);
		$criteria->compare('notification_required',$this->notification_required,true);
		$criteria->compare('notification_users',$this->notification_users,true);
		$criteria->compare('mail_content',$this->mail_content,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Notification the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
