<?php

/**
 * This is the model class for table "{{inventory_mtom_transfer_details}}".
 *
 * The followings are the available columns in table '{{inventory_mtom_transfer_details}}':
 * @property integer $id
 * @property integer $mtom_table_id
 * @property integer $from_material_receipt_stock_id
 * @property integer $from_product_id
 * @property integer $previous_qty
 * @property integer $picked_qty
 * @property integer $to_product_id
 * @property integer $new_warehouse_id
 * @property integer $new_rack_id
 * @property integer $new_bin_id
 * @property integer $new_qty
 */
class MtomTransferDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_mtom_transfer_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mtom_table_id, from_material_receipt_stock_id, from_product_id, previous_qty, picked_qty, to_product_id, new_warehouse_id, new_rack_id, new_bin_id, new_qty', 'required'),
			array('mtom_table_id, from_material_receipt_stock_id, from_product_id, previous_qty, picked_qty, to_product_id, new_warehouse_id, new_rack_id, new_bin_id, new_qty', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, mtom_table_id, from_material_receipt_stock_id, from_product_id, previous_qty, picked_qty, to_product_id, new_warehouse_id, new_rack_id, new_bin_id, new_qty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'fromproduct' => array(self::BELONGS_TO, 'Store', 'from_product_id'),
			'toproduct' => array(self::BELONGS_TO, 'Store', 'to_product_id'),
			'materialreceipt' => array(self::BELONGS_TO, 'MaterialReceiptStockDetails', 'from_material_receipt_stock_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'mtom_table_id' => 'Mtom Table',
			'from_material_receipt_stock_id' => 'From Material Receipt Stock',
			'from_product_id' => 'From Product',
			'previous_qty' => 'Previous Qty',
			'picked_qty' => 'Picked Qty',
			'to_product_id' => 'To Product',
			'new_warehouse_id' => 'New Warehouse',
			'new_rack_id' => 'New Rack',
			'new_bin_id' => 'New Bin',
			'new_qty' => 'New Qty',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('mtom_table_id',$this->mtom_table_id);
		$criteria->compare('from_material_receipt_stock_id',$this->from_material_receipt_stock_id);
		$criteria->compare('from_product_id',$this->from_product_id);
		$criteria->compare('previous_qty',$this->previous_qty);
		$criteria->compare('picked_qty',$this->picked_qty);
		$criteria->compare('to_product_id',$this->to_product_id);
		$criteria->compare('new_warehouse_id',$this->new_warehouse_id);
		$criteria->compare('new_rack_id',$this->new_rack_id);
		$criteria->compare('new_bin_id',$this->new_bin_id);
		$criteria->compare('new_qty',$this->new_qty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MtomTransferDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
