<?php

/**
 * This is the model class for table "{{models}}".
 *
 * The followings are the available columns in table '{{models}}':
 * @property integer $id
 * @property string $name
 * @property string $isActive
 */
class Models extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{models}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, isActive', 'required'),
            array('name', 'length', 'max' => 200),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Models the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getModels() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'name'));
        return CHtml::listData($model, 'id', 'name');
    }

    public static function ModelAfterSave($model) {
//        $class_name = get_class($model);
        //   echo '<pre>';
        $class_name = get_class($model);
        $cond = "model.name LIKE '{$class_name}'  AND t.isActive = 'Y' ";
        $eventModels = NotificationEvents::model()->with('model')->findAll([
            "condition" => $cond
                ]
        );
        foreach ($eventModels as $eachModel) {
            $eachModel->evenTriggered() ;
            if ($eachModel->type_id == 1) { // CRUD
//                1 => "Create",
//                2 => "Update",
//                3 => "Delete"
                $scenario = $model->scenario;
                if (($eachModel->curd_event_id == 1) && ( $scenario == "insert")) {
                    
                } else if (($eachModel->curd_event_id == 2) && ( $scenario == "update")){
                    
                } else if ($eachModel->curd_event_id == 3) {
                    
                }
            } else if ($eachModel->type_id == 2) { // on value changes
                
            }
        }
    }
    

}
