<?php

/**
 * This is the model class for table "{{messaging}}".
 *
 * The followings are the available columns in table '{{messaging}}':
 * @property string $id
 * @property integer $message_from
 * @property string $send_datetime
 * @property string $comments
 * @property string $type
 * @property string $order_id
 * @property integer $message_to
 * @property string $received_datetime
 */
class Messaging extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{messaging}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('message_from, send_datetime, comments, type', 'required'),
			array('message_from, message_to', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>2),
			array('order_id', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, message_from, send_datetime, comments, type, order_id, message_to, received_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'user_id' => array(self::BELONGS_TO, 'User', 'message_to'),
		      'user_from' => array(self::BELONGS_TO, 'User', 'message_from'),
		    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'message_from' => 'Message From',
			'send_datetime' => 'Send Datetime',
			'comments' => 'Comments',
			'type' => 'Type',
			'order_id' => 'Order No',
			'message_to' => 'Message To',
			'received_datetime' => 'Received Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('message_from',$this->message_from);
		$criteria->compare('send_datetime',$this->send_datetime,true);
		$criteria->compare('comments',$this->comments,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('order_id',$this->order_id,true);
		$criteria->compare('message_to',$this->message_to);
		$criteria->compare('received_datetime',$this->received_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Messaging the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
