<?php

/**
 * This is the model class for table "{{meeting_transaction}}".
 *
 * The followings are the available columns in table '{{meeting_transaction}}':
 * @property integer $id
 * @property integer $meeting_id
 * @property string $serial_no
 * @property string $heading
 * @property string $meeting_details
 * @property string $closing_date
 * @property string $complete_status
 * @property integer $person
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $action_taken 
 */
class MeetingTransaction extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{meeting_transaction}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('meeting_id, serial_no, created_by, created_date_time, updated_by, updated_date_time', 'required'),
            array('action_taken,closed_on', 'required', 'on' => 'closing'),
            array('meeting_id, person, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('serial_no', 'length', 'max' => 255),
            array('heading, action_taken, meeting_details', 'length', 'max' => 5000),
            array('complete_status', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, meeting_id, action_taken, serial_no, heading, meeting_details, closing_date, complete_status, person, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'meeting' => array(self::BELONGS_TO, 'Meeting', 'meeting_id'),
            'employee' => array(self::BELONGS_TO, 'Employee', 'person')
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'meeting_id' => 'Meeting',
            'serial_no' => 'Serial No',
            'heading' => 'Heading',
            'meeting_details' => 'Meeting Details',
            'closing_date' => 'Closing Date',
            'complete_status' => 'Complete Status',
            'person' => 'Person',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('meeting_id', $this->meeting_id);
        $criteria->compare('serial_no', $this->serial_no, true);
        $criteria->compare('heading', $this->heading, true);
        $criteria->compare('meeting_details', $this->meeting_details, true);
        $criteria->compare('closing_date', $this->closing_date, true);
        $criteria->compare('complete_status', $this->complete_status, true);
        $criteria->compare('person', $this->person);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MeetingTransaction the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function afterFind() {
        if ($this->complete_status == 3) {
            $this->closed_on = date('d/m/Y H:i:s', strtotime($this->closed_on));
            //code
        }

        parent::afterFind();
    }

    public function getclosed_at() {
        $_closed_at = "-";
        if ($this->complete_status == 3 && $this->closed_on != "0000-00-00") {
            $_closed_at = date("d/m/Y", strtotime($this->closed_on));
        }
        return $_closed_at;
    }

    public function getshortDeatils() {
        $temp = $this->meeting_details;
        if (strlen($this->meeting_details) > 50) {
            $temp = substr($temp, 0, 47) . "...";
        }
        return $temp;
    }

    public function getstortActionTaken() {
        $temp = $this->action_taken;
        if (strlen($this->action_taken) > 50) {
            $temp = substr($temp, 0, 47) . "...";
        }
        return $temp;
    }

    public function getPersonName() {
        if ($this->person == 0) {
            $other_array = json_decode($this->meeting->others);
            $_name = "";
            foreach ($other_array as $value) {
                if ($value->email == $this->other_email) {
                    $_name = $value->name;
                    break;
                }
            }
            return $_name;
        } else {
            return $this->employee->name;
        }
    }



}
