<?php

/**
 * This is the model class for table "{{meeting}}".
 *
 * The followings are the available columns in table '{{meeting}}':
 * @property integer $id
 * @property string $type
 * @property integer $country_id
 * @property integer $location_id
 * @property string $meeting_date
 * @property string $meeting_time
 * @property string $meeting_title
 * @property string $conducted_by
 * @property string $attendees
 *  @property string $notify 
 *  @property string $filename
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Meeting extends CActiveRecord {

    public $fileinput;
    public $other_name;
    public $other_email;
    public $emp_group;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{meeting}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type_id, country_id,  meeting_date, meeting_time, meeting_title', 'required'),
            array(' created_by, type_id, updated_by', 'numerical', 'integerOnly' => true),
            array('venue, meeting_title, emp_group, others, isMeeting', 'length', 'max' => 500),
            array('conducted_by,country_id,  location_id,attendees', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, type, country_id, location_id, meeting_date, notify,meeting_time, meeting_title, conducted_by, attendees, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'user' => array(self::BELONGS_TO, 'User', 'created_by'),
            'country' => array(self::BELONGS_TO, 'MasCountry', 'country_id'),
            'location' => array(self::BELONGS_TO, 'MasLocations', 'location_id'),
            'agenda' => array(self::HAS_MANY, 'MeetingTransaction', 'meeting_id'),
            'types' => array(self::BELONGS_TO, 'MeetingType', 'type_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'type' => 'Type',
            'country_id' => 'Country',
            'location_id' => 'Location',
            'meeting_date' => 'Meeting Date',
            'meeting_time' => 'Meeting Time',
            'meeting_title' => 'Meeting Title',
            'conducted_by' => 'Conducted By',
            'attendees' => 'Attendees',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('type', $this->type, true);
        $criteria->compare('country_id', $this->country_id);
        $criteria->compare('location_id', $this->location_id);
        $criteria->compare('meeting_date', $this->meeting_date, true);
        $criteria->compare('meeting_time', $this->meeting_time, true);
        $criteria->compare('meeting_title', $this->meeting_title, true);
        $criteria->compare('conducted_by', $this->conducted_by, true);
        $criteria->compare('attendees', $this->attendees, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Meeting the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getCompleted() {
        $completed = 0;
        $toatal = 0;
        if (!empty($this->id)) {
            foreach ($this->agenda as $each) {
                $toatal++;
                if ($each->complete_status == 3) {
                    $completed++;
                }
            }
        }
        return "{$completed}/{$toatal}";
    }

    public function getCompleted_num() {
        $completed = 0;
        $toatal = 0;
        if (!empty($this->id)) {
            foreach ($this->agenda as $each) {
                $toatal++;
                if ($each->complete_status == 3) {
                    $completed++;
                }
            }
        }

        return $completed;
    }

    public function gettype() {
        $_type = "";
        if (!empty($this->type_id)) {
            $_type = $this->types->type_name;
        }
        return $_type;
    }

    public function isOwner($emp_id, $user_id) {
        $_isOwner = ($this->created_by == $user_id );
        if (!$_isOwner) {
            $conducted = explode(",", $this->conducted_by);
            $_isOwner = in_array($emp_id, $conducted);
        }
        return $_isOwner;
    }

    public function gethost() {
        $host = "-";
        $host_num = 0;
        if (!empty($this->conducted_by)) {
            $condition = "id in ($this->conducted_by)";
            $emp = Employee::model()->findAll(['condition' => $condition, 'order' => 'first_name']);
            if (!empty($emp)) {
                $host_num = count($emp);
                $host = $emp[0]->name;
                if ($host_num > 1) {
                    $host_num --;
                    $host .= ",<span style='color:grey'>{$host_num} more...</span>";
                }
            }
        }
        return $host;
    }

    public function getCategory() {
        $_category = ($this->isMeeting == "Y" ) ? "Meeting" : "Action List";
        return $_category;
    }

    public function getIsDue() {
        $isDue = false;
        $today = date('Y-m-d');
        $condition = " t.closing_date <='{$today}' AND complete_status = 2  AND meeting_id = {$this->id}";
        $models = MeetingTransaction::model()->findAll([
            'condition' => $condition
        ]);
        $isDue = count($models) > 0;
        return $isDue;
    }

}
