<?php

class MasbilltypeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveBilltype', 'BlockMasbilltype','UnBlockMasbilltype'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasBillType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'bill_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (bill_type LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
                if(isset(Yii::app()->user->havePermissionOn['mas_bill_type_edit']) ||  Yii::app()->user->authorised_user == 1)
                {
                    $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Masbilltype/create&id=' . $row['id'] . '\',\'Edit Billtype\',\'lg\')"><i class="fa fa-pencil"></i></button>';             

                }
                if(isset(Yii::app()->user->havePermissionOn['mas_bill_type_disable']) ||  Yii::app()->user->authorised_user == 1)
                {

                  if ($row->isActive == "Y") 
                  {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableMasbilltype(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                  }
                  if ($row->isActive == 'N') 
                  {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableMasbilltype(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                  }            
                
                }
           
            $rowData[] = array($m,
                $row['bill_type'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                $row['isActive'],
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasBillType();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('bill_type_form', array('model' => $model), false, false);
    }

    public function actionSaveBilltype() {
        $model = new MasBillType();
        if (isset($_POST['MasBillType'])) {
            
            if ((int) @$_POST['MasBillType']['id'] > 0) {
                
                $id = (int) @$_POST['MasBillType']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasBillType'];
            $model->bill_type = $_POST['MasBillType']['bill_type'];
            if ($model->save()) {
                // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'BILL_TYPE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with type : - {$_POST['MasBillType']['bill_type']}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['bill_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionBlockMasbilltype() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasBillType::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new MasBillType();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'BILL_TYPE',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with type: - {$upt->bill_type}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockMasbilltype() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasBillType::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasBillType();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'BILL_TYPE',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with type: - {$upt->bill_type}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

   
}
