<?php

/**
 * This is the model class for table "{{mas_inv_unit}}".
 *
 * The followings are the available columns in table '{{mas_inv_unit}}':
 * @property integer $id
 * @property string $unit
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property InventoryItems[] $inventoryItems
 */
class MasSetting extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_setting}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('min_profit_percent', 'required'),
            array('min_profit_percent', 'in','range'=>range(0,100),'message'=>'Value must be between 0-100'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, decimal_value,min_profit_percent, isActive,created_by,updated_by,created_datetime,updated_datetime,min_profit_percent', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'decimal_value' => 'Decimal Value',
            'min_profit_percent' => 'Minimum Profit Perceentage',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('decimal_value', $this->decimal_value, true);
        $criteria->compare('min_profit_percent', $this->min_profit_percent, true);
        $criteria->compare('isActive', $this->isActive, true);
        //$criteria->compare('company_id', Yii::app()->user->master_user_company_id, true);
        //$criteria->compare('company_branch_id', Yii::app()->user->master_user_branch_id, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasInvUnit the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getDecimalValue() {

        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'decimal_value');
    }

}
