<?php

/**
 * This is the model class for table "{{mas_project_2}}".
 *
 * The followings are the available columns in table '{{mas_project_2}}':
 * @property integer $id
 * @property integer $master1_id
 * @property string $master2_name
 * @property string $isActive
 * @property string $is_base_master
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class MasProject2 extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_project_2}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('master1_id, master2_name,is_base_master', 'required'),
			array('master1_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('master2_name', 'length', 'max'=>100),
			array('isActive, is_base_master', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, master1_id, master2_name, isActive, is_base_master, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mas_projcet1_det' => array(self::BELONGS_TO, 'MasProject1', 'master1_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'master1_id' => 'Master1',
			'master2_name' => 'Master2 Name',
			'isActive' => 'Is Active',
			'is_base_master' => 'Is Base Master',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('master1_id',$this->master1_id);
		$criteria->compare('master2_name',$this->master2_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('is_base_master',$this->is_base_master,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasProject2 the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}


	public static function getMaster2list() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" ';
    	$model = self::model()->findAll(array('condition' => $condition,'order'=>'master2_name ASC'));
        return CHtml::listData($model, 'id', 'master2_name');
    }
    
    public static function getMaster2listDropdwn( $id = 0 ) {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" AND master1_id=' . $id;
    	$model = self::model()->findAll(array('condition' => $condition,'order'=>'master2_name ASC'));
        return CHtml::listData($model, 'id', 'master2_name');
    }
    
    public static function getMaster2Wise( $id = 0 ) {
        $returnArray = array();
        if( (int) $id > 0 ){
            $condition = 'isActive =  "Y" AND master1_id='.$id;
            $model = self::model()->findAll(array('condition' => $condition));
            $returnArray =  CHtml::listData($model, 'id', 'master2_name');
        }
        return $returnArray;
    }

	public static function getMaster2TypeWise( $type = 0 ) {
        $returnArray = array();
        if( (int) $type > 0 ){
            $condition = 't.isActive =  "Y" AND mas_projcet1_det.master_type='.$type;
            $model = self::model()->with('mas_projcet1_det')->findAll(array('condition' => $condition));
            $returnArray =  CHtml::listData($model, 'id', 'master2_name');
        }
        return $returnArray;
    }
	public static function getMaster2Name($type1=0,$type2=0) {
		$typename= "";
		if($type1>0 && $type2>0)
		{ 
        $condition = 't.isActive =  "Y" AND mas_projcet1_det.master_type= '.$type1.'  AND t.master_type= '.$type2;
        $model = self::model()->with('mas_projcet1_det')->find(array('condition' => $condition));
        $typename =  $model->master2_name;
		}
		return $typename;
    }
}
