<?php

/**
 * This is the model class for table "{{mas_probability}}".
 *
 * The followings are the available columns in table '{{mas_probability}}':
 * @property integer $id
 * @property string $probability
 * @property string $isActive
 */
class MasProbability extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_probability}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('probability', 'required'),
            array('probability', 'unique'),
            array('probability', 'filter', 'filter'=>'trim'),
            array('probability', 'length', 'max' => 255),
            array('', 'length', 'max' => 255),
             array('probability', 'numerical'),
            //array('probability', 'unique', 'on' => 'add'),
            array('isActive,isDefault', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, probability, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'probability' => 'Probability',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */

        public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('probablity'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('probability like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.probability ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasProbability the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getProbability() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'probability ASC'));
        return CHtml::listData($model, 'probability', 'probability');
    }
    public static function getFilledProbabilityName($id) {
        $model = self::model()->findByPk($id);
        return $model->probability;
    }

    public static function getDefault(){
        return self::model()->find( array( 'condition' => 'isDefault="Y"' ) )->probability;
    }

    public static function getDefaultSalesGroupId() {
        $condition = 'isActive =  "Y" AND isDefault="Y"';
    	$model = self::model()->find(array('condition' => $condition,'order'=>'probability  ASC'));
        return $model->id;
    }
}
