<?php


/**

 * This is the model class for table "{{mas_inv_warehouse}}".

 *

 * The followings are the available columns in table '{{mas_inv_warehouse}}':

 * @property integer $id
 * @property string $warehouse_name
 * @property string $isActive
 * @property string $isBaseWareHouse
 * @property integer $start_series_no
 * @property integer $current_series_no
 * @property string $warehouse_code
 * @property integer $handled_by
 * @property string $warehouse_password
 * @property string $notes
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */

class MasInventoryWarehouse extends CActiveRecord
{

	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{mas_inv_warehouse}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('warehouse_name', 'required'),
			array('start_series_no, current_series_no, handled_by, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('warehouse_name, warehouse_code, warehouse_password', 'length', 'max'=>255),
			array('isActive, isBaseWareHouse', 'length', 'max'=>1),
			// The following rule is used by search().

			// @todo Please remove those attributes that should not be searched.

			array('warehouse_name, isActive, isBaseWareHouse, start_series_no, current_series_no, warehouse_code, handled_by, warehouse_password, notes, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			
			'warehouse_name' => 'Warehouse Name',
			'isActive' => 'Is Active',
			'isBaseWareHouse' => 'Is Base Ware House',
			'start_series_no' => 'Start Series No',
			'current_series_no' => 'Current Series No',
			'warehouse_code' => 'Warehouse Code',
			'handled_by' => 'Handled By',
			'warehouse_password' => 'Warehouse Password',
			'notes' => 'Notes',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 *

	 * Typical usecase:

	 * - Initialize the model fields with values from filter form.

	 * - Execute this method to get CActiveDataProvider instance which will filter

	 * models according to data in model fields.

	 * - Pass data provider to CGridView, CListView or any similar widget.

	 *

	 * @return CActiveDataProvider the data provider that can return the models

	 * based on the search/filter conditions.

	 */

	public function search()

	{

		// @todo Please modify the following code to remove attributes that should not be searched.



		$criteria=new CDbCriteria;



		
		$criteria->compare('warehouse_name',$this->warehouse_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('isBaseWareHouse',$this->isBaseWareHouse,true);
		$criteria->compare('start_series_no',$this->start_series_no);
		$criteria->compare('current_series_no',$this->current_series_no);
		$criteria->compare('warehouse_code',$this->warehouse_code,true);
		$criteria->compare('handled_by',$this->handled_by);
		$criteria->compare('warehouse_password',$this->warehouse_password,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);


		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

     public static function getWarehouses() {
        $condition = 'isActive =  "Y" AND warehouse_code!="DAM"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'warehouse_name ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }
      
     public static function getToWarehouses($id) {
        $condition = 'isActive =  "Y" and id !='.$id;
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'warehouse_name ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }
     public static function getWarehouse() {
        $condition = 'isActive =  "Y" AND warehouse_code!="HIR"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'isBaseWareHouse ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }

     public static function getDefaultWarehouse() {
     	$condition = 'isActive =  "Y" AND isBaseWareHouse="Y" AND warehouse_code!="HIR"';
     	$model = self::model()->find(array('condition' => $condition));
     	return $model;
     }
     public static function getHiringWarehouse() {
        $condition = 'isActive =  "Y" AND warehouse_code="HIR"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'isBaseWareHouse ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }
    public static function getHiringWarehousewithoutdamage() {
        $condition = 'isActive =  "Y" AND warehouse_code="HIR" AND warehouse_code!="DAM"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'isBaseWareHouse ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
     }

	/**

	 * Returns the static model of the specified AR class.

	 * Please note that you should have this exact method in all your CActiveRecord descendants!

	 * @param string $className active record class name.

	 * @return MasInventoryWarehouse the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}
	public static function getUserWarehousees() {
        $condition = 'isActive =  "Y" ';
        $warehouse_id = (int)Yii::app()->user->getState('user_warehouse_id');

        if((int)Yii::app()->user->authorised_user !=1 && $warehouse_id>0){
            $condition .= 'AND id='.(int)$warehouse_id;
        }
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'warehouse_name asc'));
        return CHtml::listData($model, 'id', 'warehouse_name');
    }
    public static function getWarehouseName($id){
	    $model = self::model()->findByPk($id);
	    return $model->warehouse_name;
	}
}

