<?php



/**

 * This is the model class for table "{{purchasing_invoice_addition}}".

 *

 * The followings are the available columns in table '{{purchasing_invoice_addition}}':

 * @property integer $id

 * @property string $inco_name
 * @property string $created_datetime
 * @property string $updated_date_time
 * @property string $isActive
 * @property string $isDefault

 */

class MasIncoTerms extends CActiveRecord
{

	public $particularcheck;

	/**

				 * @return string the associated database table name

				 */

	public function tableName()
	{

		return '{{mas_inco_term}}';

	}



	/**

				 * @return array validation rules for model attributes.

				 */

	public function rules()
	{
		return array(
			array('inco_name', 'required'),
			array('inco_name', 'unique', 'message' => 'This Inco Name already exists.'),
			array('created_by, updated_by', 'numerical', 'integerOnly' => true),
			array('inco_name', 'length', 'max' => 225),
			array('isDefault, isActive', 'in', 'range' => array('Y', 'N')),
			array('created_datetime, updated_date_time', 'safe'),

			// For search scenario
			array('id, inco_name, isDefault, isActive, created_by, created_datetime, updated_by, updated_date_time', 'safe', 'on' => 'search'),
		);
	}



	/**

				 * @return array relational rules.

				 */

	public function relations()
	{



	}



	/**

				 * @return array customized attribute labels (name=>label)

				 */

	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'inco_name' => 'Inco Name',
			'isDefault' => 'Is Default',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Datetime',
		);
	}




	/**

				 * Retrieves a list of models based on the current search/filter conditions.

				 *

				 * Typical usecase:

				 * - Initialize the model fields with values from filter form.

				 * - Execute this method to get CActiveDataProvider instance which will filter

				 * models according to data in model fields.

				 * - Pass data provider to CGridView, CListView or any similar widget.

				 *

				 * @return CActiveDataProvider the data provider that can return the models

				 * based on the search/filter conditions.

				 */

	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('inco_name', $this->inco_name, true);
		$criteria->compare('isDefault', $this->isDefault, true);
		$criteria->compare('isActive', $this->isActive, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_datetime', $this->created_datetime, true);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('updated_date_time', $this->updated_date_time, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}



	/**

				 * Returns the static model of the specified AR class.

				 * Please note that you should have this exact method in all your CActiveRecord descendants!

				 * @param string $className active record class name.

				 * @return PurchasingInvoiceAddition the static model class

				 */

	public static function model($className = __CLASS__)
	{

		return parent::model($className);

	}

	public static function getIncoTerms()
	{
		$condition = 'isActive= "Y"';

		$model = self::model()->findAll(array('condition' => $condition, 'order' => 'inco_name'));
		return CHtml::listData($model, 'id', 'inco_name');
	}

}
