<?php

/**
 * This is the model class for table "{{mas_emirates_list}}".
 *
 * The followings are the available columns in table '{{mas_emirates_list}}':
 * @property integer $id
 * @property string $currency
 * @property string $currency_code
 * @property double $exchange_rate
 * @property string $isBaseCurrency
 * @property string $isActive
 */
class MasEmiratesList extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_emirates_list}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('country_id, emirates_name', 'required'),
            array('id,country_id', 'numerical', 'integerOnly' => true),
           
            array('emirates_name', 'length', 'max' => 255),
            array('emirates_name', 'unique'),            
            array('emirates_name', 'filter', 'filter'=>'trim'),
            
            array('id, country_id, emirates_name, created_by, updated_by, created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'emiratescountry' => array(self::BELONGS_TO, 'MasCountry','country_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'country_id' => 'Country',
            'emirates_name' => 'Emirates Name',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */

        public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('country_id',$this->country_id,true);
		$criteria->compare('emirates_name',$this->emirates_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCurrency the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getEmiratesList() {

        //$condition = 't.isActive =  "Y" AND t.company_id=' . Yii::app()->user->master_user_company_id;
        $condition = '1=1';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'emirates_name'));
        return CHtml::listData($model, 'id', 'emirates_name');
    }
    
    public static function getDefault() {
        return self::model()->find( array('condition'=>'isDefault="Y"') )->id;
    }
     public static function geHaveVat() {
        return self::model()->find( array('condition'=>'have_vat="N"') )->id;
    }

}
