<?php

/**
 * This is the model class for table "{{mas_currency}}".
 *
 * The followings are the available columns in table '{{mas_currency}}':
 * @property integer $id
 * @property integer $customer_ledger_id
 * @property integer $supplier_ledger_id
 * @property string $currency
 * @property string $currency_code
 * @property double $exchange_rate
 * @property string $isBaseCurrency
 * @property string $isActive
 */
class MasCurrency extends CActiveRecord
{

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{mas_currency}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('currency, currency_code', 'required'),
            array('id,customer_ledger_id,supplier_ledger_id', 'numerical', 'integerOnly' => true),
            array('exchange_rate', 'numerical'),
            array('currency, currency_code', 'length', 'max' => 255),
            array('currency', 'filter', 'filter' => 'trim'),
            array('currency, currency_code', 'unique'),
            array('isBaseCurrency,default_usage,isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,supplier_ledger_id,default_usage,customer_ledger_id,currency, currency_code, exchange_rate, isBaseCurrency, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 17;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' currency '.$this->currency;
        $model_audit_log->save();
    }
    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'baseCurrency' => array(self::HAS_MANY, 'MasCompanyBranch', 'currency_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'currency' => 'Currency',
            'currency_code' => 'Currency Code',
            'exchange_rate' => 'Exchange Rate',
            'isBaseCurrency' => 'Base Currency',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */

    public function search()
    {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('currency_name'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('currency like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.currency ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCurrency the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public static function getCurrency()
    {

        //$condition = 't.isActive =  "Y" AND t.company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 't.isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'isBaseCurrency, currency_code'));
        return CHtml::listData($model, 'id', 'currency_code');
    }

    public static function getCurrency_codes()
    {

        //$condition = 't.isActive =  "Y" AND t.company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 't.isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'isBaseCurrency,currency_code ASC'));
        return CHtml::listData($model, 'id', 'currency_code');
    }


    public static function base_exchange_rate()
    {
        return self::model()->find(array('select' => 'exchange_rate', 'condition' => 'isBaseCurrency="Y"'))->exchange_rate;
    }

    public static function base_currency_id()
    {
        return self::model()->find(array('select' => 'id', 'condition' => 'isBaseCurrency="Y"'))->id;
    }

    public static function base_currency_code()
    {
        return self::model()->find(array('select' => 'currency_code', 'condition' => 'isBaseCurrency="Y"'))->currency_code;
    }

    public static function Currencycode($currency_id = 0)
    {
        return self::model()->find(array(
            'select' => 'currency_code',
            'condition' => 'id=:currency_id',
            'params' => array(':currency_id' => $currency_id)
        ))->currency_code;
    }

    public static function getCurrencyDetails($id)
    {
        $model = self::model()->findByPk($id);
        return $model;
    }

    // public static function number_to_currency($number, $currency_id)
    // {
    //     if ($currency_id > 0) {
    //         $currenyModel = self::model()->findbypk($currency_id);
    //         $currency_array = explode('.', (string) $number);

    //         $currencyName = $currenyModel->currency_code . ' ' . ucfirst(Yii::app()->controller->widget('ext.NumtoWord.NumtoWord', array('num' => (int) $currency_array[0]))->result);
    //         // $currencyName .= ' '.$currenyModel->label;

    //         if ((int) $currency_array[1] > 0) {
    //             $currencyName .= ' and ' . ucfirst(Yii::app()->controller->widget('ext.NumtoWord.NumtoWord', array('num' => (int) $currency_array[1]))->result);
    //             $currencyName .= ' ' . $currenyModel->sub_label;
    //         }

    //         echo $currencyName . ' only';
    //     } else
    //         return 'Null';
    // }
public static function number_to_currency($number, $currency_id)
{
    if ($currency_id > 0) {

        $currenyModel = self::model()->findByPk($currency_id);

        // Always 2 decimals
        $currency_array = explode('.', number_format($number, 2, '.', ''));

        // Convert whole part
        $wholePart = Yii::app()->controller->widget(
            'ext.NumtoWord.NumtoWord',
            array('num' => (int)$currency_array[0])
        )->result;

        $wholePart = ucwords(strtolower($wholePart));

        $currencyName = $currenyModel->currency_code . ' ' . $wholePart;

        // Fraction (fils)
        $fraction = $currency_array[1];

        // Only add fils if > 0
        if ((int)$fraction > 0) {

            // Two digits
            $d1 = (int)$fraction[0];
            $d2 = (int)$fraction[1];

            // Convert each digit
            $digit1 = Yii::app()->controller->widget(
                'ext.NumtoWord.NumtoWord',
                array('num' => $d1)
            )->result;

            $digit2 = Yii::app()->controller->widget(
                'ext.NumtoWord.NumtoWord',
                array('num' => $d2)
            )->result;

            $digit1 = ucwords(strtolower($digit1));
            $digit2 = ucwords(strtolower($digit2));

            // ADD the missing sub_label (ex: "Fils")
            $currencyName .= " and {$digit1} {$digit2} " . $currenyModel->sub_label;
        }

        echo $currencyName . " Only";

    } else {
        return 'Null';
    }
}



    public static function baseCurrencyDecimalNumberFormat($number, $forExcel = false)
    {
        $decimal = self::model()->find(['select' => 'currency_decimal', 'condition' => 'isBaseCurrency = "Y"'])->currency_decimal ?? 2; // Default decimal places to 2 if not found
        $number = is_numeric($number) ? (float) $number : 0.0; // Ensure $number is numeric

        if ($forExcel) {
            // For Excel, use number_format with empty thousands separator
            $formatted_amount = number_format((float)$number, $decimal, '.', '');
        } else {
            // For regular formatting, use number_format with comma as thousands separator
            $formatted_amount = number_format($number, $decimal, '.', ',');
        }

        return $formatted_amount;
    }

    public static function baseCurrencyDefultDecimal()
    {
        $decimal = self::model()->find(['select' => 'currency_decimal', 'condition' => 'isBaseCurrency = "Y"'])->currency_decimal ?? 2; // Default decimal places to 2 if not found
        return $decimal;
    }

     public static function baseCurrencyForExcel()
    {
        $decimal = self::model()->find(['select' => 'currency_decimal', 'condition' => 'isBaseCurrency = "Y"'])->currency_decimal ?? 2; // Default decimal places to 2 if not found
        return ($decimal == 2) ? '0.00' : '0.000';
    } 


}
